/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.SrmConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.ConfigUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.RedissonUtil;
import com.els.common.util.SrmUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.CodeGenerator;
import com.els.modules.system.entity.CodeGeneratorDetail;
import com.els.modules.system.entity.CodeGeneratorSerial;
import com.els.modules.system.enums.ValueTypeEnum;
import com.els.modules.system.mapper.CodeGeneratorMapper;
import com.els.modules.system.service.CodeGeneratorDetailService;
import com.els.modules.system.service.CodeGeneratorSerialService;
import com.els.modules.system.service.CodeGeneratorService;
import com.els.modules.system.vo.CodeGeneratorVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class CodeGeneratorServiceImpl
extends BaseServiceImpl<CodeGeneratorMapper, CodeGenerator>
implements CodeGeneratorService {
    private static final String CODE_GENERATOR_VO_KEY = "srm:base:codeGenerator:vo:";
    private static final String CODE_GENERATOR_SERIAL_KEY = "srm:base:codeGenerator:serialKey:";
    private static final String CODE_GENERATOR_SERIAL_LOCK_KEY = "srm:base:codeGenerator:serialKey:lock:";
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private CodeGeneratorDetailService codeGeneratorItemService;
    @Resource
    private CodeGeneratorSerialService codeGeneratorSerialService;

    private void checkGenerator(CodeGenerator generator) {
        generator.setGeneratorCode(generator.getCodeType());
        if (StrUtil.isBlank((CharSequence)generator.getGeneratorCode())) {
            throw new ELSBootException("\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        long count = this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(CodeGenerator::getGeneratorCode, (Object)generator.getGeneratorCode())).ne(StrUtil.isNotBlank((CharSequence)generator.getId()), BaseEntity::getId, (Object)generator.getId()));
        if (count > 0L) {
            throw new ELSBootException("\u89c4\u5219\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff01");
        }
    }

    private String getSerialKeyRedisKeyByCode(String elsAccount, String generatorCode, String serialKey) {
        StringBuilder builder = new StringBuilder(CODE_GENERATOR_SERIAL_KEY);
        builder.append(elsAccount).append(":").append(generatorCode).append(":").append(serialKey);
        return builder.toString();
    }

    private String getSerialKeyLockRedisKeyByCode(String elsAccount, String generatorCode, String serialKey) {
        StringBuilder builder = new StringBuilder(CODE_GENERATOR_SERIAL_LOCK_KEY);
        builder.append(elsAccount).append(":").append(generatorCode).append(":").append(serialKey);
        return builder.toString();
    }

    private String getRedisKeyByCode(String elsAccount, String generatorCode) {
        StringBuilder builder = new StringBuilder(CODE_GENERATOR_VO_KEY);
        builder.append(elsAccount).append(":").append(generatorCode);
        return builder.toString();
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(CodeGenerator codeGenerator, List<CodeGeneratorDetail> codeGeneratorItemList, List<CodeGeneratorSerial> codeGeneratorSerialList) {
        this.checkGenerator(codeGenerator);
        ((CodeGeneratorMapper)this.baseMapper).insert((Object)codeGenerator);
        this.insertData(codeGenerator, codeGeneratorItemList, codeGeneratorSerialList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(CodeGenerator codeGenerator, List<CodeGeneratorDetail> codeGeneratorItemList, List<CodeGeneratorSerial> codeGeneratorSerialList) {
        this.checkGenerator(codeGenerator);
        int count = ((CodeGeneratorMapper)this.baseMapper).update((Object)codeGenerator, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(BaseEntity::getId, (Object)codeGenerator.getId())).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant()));
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.codeGeneratorItemService.deleteByMainId(codeGenerator.getId());
        this.insertData(codeGenerator, codeGeneratorItemList, codeGeneratorSerialList);
        this.redisUtil.del(new String[]{this.getRedisKeyByCode(TenantContext.getTenant(), codeGenerator.getGeneratorCode())});
    }

    private void insertData(CodeGenerator codeGenerator, List<CodeGeneratorDetail> codeGeneratorItemList, List<CodeGeneratorSerial> codeGeneratorSerialList) {
        if (!CollectionUtils.isEmpty(codeGeneratorItemList)) {
            for (CodeGeneratorDetail entity : codeGeneratorItemList) {
                entity.setGeneratorId(codeGenerator.getId());
            }
            this.codeGeneratorItemService.saveBatch(codeGeneratorItemList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        int count = ((CodeGeneratorMapper)this.baseMapper).delete((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(BaseEntity::getId, (Object)id)).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant()));
        if (count > 0) {
            this.codeGeneratorItemService.deleteByMainId(id);
            this.codeGeneratorSerialService.deleteByMainId(id);
        }
    }

    private CodeGeneratorVO getCodeGenerator(String elsAccount, String generatorCode) {
        String redisKey = this.getRedisKeyByCode(elsAccount, generatorCode);
        CodeGeneratorVO generatorVO = (CodeGeneratorVO)((Object)this.redisUtil.get(redisKey));
        if (generatorVO != null) {
            return generatorVO;
        }
        CodeGenerator codeGenerator = null;
        List list = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(CodeGenerator::getGeneratorCode, (Object)generatorCode));
        if (!list.isEmpty()) {
            codeGenerator = (CodeGenerator)((Object)list.get(0));
        }
        if (codeGenerator == null && !(list = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getElsAccount, (Object)ConfigUtil.getPurchaseAccount())).eq(CodeGenerator::getGeneratorCode, (Object)generatorCode))).isEmpty()) {
            codeGenerator = (CodeGenerator)((Object)list.get(0));
        }
        if (codeGenerator == null && !ConfigUtil.getPurchaseAccount().equals("100000") && !(list = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getElsAccount, (Object)"100000")).eq(CodeGenerator::getGeneratorCode, (Object)generatorCode))).isEmpty()) {
            codeGenerator = (CodeGenerator)((Object)list.get(0));
        }
        if (codeGenerator != null) {
            CodeGeneratorVO vo = new CodeGeneratorVO();
            BeanUtils.copyProperties((Object)((Object)codeGenerator), (Object)((Object)vo));
            vo.setCodeGeneratorDetailList(this.codeGeneratorItemService.selectByMainId(vo.getId()));
            this.redisUtil.set(redisKey, (Object)vo);
            return vo;
        }
        throw new ELSBootException("\u7f16\u7801\u89c4\u5219\u4e0d\u5b58\u5728\uff01");
    }

    private String getValue(CodeGeneratorDetail item, Object businessObj) {
        String value = "";
        if (ValueTypeEnum.FIXED.getCode().equals(item.getValueType())) {
            value = item.getValue();
        } else if (ValueTypeEnum.VARIABLE.getCode().equals(item.getValueType())) {
            value = (String)ReflectUtil.getFieldValue((Object)businessObj, (String)item.getValue());
        } else if (ValueTypeEnum.EXPRESSION.getCode().equals(item.getValueType())) {
            value = DateUtil.format((Date)DateUtil.date(), (String)item.getValue());
        }
        return value;
    }

    private String getSerialNo(CodeGeneratorVO generatorVO, String serialKey) {
        String redisKey = this.getSerialKeyRedisKeyByCode(generatorVO.getElsAccount(), generatorVO.getGeneratorCode(), serialKey);
        if (!this.redisUtil.hasKey(redisKey)) {
            String lockKey = this.getSerialKeyLockRedisKeyByCode(generatorVO.getElsAccount(), generatorVO.getGeneratorCode(), serialKey);
            boolean lock = RedissonUtil.tryRlock((String)lockKey, (long)30L);
            Long serialNumber = 1L;
            if (lock) {
                try {
                    if (this.redisUtil.hasKey(redisKey)) {
                        serialNumber = this.redisUtil.incr(redisKey, 1L);
                        SrmUtil.getTheadPool().execute(() -> this.codeGeneratorSerialService.incr(generatorVO.getId(), serialKey));
                        String string = serialNumber.toString();
                        return string;
                    }
                    CodeGeneratorSerial generatorSerial = (CodeGeneratorSerial)((Object)this.codeGeneratorSerialService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CodeGeneratorSerial::getGeneratorId, (Object)generatorVO.getId())).eq(CodeGeneratorSerial::getSerialKey, (Object)serialKey)));
                    if (generatorSerial != null) {
                        serialNumber = generatorSerial.getSerialValue() + 1L;
                        this.redisUtil.setIncr(redisKey, (Object)serialNumber, 86400L);
                        SrmUtil.getTheadPool().execute(() -> this.codeGeneratorSerialService.incr(generatorVO.getId(), serialKey));
                    } else {
                        this.redisUtil.setIncr(redisKey, (Object)serialNumber, 86400L);
                        CodeGeneratorSerial serial = new CodeGeneratorSerial();
                        serial.setElsAccount(generatorVO.getElsAccount());
                        serial.setGeneratorId(generatorVO.getId());
                        serial.setSerialKey(serialKey);
                        serial.setSerialValue(serialNumber);
                        SrmUtil.getTheadPool().execute(() -> this.codeGeneratorSerialService.save((Object)serial));
                    }
                    String string = serialNumber.toString();
                    return string;
                }
                catch (Exception e) {
                    throw new ELSBootException("\u751f\u6210\u6d41\u6c34\u53f7\u5931\u8d25\uff01\u539f\u56e0\uff1a" + e.getMessage());
                }
                finally {
                    RedissonUtil.unRlock((String)lockKey);
                }
            }
            throw new ELSBootException("\u7cfb\u7edf\u7e41\u5fd9\uff0c\u751f\u6210\u6d41\u6c34\u53f7\u5931\u8d25\uff01");
        }
        Long serialNumber = this.redisUtil.incr(redisKey, 1L);
        SrmUtil.getTheadPool().execute(() -> this.codeGeneratorSerialService.incr(generatorVO.getId(), serialKey));
        return serialNumber.toString();
    }

    private Map<String, Object> builderCode(List<CodeGeneratorDetail> itemList, Object businessObj) {
        HashMap<String, Object> codeMap = new HashMap<String, Object>();
        StringBuilder serialKey = new StringBuilder();
        StringBuilder codeBuilder = new StringBuilder();
        int serialLength = 0;
        for (CodeGeneratorDetail item : itemList) {
            if (!ValueTypeEnum.SERIAL.getCode().equals(item.getValueType())) {
                String value = this.getValue(item, businessObj);
                codeBuilder.append(value);
                if (SrmConstant.YES_1 != item.getSerialKey()) continue;
                serialKey.append(value);
                continue;
            }
            serialLength = item.getValueLength();
        }
        codeMap.put("serialKey", serialKey);
        codeMap.put("codeBuilder", codeBuilder);
        codeMap.put("serialLength", serialLength);
        return codeMap;
    }

    @Override
    @Transactional(propagation=Propagation.NOT_SUPPORTED, readOnly=true)
    public String getNextCode(String elsAccount, String generatorCode, Object businessObj) {
        CodeGeneratorVO generatorVO = this.getCodeGenerator(elsAccount, generatorCode);
        List<CodeGeneratorDetail> itemList = generatorVO.getCodeGeneratorDetailList();
        Map<String, Object> codeMap = this.builderCode(itemList, businessObj);
        StringBuilder serialKey = (StringBuilder)codeMap.get("serialKey");
        StringBuilder codeBuilder = (StringBuilder)codeMap.get("codeBuilder");
        int serialLength = (Integer)codeMap.get("serialLength");
        String serialNo = "";
        if (serialLength > 0 && (serialNo = this.getSerialNo(generatorVO, serialKey.toString())).length() < serialLength) {
            serialNo = StrUtil.fillBefore((String)serialNo, (char)'0', (int)serialLength);
        }
        codeBuilder.append(serialNo);
        return codeBuilder.toString();
    }

    @Override
    @Transactional(propagation=Propagation.NOT_SUPPORTED, readOnly=true)
    public List<String> getNextCodeList(String elsAccount, String generatorCode, Object businessObj, int count) {
        ArrayList<String> resultList = new ArrayList<String>();
        CodeGeneratorVO generatorVO = this.getCodeGenerator(elsAccount, generatorCode);
        List<CodeGeneratorDetail> itemList = generatorVO.getCodeGeneratorDetailList();
        Map<String, Object> codeMap = this.builderCode(itemList, businessObj);
        StringBuilder serialKey = (StringBuilder)codeMap.get("serialKey");
        StringBuilder codeBuilder = (StringBuilder)codeMap.get("codeBuilder");
        int serialLength = (Integer)codeMap.get("serialLength");
        for (int i = 0; i < count; ++i) {
            String serialNo = "";
            String codeStr = codeBuilder.toString();
            if (serialLength > 0 && (serialNo = this.getSerialNo(generatorVO, serialKey.toString())).length() < serialLength) {
                serialNo = StrUtil.fillBefore((String)serialNo, (char)'0', (int)serialLength);
            }
            resultList.add(codeStr + serialNo);
        }
        return resultList;
    }

    @Override
    @Transactional(propagation=Propagation.NOT_SUPPORTED, readOnly=true)
    public List<String> getNextCodeList(String elsAccount, String generatorCode, List<Object> businessObjList) {
        ArrayList<String> resultList = new ArrayList<String>();
        if (businessObjList == null || businessObjList.isEmpty()) {
            return resultList;
        }
        CodeGeneratorVO generatorVO = this.getCodeGenerator(elsAccount, generatorCode);
        List<CodeGeneratorDetail> itemList = generatorVO.getCodeGeneratorDetailList();
        for (Object businessObj : businessObjList) {
            Map<String, Object> codeMap = this.builderCode(itemList, businessObj);
            StringBuilder serialKey = (StringBuilder)codeMap.get("serialKey");
            StringBuilder codeBuilder = (StringBuilder)codeMap.get("codeBuilder");
            int serialLength = (Integer)codeMap.get("serialLength");
            String serialNo = "";
            if (serialLength > 0 && (serialNo = this.getSerialNo(generatorVO, serialKey.toString())).length() < serialLength) {
                serialNo = StrUtil.fillBefore((String)serialNo, (char)'0', (int)serialLength);
            }
            codeBuilder.append(serialNo);
            resultList.add(codeBuilder.toString());
        }
        return resultList;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void addToCompany(String id) {
        CodeGenerator codeGenerator = (CodeGenerator)((Object)this.getById((Serializable)((Object)id)));
        if (codeGenerator == null) {
            throw new ELSBootException("\u64cd\u4f5c\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u8f93\u5165\u53c2\u6570");
        }
        List<CodeGeneratorDetail> itemList = this.codeGeneratorItemService.selectByMainId(id);
        CodeGenerator companyGenerator = null;
        List list = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(CodeGenerator::getGeneratorCode, (Object)codeGenerator.getGeneratorCode()));
        if (!list.isEmpty()) {
            companyGenerator = (CodeGenerator)((Object)list.get(0));
        }
        if (companyGenerator != null) {
            this.codeGeneratorItemService.deleteByMainId(companyGenerator.getId());
            this.updateById((Object)companyGenerator);
        } else {
            companyGenerator = new CodeGenerator();
            BeanUtils.copyProperties((Object)((Object)codeGenerator), (Object)((Object)companyGenerator));
            SrmUtil.cleanBaseEntity((BaseEntity)companyGenerator);
            companyGenerator.setId(IdWorker.getIdStr());
            companyGenerator.setElsAccount(TenantContext.getTenant());
            this.save((Object)companyGenerator);
        }
        ArrayList<CodeGeneratorDetail> insertList = new ArrayList<CodeGeneratorDetail>();
        for (CodeGeneratorDetail item : itemList) {
            CodeGeneratorDetail generatorItem = new CodeGeneratorDetail();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)generatorItem));
            SrmUtil.cleanBaseEntity((BaseEntity)generatorItem);
            generatorItem.setId(IdWorker.getIdStr());
            generatorItem.setGeneratorId(companyGenerator.getId());
            generatorItem.setElsAccount(TenantContext.getTenant());
            insertList.add(generatorItem);
        }
        if (CollUtil.isNotEmpty(insertList)) {
            this.codeGeneratorItemService.saveBatch(insertList);
        }
        String redisKey = this.getRedisKeyByCode(TenantContext.getTenant(), companyGenerator.getGeneratorCode());
        this.redisUtil.del(new String[]{redisKey});
    }

    @Override
    public CodeGeneratorVO queryById(String id, String elsAccount) {
        CodeGenerator codeGenerator = (CodeGenerator)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getId, (Object)id)).eq(BaseEntity::getElsAccount, (Object)elsAccount)));
        if (codeGenerator == null) {
            throw new ELSBootException("id not exist!");
        }
        CodeGeneratorVO codeGeneratorVO = new CodeGeneratorVO();
        BeanUtils.copyProperties((Object)((Object)codeGenerator), (Object)((Object)codeGeneratorVO));
        List<CodeGeneratorDetail> codeGeneratorItemList = this.codeGeneratorItemService.selectByMainId(id);
        codeGeneratorVO.setCodeGeneratorDetailList(codeGeneratorItemList);
        List<CodeGeneratorSerial> codeGeneratorSerialList = this.codeGeneratorSerialService.selectByMainId(id);
        codeGeneratorVO.setCodeGeneratorSerialList(codeGeneratorSerialList);
        return codeGeneratorVO;
    }

    @Override
    public String getNextCode(String generatorCode, Object businessObj) {
        return this.getNextCode(TenantContext.getTenant(), generatorCode, businessObj);
    }
}

