/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.api.dto.ElsEmailConfigDTO;
import com.els.api.dto.ElsEmailSendLogDto;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ElsEmailSendLog;
import com.els.modules.system.mapper.ElsEmailSendLogMapper;
import com.els.modules.system.rpc.service.BaseInvokeMessageRpcService;
import com.els.modules.system.service.ElsEmailSendLogService;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Service;

@Service
public class ElsEmailSendLogServiceImpl
extends BaseServiceImpl<ElsEmailSendLogMapper, ElsEmailSendLog>
implements ElsEmailSendLogService {
    private static final Logger log = LoggerFactory.getLogger(ElsEmailSendLogServiceImpl.class);
    @Autowired
    private BaseInvokeMessageRpcService baseInvokeMessageRpcService;
    @Autowired
    private ThreadPoolTaskScheduler taskScheduler;

    @Override
    public void saveOrUpdate(ElsEmailConfigDTO config, boolean result, String msg) {
        ElsEmailSendLog sendLog;
        log.info("ElsEmailSendLogServiceImpl \u4fdd\u5b58\u90ae\u4ef6\u53d1\u9001\u8bb0\u5f55");
        if (CharSequenceUtil.isNotEmpty((CharSequence)config.getSendLogId()) && null != (sendLog = (ElsEmailSendLog)((Object)this.getById((Serializable)((Object)config.getSendLogId()))))) {
            sendLog.setSendStatus(result ? "1" : "0");
            sendLog.setFromEmailUsername(config.getEmailUsername());
            sendLog.setRetryCount(sendLog.getRetryCount() + 1);
            sendLog.setMsgItemConfigContent(config.getMsgVO());
            config.setMsgVO(null);
            sendLog.setMsgConfigContent(JSON.toJSONString((Object)config));
            sendLog.setErrorMsg(msg);
            sendLog.setEmailHost(config.getEmailHost());
            ((ElsEmailSendLogMapper)this.baseMapper).updateById((Object)sendLog);
            return;
        }
        sendLog = new ElsEmailSendLog();
        String currentElsAccount = config.getCurrentElsAccount();
        if (CharSequenceUtil.isEmpty((CharSequence)currentElsAccount)) {
            currentElsAccount = config.getElsAccount();
        }
        sendLog.setElsAccount(currentElsAccount);
        sendLog.setEmailHost(config.getEmailHost());
        sendLog.setFromEmailUsername(config.getEmailUsername());
        sendLog.setErrorMsg(msg);
        sendLog.setSendStatus(result ? "1" : "0");
        sendLog.setRetryCount(0);
        if (null != config.getBcc()) {
            sendLog.setEmailBc(String.join((CharSequence)",", config.getBcc()));
        }
        sendLog.setEmailCc(config.getEmailCc());
        sendLog.setSubject(config.getSubject());
        sendLog.setContent(config.getContent());
        if (null != config.getTo()) {
            sendLog.setEmailTo(String.join((CharSequence)",", config.getTo()));
        }
        sendLog.setMsgItemConfigContent(config.getMsgVO());
        config.setMsgVO(null);
        sendLog.setMsgConfigContent(JSON.toJSONString((Object)config));
        this.save((Object)sendLog);
        log.info("ElsEmailSendLogServiceImpl \u4fdd\u5b58\u90ae\u4ef6\u53d1\u9001\u8bb0\u5f55\u5b8c\u6210");
        if ("1".equals(sendLog.getSendStatus())) {
            return;
        }
        try {
            this.taskScheduler.schedule(() -> {
                log.info("##autoRetry \u5931\u8d25\u90ae\u4ef6\u81ea\u52a8\u91cd\u5c1d\u53d1\u90011\u6b21,\u8bb0\u5f55id:{}", (Object)sendLog.getId());
                this.retry(sendLog.getId());
            }, (Date)DateUtil.offsetSecond((Date)new Date(), (int)10));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void retry(String id) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(BaseEntity::getId, (Object)id);
        ElsEmailSendLog sendLog = (ElsEmailSendLog)((Object)((ElsEmailSendLogMapper)this.baseMapper).selectOne((Wrapper)wrapper));
        if (null == sendLog) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_jItHxMK_1092eed0", (String)"\u90ae\u4ef6\u8bb0\u5f55\u4e0d\u5b58\u5728"));
        }
        ElsEmailSendLogDto config = new ElsEmailSendLogDto();
        BeanUtils.copyProperties((Object)((Object)sendLog), (Object)config);
        if (CharSequenceUtil.isNotEmpty((CharSequence)sendLog.getAttachmentPath())) {
            config.setAttachmentPathList(JSONArray.parseArray((String)sendLog.getAttachmentPath(), String.class));
        }
        if (CharSequenceUtil.isNotEmpty((CharSequence)sendLog.getInlineAttachmentPath())) {
            HashMap map = (HashMap)JSONArray.parseObject((String)sendLog.getInlineAttachmentPath(), HashMap.class);
            config.setInlineAttachmentPathMap(map);
        }
        config.setSendLogId(id);
        this.baseInvokeMessageRpcService.retrySendEmail(config);
    }
}

