/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.util.IdUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.InterfaceApp;
import com.els.modules.system.mapper.InterfaceAppMapper;
import com.els.modules.system.service.InterfaceAppService;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InterfaceAppServiceImpl
extends BaseServiceImpl<InterfaceAppMapper, InterfaceApp>
implements InterfaceAppService {
    public static final String REDIS_KEY = "interface:app:";
    @Resource
    private RedisUtil redisUtil;

    @Override
    @Transactional
    public void saveInterfaceApp(InterfaceApp interfaceApp) {
        interfaceApp.setElsAccount(TenantContext.getTenant());
        interfaceApp.setAppKey(IdUtil.randomUUID().split("-")[0]);
        interfaceApp.setAppSecret(IdUtil.simpleUUID());
        ((InterfaceAppMapper)this.baseMapper).insert((Object)interfaceApp);
    }

    @Override
    @Transactional
    public void updateInterfaceApp(InterfaceApp interfaceApp) {
        ((InterfaceAppMapper)this.baseMapper).updateById((Object)interfaceApp);
    }

    @Override
    @Transactional
    public void delInterfaceApp(String id) {
        ((InterfaceAppMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public String resetSecret(String id) {
        InterfaceApp app = (InterfaceApp)((Object)((InterfaceAppMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (app == null) {
            throw new ELSBootException("\u5e94\u7528\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01");
        }
        InterfaceApp updateApp = new InterfaceApp();
        updateApp.setId(id);
        updateApp.setAppSecret(IdUtil.simpleUUID());
        ((InterfaceAppMapper)this.baseMapper).updateById((Object)updateApp);
        String redisKey = REDIS_KEY + app.getAppKey() + app.getAppSecret();
        this.redisUtil.del(new String[]{redisKey});
        this.redisUtil.del(new String[]{REDIS_KEY + app.getId()});
        return updateApp.getAppSecret();
    }

    @Override
    public void startOrStop(String id) {
        InterfaceApp app = (InterfaceApp)((Object)((InterfaceAppMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (app == null) {
            throw new ELSBootException("\u5e94\u7528\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01");
        }
        String appStatus = app.getAppStatus();
        appStatus = "0".equals(appStatus) ? "1" : "0";
        InterfaceApp updateApp = new InterfaceApp();
        updateApp.setId(id);
        updateApp.setAppStatus(appStatus);
        ((InterfaceAppMapper)this.baseMapper).updateById((Object)updateApp);
        String redisKey = REDIS_KEY + app.getAppKey() + app.getAppSecret();
        this.redisUtil.del(new String[]{REDIS_KEY + app.getId()});
        this.redisUtil.del(new String[]{redisKey});
    }

    @Override
    public InterfaceApp getApp(String appKey, String appSecret) {
        String redisKey = REDIS_KEY + appKey + appSecret;
        InterfaceApp app = (InterfaceApp)((Object)this.redisUtil.get(redisKey));
        if (app == null) {
            app = (InterfaceApp)((Object)((InterfaceAppMapper)this.baseMapper).selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"app_key", (Object)appKey)).eq((Object)"app_secret", (Object)appSecret)));
            this.redisUtil.set(redisKey, (Object)app, 2L);
        }
        return app;
    }

    @Override
    public InterfaceApp getApp(String appId) {
        String redisKey = REDIS_KEY + appId;
        InterfaceApp app = (InterfaceApp)((Object)this.redisUtil.get(redisKey));
        if (app == null) {
            app = (InterfaceApp)((Object)((InterfaceAppMapper)this.baseMapper).selectById((Serializable)((Object)appId)));
            this.redisUtil.set(redisKey, (Object)app, 2L);
        }
        return app;
    }
}

