/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.account.api.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.SrmPageDTO;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SrmUtil;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.account.api.service.AccountInfoRpcService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.UserRoleService;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;

@RpcService
public class AccountInfoBeanServiceImpl
implements AccountInfoRpcService {
    @Resource
    private ElsSubAccountService subAccountService;
    @Resource
    private UserRoleService roleAccountService;
    @Resource
    private UserRoleService userRoleService;

    public LoginUserDTO getLoginUserByAccount(String elsAccount, String subAccount) {
        return this.subAccountService.getLoginUserByAccount(elsAccount, subAccount);
    }

    public String getAdminFlagByAccountId(String accountId) {
        return this.userRoleService.getAdminFlagByAccountId(accountId);
    }

    public SrmPageDTO<ElsSubAccountDTO> getAccountPage(int currentPage, int pageSize, String elsAccount, String fullName, String subAccount, String workNo, String photo, String deptId, boolean admin) {
        Page page = new Page((long)currentPage, (long)pageSize);
        List<Object> accountIdList = new ArrayList();
        if (admin) {
            accountIdList = this.roleAccountService.getAccountIdByRoleCode(elsAccount, "companyAdmin");
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ElsSubAccount.class).in(admin && CollectionUtil.isNotEmpty(accountIdList), ParentEntity::getId, accountIdList)).eq(ParentEntity::getElsAccount, (Object)elsAccount)).eq(StrUtil.isNotBlank((CharSequence)deptId), ElsSubAccount::getDeptId, (Object)deptId)).eq(StrUtil.isNotBlank((CharSequence)workNo), ElsSubAccount::getWorkNo, (Object)workNo)).like(StrUtil.isNotBlank((CharSequence)fullName), ElsSubAccount::getRealname, (Object)fullName)).like(StrUtil.isNotBlank((CharSequence)subAccount), ElsSubAccount::getSubAccount, (Object)subAccount)).likeRight(StrUtil.isNotBlank((CharSequence)photo), ElsSubAccount::getPhone, (Object)photo)).orderByAsc(ParentEntity::getId);
        IPage accountInfoPage = ((Page)this.subAccountService.page((IPage)page, (Wrapper)queryWrapper)).convert(accountInfo -> {
            ElsSubAccountDTO accountInfoDTO = new ElsSubAccountDTO();
            BeanUtils.copyProperties((Object)accountInfo, (Object)accountInfoDTO);
            return accountInfoDTO;
        });
        return new SrmPageDTO(page.getTotal(), page.getPages(), accountInfoPage.getRecords());
    }

    public List<ElsSubAccountDTO> getUsersByUserIdList(List<String> userIdList) {
        List elsSubAccounts = this.subAccountService.listByIds(userIdList);
        return SysUtil.copyProperties((List)elsSubAccounts, ElsSubAccountDTO.class);
    }

    public ElsSubAccountDTO getAccountInfoById(String accountId) {
        ElsSubAccount dbAccountInfo = this.subAccountService.getSubAccountById(accountId);
        if (null == dbAccountInfo) {
            throw new ELSBootException(I18nUtil.translate((String)"\u8be5\u7528\u6237\u4e0d\u5b58\u5728"));
        }
        ElsSubAccountDTO dto = (ElsSubAccountDTO)SrmUtil.copyProperties((Object)((Object)dbAccountInfo), ElsSubAccountDTO.class);
        return dto;
    }

    public List<String> queryAllSubAccount(List<String> elsAccount) {
        return this.subAccountService.queryAllSubAccount(elsAccount);
    }
}

