/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.cache.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.cache.entity.ElsMybatisCacheInfo;
import com.els.modules.cache.service.ElsMybatisCacheInfoService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="mybatis\u7f13\u5b58\u4fe1\u606f")
@RestController
@RequestMapping(value={"/cache/elsMybatisCacheInfo"})
public class ElsMybatisCacheInfoController
extends BaseController<ElsMybatisCacheInfo, ElsMybatisCacheInfoService> {
    @Autowired
    private ElsMybatisCacheInfoService elsMybatisCacheInfoService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(ElsMybatisCacheInfo elsMybatisCacheInfo, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsMybatisCacheInfo), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsMybatisCacheInfoService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="mybatis\u7f13\u5b58\u4fe1\u606f-\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody ElsMybatisCacheInfo elsMybatisCacheInfo) {
        this.elsMybatisCacheInfoService.add(elsMybatisCacheInfo);
        return Result.ok((Object)((Object)elsMybatisCacheInfo));
    }

    @AutoLog(value="mybatis\u7f13\u5b58\u4fe1\u606f-\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ElsMybatisCacheInfo elsMybatisCacheInfo) {
        this.elsMybatisCacheInfoService.edit(elsMybatisCacheInfo);
        String id = elsMybatisCacheInfo.getId();
        return this.queryById(id);
    }

    @AutoLog(value="mybatis\u7f13\u5b58\u4fe1\u606f-\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.elsMybatisCacheInfoService.delete(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="mybatis\u7f13\u5b58\u4fe1\u606f-\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.elsMybatisCacheInfoService.deleteBatch(idList);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        ElsMybatisCacheInfo elsMybatisCacheInfo = (ElsMybatisCacheInfo)((Object)this.elsMybatisCacheInfoService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)elsMybatisCacheInfo));
    }

    @Operation(summary="\u6839\u636eid\u6e05\u9664redis\u7f13\u5b58", description="\u6839\u636eid\u6e05\u9664redis\u7f13\u5b58")
    @GetMapping(value={"/clearCacheById"})
    public Result<?> clearCacheById(@RequestParam(name="id") String id) {
        this.elsMybatisCacheInfoService.clearCache(id);
        return Result.ok();
    }
}

