/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quartz.controller;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.quartz.entity.QuartzJob;
import com.els.modules.quartz.excel.QuartzJobExportServiceImpl;
import com.els.modules.quartz.job.BaseJob;
import com.els.modules.quartz.service.IQuartzJobService;
import com.els.modules.quartz.utils.ElsCronExpressionUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.quartz.CronExpression;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/job/quartzJob"})
@Tag(name="\u5b9a\u65f6\u4efb\u52a1\u63a5\u53e3")
public class QuartzJobController
extends BaseController<QuartzJob, IQuartzJobService> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuartzJobController.class);
    @Autowired
    private IQuartzJobService quartzJobService;
    @Autowired
    private Scheduler scheduler;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"quartzJob#QuartzJob:list"})
    @PermissionDataView(businessType="quartzJob")
    public Result<?> queryPageList(QuartzJob quartzJob, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)quartzJob), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.quartzJobService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u5b9a\u65f6\u4efb\u52a1-\u6dfb\u52a0", logType=2, operateType=2)
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"quartzJob#QuartzJob:add"})
    @PermissionDataOpt(businessType="quartzJob", beanClass=IQuartzJobService.class)
    public Result<?> add(@RequestBody QuartzJob quartzJob) {
        List<QuartzJob> list = this.quartzJobService.findByJobNameKey(quartzJob.getJobNameKey());
        if (list != null && list.size() > 0) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_rIKLSAoIMK_ce946210", (String)"\u8be5\u5b9a\u65f6\u4efb\u52a1\u7f16\u7801\u5df2\u5b58\u5728"));
        }
        if (quartzJob.getCronExpression() == null || !CronExpression.isValidExpression((String)quartzJob.getCronExpression())) {
            throw new ELSBootException("Cron \u8868\u8fbe\u5f0f\u9519\u8bef!");
        }
        if (DateUtil.between((Date)ElsCronExpressionUtil.getThirdTime(quartzJob.getCronExpression()), (Date)ElsCronExpressionUtil.getNextTime(quartzJob.getCronExpression()), (DateUnit)DateUnit.MINUTE) < Long.valueOf("30")) {
            throw new ELSBootException("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u65f6\u95f4\u81f3\u5c11\u95f4\u969430\u5206\u949f");
        }
        this.quartzJobService.saveAndScheduleJob(quartzJob);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_cIIKLSLRW_d5f97451", (String)"\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u6210\u529f"));
    }

    @SrmValidated
    @AutoLog(value="\u5b9a\u65f6\u4efb\u52a1-\u7f16\u8f91", logType=2, operateType=3)
    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"quartzJob#QuartzJob:edit"})
    @PermissionDataOpt(businessType="quartzJob", beanClass=IQuartzJobService.class)
    public Result<?> eidt(@RequestBody QuartzJob quartzJob) {
        if (quartzJob.getCronExpression() == null || !CronExpression.isValidExpression((String)quartzJob.getCronExpression())) {
            throw new ELSBootException("Cron \u8868\u8fbe\u5f0f\u9519\u8bef!");
        }
        if (DateUtil.between((Date)ElsCronExpressionUtil.getThirdTime(quartzJob.getCronExpression()), (Date)ElsCronExpressionUtil.getNextTime(quartzJob.getCronExpression()), (DateUnit)DateUnit.MINUTE) < Long.valueOf("30")) {
            throw new ELSBootException("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u65f6\u95f4\u81f3\u5c11\u95f4\u969430\u5206\u949f");
        }
        try {
            this.quartzJobService.editAndScheduleJob(quartzJob);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_HVIKLSKmW_fdaf8aef", (String)"\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25!") + e.getMessage());
        }
        String id = quartzJob.getId();
        return this.queryById(id);
    }

    @AutoLog(value="\u5b9a\u65f6\u4efb\u52a1-\u6839\u636eID\u5220\u9664", logType=2, operateType=4)
    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"quartzJob#QuartzJob:delete"})
    @PermissionDataOpt(businessType="quartzJob", beanClass=IQuartzJobService.class)
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        QuartzJob quartzJob = (QuartzJob)((Object)this.quartzJobService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        if (quartzJob == null) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_LYuIdjKD_4c20dac2", (String)"\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53"));
        }
        this.quartzJobService.deleteAndStopJob(quartzJob);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_deleteSuccess", (String)"\u5220\u9664\u6210\u529f!"));
    }

    @AutoLog(value="\u5b9a\u65f6\u4efb\u52a1-\u6839\u636eID\u6279\u91cf\u5220\u9664", logType=2, operateType=4)
    @RequestMapping(value={"/deleteBatch"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"quartzJob#QuartzJob:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        if (ids == null || "".equals(ids.trim())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_sWxKqW_a84a623d", (String)"\u53c2\u6570\u4e0d\u8bc6\u522b"));
        }
        for (String id : Arrays.asList(ids.split(","))) {
            QuartzJob job = (QuartzJob)((Object)this.quartzJobService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
            this.quartzJobService.deleteAndStopJob(job);
        }
        return Result.ok((String)I18nUtil.translate((String)"\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u6210\u529f!", (String)"\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u6210\u529f\uff01"));
    }

    @AutoLog(value="\u5b9a\u65f6\u4efb\u52a1-\u6682\u505c", logType=2, operateType=3)
    @GetMapping(value={"/pause"})
    @Operation(summary="\u6682\u505c\u5b9a\u65f6\u4efb\u52a1")
    @RequiresPermissions(value={"quartzJob#QuartzJob:pause"})
    public Result<Object> pauseJob(@RequestParam(name="jobNameKey", required=true) String jobNameKey) {
        QuartzJob job = null;
        try {
            job = (QuartzJob)((Object)this.quartzJobService.getOne((Wrapper)new LambdaQueryWrapper().eq(QuartzJob::getJobNameKey, (Object)jobNameKey)));
            if (job == null) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_IKLSxMKW_aa9815a6", (String)"\u5b9a\u65f6\u4efb\u52a1\u4e0d\u5b58\u5728\uff01"));
            }
            this.scheduler.pauseJob(JobKey.jobKey((String)jobNameKey.trim()));
        }
        catch (SchedulerException e) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_PYIKLSKm_7f3f21d0", (String)"\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25"));
        }
        job.setStatus(CommonConstant.STATUS_DISABLE);
        this.quartzJobService.updateById((Object)job);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_PYIKLSLRW_68bf4f36", (String)"\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u6210\u529f\uff01"));
    }

    @AutoLog(value="\u5b9a\u65f6\u4efb\u52a1-\u6062\u590d", logType=2, operateType=3)
    @GetMapping(value={"/resume"})
    @Operation(summary="\u6062\u590d\u5b9a\u65f6\u4efb\u52a1")
    @RequiresPermissions(value={"quartzJob#QuartzJob:resume"})
    public Result<Object> resumeJob(@RequestParam(name="jobNameKey", required=true) String jobNameKey) {
        QuartzJob job = (QuartzJob)((Object)this.quartzJobService.getOne((Wrapper)new LambdaQueryWrapper().eq(QuartzJob::getJobNameKey, (Object)jobNameKey)));
        if (job == null) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_IKLSxMKW_aa9815a6", (String)"\u5b9a\u65f6\u4efb\u52a1\u4e0d\u5b58\u5728\uff01"));
        }
        this.quartzJobService.resumeJob(job);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_MBIKLSLRW_21ae6745", (String)"\u6062\u590d\u5b9a\u65f6\u4efb\u52a1\u6210\u529f\uff01"));
    }

    @RequestMapping(value={"/queryById"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"quartzJob#QuartzJob:view"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        QuartzJob quartzJob = (QuartzJob)((Object)this.quartzJobService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)quartzJob));
    }

    @RequestMapping(value={"/manualExecute"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"quartzJob#QuartzJob:manualExecute"})
    public Result<?> manualExecute(@RequestParam(name="id", required=true) String id) {
        QuartzJob quartzJob = (QuartzJob)((Object)this.quartzJobService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        if (quartzJob == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IKLSxMKW_aa9815a6", (String)"\u5b9a\u65f6\u4efb\u52a1\u4e0d\u5b58\u5728\uff01"));
        }
        try {
            BaseJob baseJob = (BaseJob)Class.forName(quartzJob.getJobClassName()).newInstance();
            baseJob.executeBusiness(quartzJob.getParameter());
        }
        catch (Exception e) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RcKmWWWWW_5f5e6fec", (String)"\u6267\u884c\u5931\u8d25\uff01") + e.getMessage(), (Throwable)e, new String[0]);
        }
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_RcLRW_aa1af96d", (String)"\u6267\u884c\u6210\u529f"));
    }

    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"quartzJob#QuartzJob:export"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, QuartzJobExportServiceImpl.class);
    }
}

