/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.RedisUtil;
import com.els.modules.system.entity.SubaccountOrg;
import com.els.modules.system.mapper.SubaccountOrgMapper;
import com.els.modules.system.service.SubaccountOrgService;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class SubaccountOrgServiceImpl
extends BaseServiceImpl<SubaccountOrgMapper, SubaccountOrg>
implements SubaccountOrgService {
    public static final String REDIS_KEY_USER_ORG = "sys:org:user:";
    @Resource
    private RedisUtil redisUtil;

    @Override
    public List<SubaccountOrg> selectByMainId(String mainId) {
        return ((SubaccountOrgMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((SubaccountOrgMapper)this.baseMapper).deleteByMainId(mainId);
    }

    @Override
    public Map<String, String> getUserOrg(String userId) {
        HashMap<String, String> resultMap = (HashMap<String, String>)this.redisUtil.get(REDIS_KEY_USER_ORG + userId);
        if (resultMap == null) {
            List<SubaccountOrg> userOrgList = this.selectByMainId(userId);
            resultMap = new HashMap<String, String>();
            Map<String, List<SubaccountOrg>> orgMap = userOrgList.stream().collect(Collectors.groupingBy(SubaccountOrg::getOrgCategoryCode));
            for (String categoryCode : orgMap.keySet()) {
                List<SubaccountOrg> list = orgMap.get(categoryCode);
                resultMap.put(categoryCode, list.stream().map(SubaccountOrg::getOrgCode).collect(Collectors.joining(",")));
            }
            this.redisUtil.set(REDIS_KEY_USER_ORG + userId, resultMap);
        }
        return resultMap;
    }
}

