/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.linereport.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.history.entity.ElsInitialTable;
import com.els.modules.history.service.ElsInitialTableService;
import com.els.modules.linereport.api.dto.LineDifferenceItemDto;
import com.els.modules.linereport.api.dto.SaleEnquiryHeadLpDTO;
import com.els.modules.linereport.api.dto.SaleEnquiryItemLpDTO;
import com.els.modules.linereport.service.LineDifferenceReportService;
import com.els.modules.linereport.service.rpc.service.LineDifferenceReportApiRpcService;
import com.els.modules.linereport.util.LpCustomCellWriteHandler;
import com.els.modules.linereport.util.LpExcelCellStyleStrategy;
import com.els.modules.linereport.util.QuoteTemplateCellWriteHandler;
import com.els.modules.linereport.util.QuoteTemplateExcelCellStyleStrategy;
import com.els.modules.linereport.util.QuoteTemplateSheetWriteHandler;
import com.els.modules.linereport.util.QuoteTemplateStyleWriteHandler;
import com.els.modules.system.entity.ExcelDetail;
import com.els.modules.system.entity.ExcelHeader;
import com.els.modules.system.enums.ExcelDataTypeEnum;
import com.els.modules.system.mapper.ExcelDetailMapper;
import com.els.modules.system.mapper.ExcelHeaderMapper;
import com.els.modules.system.service.impl.ExcelItemExcelServiceImpl;
import com.els.modules.system.util.ExcelCellStyleStrategy;
import com.els.modules.system.util.ExcelDictWriteHandler;
import com.els.modules.system.util.ExcelHeaderUtil;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class LineDifferenceReportServiceImpl
implements LineDifferenceReportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LineDifferenceReportServiceImpl.class);
    @Resource
    private ExcelHeaderMapper excelHeaderMapper;
    @Resource
    private ExcelDetailMapper excelDetailMapper;
    @Resource
    @Lazy
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private ExcelItemExcelServiceImpl excelItemExcelServiceImpl;
    @Resource
    private LineDifferenceReportApiRpcService lineDifferenceReportApiRpcService;
    @Resource
    private ElsInitialTableService initialTableService;

    @Override
    public void exportExcel(HttpServletResponse response, LineDifferenceItemDto lineDifferenceItemDto, Map<String, String[]> parameterMap) {
        String elsAccount = TenantContext.getTenant();
        String transportType = "4";
        List<LineDifferenceItemDto> lineDifferenceItemDtos = this.lineDifferenceReportApiRpcService.listByParam(lineDifferenceItemDto, parameterMap);
        if (!CollectionUtils.isEmpty(lineDifferenceItemDtos)) {
            transportType = lineDifferenceItemDtos.get(0).getTransportType();
        }
        String excelCode = null;
        excelCode = "1".equals(transportType) ? "LineDifferenceItemWaterwayExcelHandler" : ("2".equals(transportType) ? "LineDifferenceItemHighwayExcelHandler" : ("3".equals(transportType) ? "LineDifferenceItemRailwayExpressExcelHandler" : "LineDifferenceItemRailwayContainerExcelHandler"));
        ExcelHeader excelHeader = this.excelHeaderMapper.selectByExcelCode(excelCode, TenantContext.getTenant());
        if (excelHeader == null) {
            excelHeader = this.excelHeaderMapper.selectByExcelCode(excelCode, SysUtil.getPurchaseAccount());
        }
        if (excelHeader == null) {
            excelHeader = this.excelHeaderMapper.selectByExcelCode(excelCode, "100000");
        }
        List<ExcelDetail> detailList = this.excelDetailMapper.selectByMainId(excelHeader.getId());
        lineDifferenceItemDtos = this.getExportData(lineDifferenceItemDtos, detailList, elsAccount);
        List<String> includeColumnSet = this.includeColumn(detailList);
        try (ServletOutputStream outputStream = response.getOutputStream();){
            response.setContentType("application/force-download");
            response.addHeader("Content-Disposition", "attachment;fileName=" + new String("\u5bfc\u51fa\u6570\u636e.xlsx".getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
            ExcelWriter excelWriter = EasyExcel.write((OutputStream)outputStream).registerWriteHandler((WriteHandler)new LpCustomCellWriteHandler()).build();
            this.writeSheet(lineDifferenceItemDtos, excelWriter, detailList, elsAccount, includeColumnSet);
            excelWriter.finish();
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
    }

    private List<String> includeColumn(List<ExcelDetail> detailList) {
        return detailList.stream().map(ExcelDetail::getColumnCode).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    private List<LineDifferenceItemDto> getExportData(List<LineDifferenceItemDto> lineDifferenceItemDtos, List<ExcelDetail> detailList, String elsAccount) {
        if (CollectionUtil.isNotEmpty(lineDifferenceItemDtos)) {
            Map<String, String> dictMap = detailList.stream().filter(detail -> ExcelDataTypeEnum.DICT.getCode().equals(detail.getDataType())).collect(Collectors.toMap(ExcelDetail::getColumnCode, ExcelDetail::getDataFormat));
            HashMap<String, void> listMap = new HashMap<String, void>();
            for (String string : dictMap.values()) {
                void var8_10;
                if (listMap.containsKey(string)) continue;
                log.info("ExcelItemExcelServiceImpl getExportData:{}", (Object)string);
                log.info("ExcelItemExcelServiceImpl queryDictItemsByCode");
                if ("permissionScope".equals(string)) {
                    List list = this.invokeBaseRpcService.findOpenbusinessType();
                } else {
                    List list = this.invokeBaseRpcService.queryDictItemsByCode(string, elsAccount);
                }
                listMap.put(string, var8_10);
            }
            LineDifferenceItemDto data = lineDifferenceItemDtos.get(0);
            if (data instanceof Map) {
                for (LineDifferenceItemDto lineDifferenceItemDto : lineDifferenceItemDtos) {
                    Map map = (Map)lineDifferenceItemDto;
                    for (Map.Entry entry : map.entrySet()) {
                        String key = (String)entry.getKey();
                        if (!dictMap.containsKey(key)) continue;
                        List dictList = (List)listMap.get(dictMap.get(key));
                        this.translation((List<DictDTO>)dictList, map, key);
                    }
                }
            } else {
                Field[] fieldArray = ConvertUtils.getAllFields((Object)data);
                for (LineDifferenceItemDto object : lineDifferenceItemDtos) {
                    for (Field field : fieldArray) {
                        if (!dictMap.containsKey(field.getName())) continue;
                        List dictList = (List)listMap.get(dictMap.get(field.getName()));
                        this.translation((List<DictDTO>)dictList, object, field);
                    }
                }
            }
        }
        log.info("getExportData:{}", (Object)JSON.toJSON(lineDifferenceItemDtos).toString());
        return lineDifferenceItemDtos;
    }

    @Override
    public Map<String, Object> importExcel(MultipartFile file, Map<String, Object> otherRequestParam) {
        return null;
    }

    @Override
    public void downloadTemplate(HttpServletResponse response, String id) {
        SaleEnquiryHeadLpDTO dbHead = this.lineDifferenceReportApiRpcService.getSaleEnquiryHeadLpById(id);
        ArrayList<SaleEnquiryItemLpDTO> itemList = new ArrayList<SaleEnquiryItemLpDTO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"relation_id", (Object)dbHead.getRelationId());
        List itemList2 = this.initialTableService.list((Wrapper)queryWrapper);
        for (ElsInitialTable table : itemList2) {
            SaleEnquiryItemLpDTO item2 = (SaleEnquiryItemLpDTO)JSONObject.parseObject((String)table.getBusinessInfoJson(), SaleEnquiryItemLpDTO.class);
            itemList.add(item2);
        }
        if (!CollectionUtils.isEmpty(itemList)) {
            String password = ((ElsInitialTable)((Object)itemList2.get(0))).getCreateBy();
            List<List<String>> headList = this.getHead(dbHead.getSubjectType());
            Map<String, List<SaleEnquiryItemLpDTO>> itemListMap = itemList.stream().collect(Collectors.groupingBy(item -> item.getSectionNumber()));
            List sectionNumbers = itemList.stream().map(SaleEnquiryItemLpDTO::getSectionNumber).collect(Collectors.toSet()).stream().sorted().collect(Collectors.toList());
            try (ServletOutputStream outputStream = response.getOutputStream();){
                ExcelWriter excelWriter = EasyExcel.write((OutputStream)outputStream).registerWriteHandler((WriteHandler)new LpCustomCellWriteHandler()).build();
                int i = 0;
                for (String sectionNumber : sectionNumbers) {
                    List<SaleEnquiryItemLpDTO> dataList = itemListMap.get(sectionNumber);
                    WriteSheet writeSheet = EasyExcel.writerSheet((Integer)i, (String)(dataList.get(0).getSectionNumber() + dataList.get(0).getSectionName()).replaceAll("\\[|\\]|\\/|\\?|\\:|\\\\|\\*|\\\uff1f", "")).registerWriteHandler((WriteHandler)new QuoteTemplateExcelCellStyleStrategy(headList)).registerWriteHandler(QuoteTemplateExcelCellStyleStrategy.TEMPLATE_WRITE_HANDLER).registerWriteHandler((WriteHandler)new QuoteTemplateCellWriteHandler()).registerWriteHandler((WriteHandler)new QuoteTemplateStyleWriteHandler()).registerWriteHandler((WriteHandler)new QuoteTemplateSheetWriteHandler(password)).head(headList).build();
                    excelWriter.write(dataList, writeSheet);
                    ++i;
                }
                excelWriter.finish();
            }
            catch (Exception e) {
                log.error("\u751f\u6210\u6a21\u677f\u5f02\u5e38\uff1a", (Throwable)e);
                throw new ELSBootException("\u751f\u6210\u6a21\u677f\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
    }

    private List<List<String>> getHead(String subjectType) {
        ArrayList<String> arriveCityStationList;
        ArrayList<String> arriveCityList;
        ArrayList<List<String>> resultList = new ArrayList<List<String>>();
        ArrayList<String> enquiryNumberList = new ArrayList<String>();
        enquiryNumberList.add("enquiryNumber");
        enquiryNumberList.add("\u8be2\u4ef7\u5355\u53f7<\u5fc5\u586b>");
        resultList.add(enquiryNumberList);
        ArrayList<String> itemNumberList = new ArrayList<String>();
        itemNumberList.add("itemNumber");
        itemNumberList.add("\u8be2\u4ef7\u5355\u884c\u53f7<\u5fc5\u586b>");
        resultList.add(itemNumberList);
        ArrayList<String> sectionNumberList = new ArrayList<String>();
        sectionNumberList.add("sectionNumber");
        sectionNumberList.add("\u6807\u6bb5\u7f16\u7801<\u5fc5\u586b>");
        resultList.add(sectionNumberList);
        ArrayList<String> sectionNameList = new ArrayList<String>();
        sectionNameList.add("sectionName");
        sectionNameList.add("\u6807\u6bb5\u540d\u79f0<\u5fc5\u586b>");
        resultList.add(sectionNameList);
        ArrayList<String> startProvinceList = new ArrayList<String>();
        startProvinceList.add("startProvince");
        startProvinceList.add("\u59cb\u53d1\u7701\u4efd<\u5fc5\u586b>");
        resultList.add(startProvinceList);
        ArrayList<String> startCityList = new ArrayList<String>();
        startCityList.add("startCity");
        startCityList.add("\u59cb\u53d1\u57ce\u5e02<\u5fc5\u586b>");
        resultList.add(startCityList);
        ArrayList<String> startCountyList = new ArrayList<String>();
        startCountyList.add("startCounty");
        startCountyList.add("\u59cb\u53d1\u53bf\u533a<\u975e\u5fc5\u586b>");
        resultList.add(startCountyList);
        ArrayList<String> arriveProvinceList = new ArrayList<String>();
        arriveProvinceList.add("arriveProvince");
        arriveProvinceList.add("\u5230\u8fbe\u7701\u4efd<\u5fc5\u586b>");
        resultList.add(arriveProvinceList);
        if ("1".equals(subjectType)) {
            arriveCityList = new ArrayList<String>();
            arriveCityList.add("arriveCity");
            arriveCityList.add("\u5230\u8fbe\u5730\u533a<\u5fc5\u586b>");
            resultList.add(arriveCityList);
            ArrayList<String> toDoorPriceList = new ArrayList<String>();
            toDoorPriceList.add("toDoorPrice");
            toDoorPriceList.add("\u95e8\u5230\u95e8\u4ef7\u683c\uff08\u5143/\u53ea\uff09<\u5fc5\u586b>");
            resultList.add(toDoorPriceList);
            ArrayList<String> toDoorDateList = new ArrayList<String>();
            toDoorDateList.add("toDoorDate");
            toDoorDateList.add("\u95e8-\u95e8\u7269\u6d41\u65f6\u95f4\uff08\u5929\uff09<\u5fc5\u586b>");
            resultList.add(toDoorDateList);
        }
        if ("2".equals(subjectType)) {
            arriveCityList = new ArrayList();
            arriveCityList.add("arriveCity");
            arriveCityList.add("\u5230\u8fbe\u57ce\u5e02<\u5fc5\u586b>");
            resultList.add(arriveCityList);
            ArrayList<String> arriveCountyList = new ArrayList<String>();
            arriveCountyList.add("arriveCounty");
            arriveCountyList.add("\u5230\u8fbe\u53bf\u533a<\u975e\u5fc5\u586b>");
            resultList.add(arriveCountyList);
            ArrayList<String> intervalRatioPrice1List = new ArrayList<String>();
            intervalRatioPrice1List.add("intervalRatioPrice1");
            intervalRatioPrice1List.add("0-10<\u5fc5\u586b>");
            resultList.add(intervalRatioPrice1List);
            ArrayList<String> intervalRatioPrice2List = new ArrayList<String>();
            intervalRatioPrice2List.add("intervalRatioPrice2");
            intervalRatioPrice2List.add("10\uff08\u542b\uff09-20<\u5fc5\u586b>");
            resultList.add(intervalRatioPrice2List);
            ArrayList<String> intervalRatioPrice3List = new ArrayList<String>();
            intervalRatioPrice3List.add("intervalRatioPrice3");
            intervalRatioPrice3List.add("20\uff08\u542b\uff09-30<\u5fc5\u586b>");
            resultList.add(intervalRatioPrice3List);
            ArrayList<String> intervalRatioPrice4List = new ArrayList<String>();
            intervalRatioPrice4List.add("intervalRatioPrice4");
            intervalRatioPrice4List.add("\u226530<\u5fc5\u586b>");
            resultList.add(intervalRatioPrice4List);
        }
        if ("3".equals(subjectType)) {
            arriveCityStationList = new ArrayList<String>();
            arriveCityStationList.add("arriveCityStation");
            arriveCityStationList.add("\u5230\u8fbe\u5730\u533a<\u5fc5\u586b>");
            resultList.add(arriveCityStationList);
            ArrayList<String> toDoorTonsPriceList = new ArrayList<String>();
            toDoorTonsPriceList.add("toDoorTonsPrice");
            toDoorTonsPriceList.add("\u95e8\u5230\u95e8\u4ef7\u683c\uff08\u5143/\u5428\uff09<\u5fc5\u586b>");
            resultList.add(toDoorTonsPriceList);
            ArrayList<String> toDoorTonsDateList = new ArrayList<String>();
            toDoorTonsDateList.add("toDoorTonsDate");
            toDoorTonsDateList.add("\u95e8-\u95e8\u65f6\u6548\uff08\u5929\uff09<\u5fc5\u586b>");
            resultList.add(toDoorTonsDateList);
        }
        if ("4".equals(subjectType)) {
            arriveCityStationList = new ArrayList();
            arriveCityStationList.add("arriveCityStation");
            arriveCityStationList.add("\u5230\u8fbe\u5730\u533a<\u5fc5\u586b>");
            resultList.add(arriveCityStationList);
            ArrayList<String> toStationPriceList = new ArrayList<String>();
            toStationPriceList.add("toStationPrice");
            toStationPriceList.add("\u95e8\u5230\u7ad9\u4ef7\u683c\uff08\u5143/\u53ea\uff09<\u5fc5\u586b>");
            resultList.add(toStationPriceList);
            ArrayList<String> toStaList = new ArrayList<String>();
            toStaList.add("toSta");
            toStaList.add("\u95e8-\u7ad9\u7269\u6d41\u65f6\u95f4\uff08\u5929\uff09<\u5fc5\u586b>");
            resultList.add(toStaList);
        }
        return resultList;
    }

    private void translation(List<DictDTO> dictList, Object object, Field field) {
        try {
            field.setAccessible(true);
            String value = StrUtil.toString((Object)field.get(object));
            for (DictDTO model : dictList) {
                if (!model.getValue().equals(value)) continue;
                field.set(object, model.getText());
                return;
            }
        }
        catch (Exception e) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_vGIH_277d478d", (String)"\u53cd\u5c04\u5f02\u5e38"), (Throwable)e, new String[0]);
        }
    }

    private void translation(List<DictDTO> dictList, Map map, String key) {
        for (DictDTO model : dictList) {
            if (!model.getValue().equals(map.get(key))) continue;
            map.put(key, model.getText());
            return;
        }
    }

    private void writeSheet(List<LineDifferenceItemDto> lineDifferenceItemDtos, ExcelWriter excelWriter, List<ExcelDetail> detailList, String elsAccount, List<String> includeColumnSet) {
        if (CollectionUtils.isEmpty(lineDifferenceItemDtos)) {
            WriteSheet sheet = EasyExcel.writerSheet((Integer)1, (String)"data").registerWriteHandler((WriteHandler)new ExcelCellStyleStrategy(detailList)).registerWriteHandler(ExcelCellStyleStrategy.TEMPLATE_WRITE_HANDLER).registerWriteHandler((WriteHandler)new ExcelDictWriteHandler(detailList, this.invokeBaseRpcService, this.excelItemExcelServiceImpl, elsAccount)).includeColumnFiledNames(includeColumnSet).head(ExcelHeaderUtil.getHeaderList(detailList)).build();
            excelWriter.write(lineDifferenceItemDtos, sheet);
        } else {
            Map<String, List<LineDifferenceItemDto>> sectionListMap = lineDifferenceItemDtos.stream().collect(Collectors.groupingBy(item -> item.getSectionNumber() + "-" + item.getSectionName()));
            int sheetNo = 1;
            for (Map.Entry<String, List<LineDifferenceItemDto>> sectionListEntry : sectionListMap.entrySet()) {
                List<Object> entryValue = sectionListEntry.getValue();
                if (!CollectionUtils.isEmpty(entryValue)) {
                    entryValue = entryValue.stream().sorted(Comparator.comparing(LineDifferenceItemDto::getEnquiryItemNumber, Comparator.comparingInt(Integer::parseInt))).collect(Collectors.toList());
                }
                WriteSheet sheet = EasyExcel.writerSheet((Integer)sheetNo, (String)sectionListEntry.getKey().replaceAll("\\[|\\]|\\/|\\?|\\:|\\\\|\\*|\\\uff1f", "")).registerWriteHandler((WriteHandler)new LpExcelCellStyleStrategy(detailList)).registerWriteHandler(LpExcelCellStyleStrategy.TEMPLATE_WRITE_HANDLER).includeColumnFiledNames(includeColumnSet).head(ExcelHeaderUtil.getHeaderList(detailList)).build();
                excelWriter.write(entryValue, sheet);
                ++sheetNo;
            }
        }
    }
}

