/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.listener;

import com.alibaba.fastjson2.JSONObject;
import com.els.common.trace.MqKeyHolder;
import com.els.common.trace.TraceIdHolder;
import com.els.modules.message.service.MsgService;
import com.els.modules.mq.api.service.MqMessageRecordRpcService;
import jakarta.annotation.Resource;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Service;

@Service
public class BusinessMessageConsumer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BusinessMessageConsumer.class);
    @Resource
    private MsgService msgService;
    @Resource
    private MqMessageRecordRpcService mqRecordService;

    @Bean(value={"input"})
    public Consumer<Message<String>> receive() {
        return message -> {
            String key = (String)message.getHeaders().get((Object)"ROCKET_KEYS");
            MqKeyHolder.set((String)key);
            String msgStatus = this.mqRecordService.getMsgStatusById(key);
            if ("1".equals(msgStatus)) {
                log.error("\u6d88\u606fID\uff1a" + key + " \u5df2\u7ecf\u6d88\u8d39\uff0c\u4e0d\u80fd\u91cd\u590d\u6d88\u8d39\uff01");
                return;
            }
            if (null == TraceIdHolder.get()) {
                TraceIdHolder.set((String)("MQ" + key));
            }
            String msgBody = (String)message.getPayload();
            log.info("msgBody: " + msgBody);
            String errorInfo = "";
            try {
                JSONObject msgObj = JSONObject.parseObject((String)msgBody);
                this.msgService.sendMsg(msgObj);
                msgStatus = "1";
            }
            catch (Exception e) {
                log.error("send_msg_failed:" + msgBody, (Throwable)e);
                msgStatus = "2";
                errorInfo = e.getMessage();
            }
            finally {
                this.mqRecordService.updateRecord(key, msgStatus, errorInfo);
                MqKeyHolder.remove();
                TraceIdHolder.remove();
            }
        };
    }
}

