/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.util.RedisUtil;
import com.els.modules.system.entity.InterfaceAppPermission;
import com.els.modules.system.mapper.InterfaceAppPermissionMapper;
import com.els.modules.system.service.InterfaceAppPermissionService;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class InterfaceAppPermissionServiceImpl
extends ServiceImpl<InterfaceAppPermissionMapper, InterfaceAppPermission>
implements InterfaceAppPermissionService {
    private static final String REDIS_KEY = "interface:appPermission:";
    @Resource
    private RedisUtil redisUtil;

    private String getRedisKey(String appId) {
        return REDIS_KEY + appId;
    }

    @Override
    public Boolean checkAppPermission(String elsAccount, String appId, String interfaceCode) {
        String redisKey = this.getRedisKey(appId);
        List appPermissionList = (List)this.redisUtil.get(redisKey);
        if (appPermissionList == null) {
            List<InterfaceAppPermission> permissionList = ((InterfaceAppPermissionMapper)this.baseMapper).selectByMainId(appId);
            appPermissionList = permissionList.stream().map(InterfaceAppPermission::getInterfaceCode).collect(Collectors.toList());
            this.redisUtil.set(redisKey, appPermissionList);
        }
        if (appPermissionList.contains(interfaceCode)) {
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteByMainId(String mainId) {
        return ((InterfaceAppPermissionMapper)this.baseMapper).deleteByMainId(mainId);
    }

    @Override
    public List<InterfaceAppPermission> selectByMainId(String mainId) {
        return ((InterfaceAppPermissionMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void clearRedisCache(String appId) {
        String redisKey = this.getRedisKey(appId);
        this.redisUtil.del(new String[]{redisKey});
    }
}

