/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.constant.SrmConstant;
import com.els.common.util.SrmUtil;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.im.core.ImSender;
import com.els.modules.im.dto.ImGroupCreateDto;
import com.els.modules.im.entity.ImGroupChat;
import com.els.modules.im.entity.ImGroupChatUser;
import com.els.modules.im.mapper.ImGroupChatMapper;
import com.els.modules.im.mapper.ImGroupChatUserMapper;
import com.els.modules.im.service.IImGroupChatService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImGroupChatServiceImpl
extends ServiceImpl<ImGroupChatMapper, ImGroupChat>
implements IImGroupChatService {
    @Autowired
    private ImGroupChatUserMapper imGroupChatUserMapper;

    @Override
    public List<ImGroupChat> getGroupChatsByUserId(String userId) {
        return ((ImGroupChatMapper)this.baseMapper).getUserGroups(userId);
    }

    @Override
    public ImGroupChat createGroupChat(ImGroupCreateDto imGroupCreateDto, boolean binding) {
        LoginUserDTO sysUser = SrmUtil.getLoginUser();
        ImGroupChat imChatGroup = new ImGroupChat();
        imChatGroup.setGroupChatName(imGroupCreateDto.getGroupChatName());
        imChatGroup.setGroupChatMasterId(sysUser.getId());
        imChatGroup.setDeleted(SrmConstant.NO_0);
        imChatGroup.setGroupChatHeadPortrait("/im/layim-v3.9.6/static/css/modules/layim/skin/group.jpg");
        if (StrUtil.isNotBlank((CharSequence)imGroupCreateDto.getId())) {
            imChatGroup.setId(imGroupCreateDto.getId());
            imChatGroup.setBusinessType(imGroupCreateDto.getBusinessType());
            imChatGroup.setBusinessNumber(imGroupCreateDto.getBusinessNumber());
        } else {
            imChatGroup.setBusinessNumber(null);
            imChatGroup.setBusinessType(null);
            imGroupCreateDto.setId(IdWorker.getTimeId());
        }
        ((ImGroupChatMapper)this.baseMapper).insert((Object)imChatGroup);
        ImGroupChatUser chatGroupUser = new ImGroupChatUser();
        chatGroupUser.setGroupChatId(imChatGroup.getId());
        chatGroupUser.setUserId(sysUser.getId());
        chatGroupUser.setCreateTime(new Date());
        this.imGroupChatUserMapper.insert(chatGroupUser);
        if (binding) {
            ImSender.clusterToBindGroup(sysUser.getId(), imChatGroup.getId());
        }
        return imChatGroup;
    }
}

