/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.common.util.ConvertUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.SupplierGroupPermission;
import com.els.modules.system.mapper.SupplierGroupPermissionMapper;
import com.els.modules.system.service.SupplierGroupPermissionService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SupplierGroupPermissionServiceImpl
extends ServiceImpl<SupplierGroupPermissionMapper, SupplierGroupPermission>
implements SupplierGroupPermissionService {
    @Override
    public void saveGroupPermission(String groupId, String permissionIds, String lastPermissionIds) {
        List<String> deleteList;
        if (StrUtil.isBlank((CharSequence)groupId)) {
            throw new ELSBootException("groupId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String elsAccount = TenantContext.getTenant();
        List<String> add = this.getDiff(lastPermissionIds, permissionIds);
        if (add != null && add.size() > 0) {
            ArrayList<SupplierGroupPermission> list = new ArrayList<SupplierGroupPermission>();
            for (String p : add) {
                if (!ConvertUtils.isNotEmpty((Object)p)) continue;
                SupplierGroupPermission rolepms = new SupplierGroupPermission(elsAccount, groupId, p);
                list.add(rolepms);
            }
            this.saveBatch(list);
        }
        if (CollUtil.isNotEmpty(deleteList = this.getDiff(permissionIds, lastPermissionIds))) {
            this.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SupplierGroupPermission::getGroupId, (Object)groupId)).in(SupplierGroupPermission::getPermissionId, deleteList));
        }
    }

    private List<String> getDiff(String main, String diff) {
        if (ConvertUtils.isEmpty((Object)diff)) {
            return null;
        }
        if (ConvertUtils.isEmpty((Object)main)) {
            return Arrays.asList(diff.split(","));
        }
        String[] mainArr = main.split(",");
        String[] diffArr = diff.split(",");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String string : mainArr) {
            map.put(string, 1);
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String key : diffArr) {
            if (!ConvertUtils.isNotEmpty((Object)key) || map.containsKey(key)) continue;
            res.add(key);
        }
        return res;
    }
}

