/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SrmUtil;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.im.entity.ImUserFriend;
import com.els.modules.im.entity.ImUserGroup;
import com.els.modules.im.mapper.ImUserFriendMapper;
import com.els.modules.im.mapper.ImUserGroupMapper;
import com.els.modules.im.service.IImUserFriendService;
import com.els.modules.im.service.IImUserGroupService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImUserGroupServiceImpl
extends ServiceImpl<ImUserGroupMapper, ImUserGroup>
implements IImUserGroupService {
    private static final Integer MAX_GROUP = 30;
    private static final String DEFAULT_GROUP_NAME = "\u6211\u7684\u597d\u53cb";
    @Autowired
    private ImUserFriendMapper imUserFriendMapper;

    @Override
    public ImUserGroup addGroup(String userId, String imGroupName) {
        if (DEFAULT_GROUP_NAME.equals(imGroupName)) {
            throw new ELSBootException(I18nUtil.translate((String)"\u9ed8\u8ba4\u5206\u7ec4\u4e0d\u5141\u8bb8\u91cd\u590d"));
        }
        if (this.countUserGroup(userId) >= MAX_GROUP) {
            throw new ELSBootException("\u6700\u591a\u53ea\u80fd\u6dfb\u52a0\u4e2a\u5206\u7ec4");
        }
        LoginUserDTO loginUser = SrmUtil.getLoginUser();
        Integer nextSort = ((ImUserGroupMapper)this.baseMapper).getMaxSort(userId);
        ImUserGroup group = new ImUserGroup();
        group.setGroupSort(nextSort);
        group.setUserId(userId);
        group.setGroupName(imGroupName);
        group.setElsAccount(loginUser.getElsAccount());
        group.setDeleted(0);
        ((ImUserGroupMapper)this.baseMapper).insert((Object)group);
        return group;
    }

    @Override
    public void initGroupBatch(List<String> userIdList) {
        ArrayList<ImUserGroup> imGroupList = new ArrayList<ImUserGroup>();
        ArrayList<ImUserFriend> imUserFriendList = new ArrayList<ImUserFriend>();
        LoginUserDTO loginUser = SrmUtil.getLoginUser();
        for (String userId : userIdList) {
            ImUserGroup imGroup = new ImUserGroup();
            imGroup.setId(IdWorker.getIdStr());
            imGroup.setUserId(userId);
            imGroup.setElsAccount(loginUser.getElsAccount());
            imGroup.setDeleted(0);
            imGroup.setGroupName(DEFAULT_GROUP_NAME);
            ImUserFriend imUserFriend = new ImUserFriend();
            imUserFriend.setUserId(userId);
            imUserFriend.setFriendId(userId);
            imUserFriend.setUserGroupId(imGroup.getId());
            imUserFriend.setFriendGroupId(imGroup.getId());
            imGroupList.add(imGroup);
            imUserFriendList.add(imUserFriend);
        }
        this.saveBatch(imGroupList);
        ((IImUserFriendService)SpringContextUtils.getBean(IImUserFriendService.class)).saveBatch(imUserFriendList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public String initGroup(String userId) {
        LoginUserDTO loginUser = SrmUtil.getLoginUser();
        ImUserGroup group = new ImUserGroup();
        group.setUserId(userId);
        group.setGroupName(DEFAULT_GROUP_NAME);
        group.setGroupSort(-1);
        group.setDeleted(0);
        group.setElsAccount(loginUser.getElsAccount());
        ((ImUserGroupMapper)this.baseMapper).insert((Object)group);
        ImUserFriend userFriend = this.buildImUserFriend(userId, userId, group.getId());
        userFriend.setFriendGroupId(group.getId());
        this.imUserFriendMapper.insert((Object)userFriend);
        return group.getId();
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public ImUserFriend addFriend(String friendId, String groupId) {
        LoginUserDTO sysUser = SrmUtil.getLoginUser();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(ImUserFriend::getUserId, (Object)sysUser.getId())).eq(ImUserFriend::getFriendId, (Object)friendId);
        Long count = this.imUserFriendMapper.selectCount((Wrapper)queryWrapper);
        String temUserId = sysUser.getId();
        String temFriendId = friendId;
        boolean exist = false;
        if (count > 0L) {
            exist = true;
        }
        queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(ImUserFriend::getUserId, (Object)friendId)).eq(ImUserFriend::getFriendId, (Object)sysUser.getId());
        count = this.imUserFriendMapper.selectCount((Wrapper)queryWrapper);
        if (count > 0L) {
            temUserId = friendId;
            temFriendId = sysUser.getId();
            exist = true;
        }
        if (CharSequenceUtil.isBlank((CharSequence)groupId)) {
            ImUserGroup imGroup = this.checkGroupNameExist(sysUser.getId(), DEFAULT_GROUP_NAME, null);
            groupId = null == imGroup ? this.initGroup(sysUser.getId()) : imGroup.getId();
        }
        ImUserFriend userFriend = this.buildImUserFriend(sysUser.getId(), friendId, groupId);
        if (exist) {
            LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
            ((LambdaUpdateWrapper)wrapper.eq(ImUserFriend::getUserId, (Object)temUserId)).eq(ImUserFriend::getFriendId, (Object)temFriendId);
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.set(ImUserFriend::getUserGroupId, (Object)userFriend.getUserGroupId())).set(ImUserFriend::getFriendGroupId, (Object)userFriend.getFriendGroupId())).set(BaseEntity::getUpdateTime, (Object)userFriend.getUpdateTime())).set(BaseEntity::getCreateTime, (Object)userFriend.getCreateTime());
            this.imUserFriendMapper.update(null, (Wrapper)wrapper);
        } else {
            this.imUserFriendMapper.insert((Object)userFriend);
        }
        return userFriend;
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public ImUserFriend agreeFriendRequest(String friendId, String groupId) {
        LoginUserDTO sysUser = SrmUtil.getLoginUser();
        if (CharSequenceUtil.isBlank((CharSequence)groupId)) {
            ImUserGroup imGroup = this.checkGroupNameExist(sysUser.getId(), DEFAULT_GROUP_NAME, null);
            groupId = null == imGroup ? this.initGroup(sysUser.getId()) : imGroup.getId();
        }
        ImUserFriend userFriend = this.buildImUserFriend(sysUser.getId(), friendId, groupId);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(ImUserFriend::getUserId, (Object)friendId)).eq(ImUserFriend::getFriendId, (Object)sysUser.getId());
        ImUserFriend friend = (ImUserFriend)((Object)this.imUserFriendMapper.selectOne((Wrapper)queryWrapper));
        this.imUserFriendMapper.setFriendGroup(friendId, sysUser.getId(), groupId);
        userFriend.setFriendGroupId(friend.getUserGroupId());
        this.imUserFriendMapper.insert((Object)userFriend);
        return friend;
    }

    @Override
    public void rename(String groupId, String userId, String groupName) {
        ImUserGroup old = (ImUserGroup)((Object)((ImUserGroupMapper)this.baseMapper).selectById((Serializable)((Object)groupId)));
        if (null == old) {
            throw new ELSBootException(I18nUtil.translate((String)"\u5206\u7ec4\u4e0d\u5b58\u5728"));
        }
        if (DEFAULT_GROUP_NAME.equals(old.getGroupName())) {
            throw new ELSBootException(I18nUtil.translate((String)"\u9ed8\u8ba4\u5206\u7ec4\u4e0d\u5141\u8bb8\u91cd\u547d\u540d"));
        }
        if (DEFAULT_GROUP_NAME.equals(groupName)) {
            throw new ELSBootException(I18nUtil.translate((String)"\u9ed8\u8ba4\u5206\u7ec4\u4e0d\u5141\u8bb8\u91cd\u590d"));
        }
        LoginUserDTO sysUser = SrmUtil.getLoginUser();
        ImUserGroup imGroup = new ImUserGroup();
        imGroup.setUserId(userId);
        imGroup.setGroupName(groupName);
        imGroup.setElsAccount(sysUser.getElsAccount());
        imGroup.setDeleted(0);
        imGroup.setId(groupId);
        ((ImUserGroupMapper)this.baseMapper).updateById((Object)imGroup);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void deleteGroup(String userId, String groupId) {
        ImUserGroup imGroup = (ImUserGroup)((Object)((ImUserGroupMapper)this.baseMapper).selectById((Serializable)((Object)groupId)));
        if (null == imGroup) {
            throw new ELSBootException(I18nUtil.translate((String)"\u5206\u7ec4\u4e0d\u5b58\u5728"));
        }
        if (DEFAULT_GROUP_NAME.equals(imGroup.getGroupName())) {
            throw new ELSBootException(I18nUtil.translate((String)"\u9ed8\u8ba4\u5206\u7ec4\u4e0d\u5141\u8bb8\u5220\u9664"));
        }
        String newGroupId = null;
        ImUserGroup defaultGroup = this.checkGroupNameExist(userId, DEFAULT_GROUP_NAME, null);
        newGroupId = null == defaultGroup ? this.initGroup(userId) : defaultGroup.getId();
        this.moveFriendToGroup(userId, newGroupId, groupId);
        ((ImUserGroupMapper)this.baseMapper).deleteById((Serializable)((Object)groupId));
    }

    private void moveFriendToGroup(String userId, String newGroupId, String oldGroupId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.set(ImUserFriend::getUserGroupId, (Object)newGroupId)).eq(ImUserFriend::getUserId, (Object)userId)).eq(ImUserFriend::getUserGroupId, (Object)oldGroupId);
        this.imUserFriendMapper.update(null, (Wrapper)wrapper);
        LambdaQueryWrapper friendWrapper = Wrappers.lambdaQuery();
        friendWrapper.select(new SFunction[]{ImUserFriend::getFriendId});
        ((LambdaQueryWrapper)friendWrapper.eq(ImUserFriend::getUserId, (Object)userId)).eq(ImUserFriend::getUserGroupId, (Object)newGroupId);
        List friends = this.imUserFriendMapper.selectList((Wrapper)friendWrapper);
        if (friends.isEmpty()) {
            return;
        }
        wrapper.clear();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.set(ImUserFriend::getFriendGroupId, (Object)newGroupId)).in(ImUserFriend::getUserId, (Collection)friends.stream().map(ImUserFriend::getFriendId).collect(Collectors.toList()))).eq(ImUserFriend::getFriendId, (Object)userId);
        this.imUserFriendMapper.update(null, (Wrapper)wrapper);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void groupUpAndDown(String userId, String moveGroupId, String targetGroupId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{ImUserGroup::getGroupSort, ParentEntity::getId});
        wrapper.eq(ImUserGroup::getUserId, (Object)userId);
        wrapper.in(ParentEntity::getId, (Collection)Lists.newArrayList((Object[])new String[]{moveGroupId, targetGroupId}));
        List friends = ((ImUserGroupMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (friends.size() != 2) {
            return;
        }
        this.swapSort((ImUserGroup)((Object)friends.get(0)), (ImUserGroup)((Object)friends.get(1)));
        friends.forEach(arg_0 -> ((ImUserGroupMapper)((ImUserGroupMapper)this.baseMapper)).updateById(arg_0));
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void groupDrag(String userId, List<String> imGroups) {
        ArrayList<ImUserGroup> groups = new ArrayList<ImUserGroup>();
        for (int i = 0; i < imGroups.size(); ++i) {
            if (CharSequenceUtil.isBlank((CharSequence)imGroups.get(i))) continue;
            ImUserGroup group = new ImUserGroup();
            group.setId(imGroups.get(i));
            group.setGroupSort(i);
            groups.add(group);
        }
        if (groups.isEmpty()) {
            return;
        }
        this.updateBatchById(groups);
    }

    private void swapSort(ImUserGroup m1, ImUserGroup m2) {
        Integer sort = m1.getGroupSort();
        m1.setGroupSort(m2.getGroupSort());
        m2.setGroupSort(sort);
    }

    private ImUserFriend buildImUserFriend(String userId, String friendId, String groupId) {
        ImUserFriend userFriend = new ImUserFriend();
        userFriend.setUserId(userId);
        userFriend.setFriendId(friendId);
        userFriend.setUserGroupId(groupId);
        return userFriend;
    }

    private ImUserGroup checkGroupNameExist(String userId, String imGroupName, String groupId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{ParentEntity::getId});
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ImUserGroup::getUserId, (Object)userId)).eq(ImUserGroup::getGroupName, (Object)imGroupName)).ne(CharSequenceUtil.isNotBlank((CharSequence)groupId), ParentEntity::getId, (Object)groupId);
        List groups = ((ImUserGroupMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (groups.isEmpty()) {
            return null;
        }
        return (ImUserGroup)((Object)groups.get(0));
    }

    private Integer countUserGroup(String userId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(ImUserGroup::getUserId, (Object)userId);
        return ((ImUserGroupMapper)this.baseMapper).selectCount((Wrapper)wrapper).intValue();
    }
}

