/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mq.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.MqUtil;
import com.els.modules.mq.entity.MqRecord;
import com.els.modules.mq.mapper.MqRecordMapper;
import com.els.modules.mq.rpc.service.MqConsumerExecuteService;
import com.els.modules.mq.service.MqRecordService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MqRecordServiceImpl
extends BaseServiceImpl<MqRecordMapper, MqRecord>
implements MqRecordService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MqRecordServiceImpl.class);
    @Resource
    private MqConsumerExecuteService executeService;

    @Override
    public void retry(MqRecord record) {
        MqRecord dbRecord = (MqRecord)((Object)this.getById((Serializable)((Object)record.getId())));
        Assert.isTrue((boolean)"consumed".equals(dbRecord.getMsgStatus()), (String)I18nUtil.translate((String)"\u5df2\u6d88\u8d39\u7684\u8bb0\u5f55\u4e0d\u53ef\u91cd\u8bd5"), (Object[])new Object[0]);
        MqUtil.retryMsg((String)dbRecord.getMsgType(), (String)dbRecord.getMsgContent(), (String)record.getId());
    }

    @Override
    public void physicalDeleteById(String id) {
        ((MqRecordMapper)this.baseMapper).physicalDeleteById(id);
    }

    @Override
    public void clearRecord(int days) {
        Date currentDate = new Date();
        DateTime clearDate = DateUtil.offsetDay((Date)currentDate, (int)(-days));
        List recordIdList = this.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().select((Object[])new String[]{"id"})).lt((Object)"create_time", (Object)clearDate)).eq((Object)"msg_status", (Object)"consumed"));
        log.warn("\u67e5\u8be2\u5230 " + recordIdList.size() + "\u6761\u5f85\u6e05\u7406\u7684\u8bb0\u5f55\uff0c\u5f00\u59cb\u6267\u884c\u6e05\u7406...");
        List<String> collect = recordIdList.stream().map(ParentEntity::getId).collect(Collectors.toList());
        if (!CollectionUtil.isEmpty(collect)) {
            if (collect.size() == 1) {
                ((MqRecordMapper)this.baseMapper).physicalDeleteById(collect.get(0));
                log.warn("\u6e05\u7406\u6210\u529f");
            } else {
                ((MqRecordMapper)this.baseMapper).physicalDeleteByIdList(collect);
            }
            log.warn("\u6e05\u7406\u6210\u529f");
        }
    }
}

