/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.email.core.listener;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.trace.TraceIdHolder;
import com.els.common.util.LoginUserContext;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SrmUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.email.api.dto.EmailConfigDTO;
import com.els.modules.email.api.dto.EmailSendLogDTO;
import com.els.modules.email.core.retry.EmailRetryService;
import com.els.modules.email.entity.EmailSendLog;
import com.els.modules.email.service.EmailSendLogService;
import io.netty.util.concurrent.FastThreadLocalThread;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.redisson.api.RBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class EmailQueueListenerRunnable
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmailQueueListenerRunnable.class);
    private final String EMAIL_SEND_RETRY_COUNT = "srm:base:email:send_log_retry_count:";
    public final ThreadPoolTaskExecutor srmPoolTaskExecutor;
    private final RBlockingQueue<EmailConfigDTO> excelRedisBlocking;
    private final ThreadPoolTaskScheduler taskScheduler;

    public EmailQueueListenerRunnable(ThreadPoolTaskExecutor srmPoolTaskExecutor, RBlockingQueue<EmailConfigDTO> excelRedisBlocking) {
        this.srmPoolTaskExecutor = srmPoolTaskExecutor;
        this.excelRedisBlocking = excelRedisBlocking;
        this.taskScheduler = new ThreadPoolTaskScheduler();
        this.taskScheduler.setPoolSize(200);
        this.taskScheduler.setThreadNamePrefix("email-task-scheduler-");
        this.taskScheduler.setDaemon(true);
        this.taskScheduler.setThreadFactory((ThreadFactory)new NameTreadFactory());
        this.taskScheduler.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        this.taskScheduler.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RedisUtil redisUtil = (RedisUtil)SpringContextUtils.getBean(RedisUtil.class);
        while (true) {
            try {
                EmailConfigDTO configDTO = (EmailConfigDTO)this.excelRedisBlocking.take();
                if (null != configDTO.getLoginUserDTO()) {
                    LoginUserContext.setUser((LoginUserDTO)configDTO.getLoginUserDTO());
                }
                if (CharSequenceUtil.isNotEmpty((CharSequence)configDTO.getCurrentElsAccount())) {
                    TenantContext.setTenant((String)configDTO.getCurrentElsAccount());
                }
                TraceIdHolder.init();
                TraceIdHolder.set((String)configDTO.getTraceId());
                if (CharSequenceUtil.isEmpty((CharSequence)configDTO.getSendLogId())) {
                    log.warn("\u5f53\u524d\u90ae\u4ef6\u53d1\u9001\u8bb0\u5f55\u5f02\u5e38\uff0cID\u4e3a\u7a7a");
                    continue;
                }
                EmailSendLog record = (EmailSendLog)((Object)((EmailSendLogService)SpringContextUtils.getBean(EmailSendLogService.class)).getById((Serializable)((Object)configDTO.getSendLogId())));
                if (null == record) {
                    log.warn("\u672a\u627e\u5230\u5f53\u524d\u90ae\u4ef6\u53d1\u9001\u8bb0\u5f55ID:{}", (Object)configDTO.getSendLogId());
                    if (null == configDTO.getReplyPutTimes() || configDTO.getReplyPutTimes() > 2) continue;
                    configDTO.setReplyPutTimes(Integer.valueOf(configDTO.getReplyPutTimes() + 1));
                    Instant now = Instant.now();
                    Duration duration = Duration.ofMinutes(configDTO.getReplyPutTimes().intValue());
                    Instant offsetInstant = now.plus(duration);
                    this.taskScheduler.schedule(() -> this.excelRedisBlocking.add((Object)configDTO), offsetInstant);
                    continue;
                }
                this.srmPoolTaskExecutor.execute(() -> {
                    block2: {
                        try {
                            ((EmailRetryService)SpringContextUtils.getBean(EmailRetryService.class)).retrySendEmail((EmailSendLogDTO)SrmUtil.copyProperties((Object)((Object)record), EmailSendLogDTO.class));
                            redisUtil.set("srm:base:email:send_log_retry_count:" + record.getId(), (Object)0, 1L);
                        }
                        catch (Exception e) {
                            Integer count = (Integer)redisUtil.get("srm:base:email:send_log_retry_count:" + record.getId());
                            if (null != count && count > 2) break block2;
                            count = null == count ? 0 : count;
                            redisUtil.set("srm:base:email:send_log_retry_count:" + record.getId(), (Object)(1 + count), 1800L);
                            Instant now = Instant.now();
                            int minutesToOffset = record.getRetryCount() * 2;
                            Duration duration = Duration.ofMinutes(minutesToOffset);
                            Instant offsetInstant = now.plus(duration);
                            this.taskScheduler.schedule(() -> this.excelRedisBlocking.add((Object)configDTO), offsetInstant);
                        }
                    }
                });
                continue;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(2L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
            finally {
                LoginUserContext.clear();
                TenantContext.clear();
                TraceIdHolder.remove();
                continue;
            }
            break;
        }
    }

    static class NameTreadFactory
    implements ThreadFactory {
        private final AtomicInteger mThreadNum = new AtomicInteger(1);

        NameTreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new FastThreadLocalThread(r, "SRM-Email-Scheduler-Thread-" + this.mThreadNum.getAndIncrement());
        }
    }
}

