/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.enums;

import cn.hutool.core.text.CharSequenceUtil;
import java.util.Arrays;
import lombok.Generated;

public enum TableColumnDataType {
    VARCHAR("varchar", true),
    CHAR("char", true),
    TEXT("text", false),
    LONGTEXT("longtext", false),
    INT("int", true),
    TINYINT("tinyint", true),
    BIGINT("bigint", true),
    INTEGER("integer", true),
    DOUBLE("double", true),
    FLOAT("float", true),
    JSON("json", false),
    BLOB("blob", false),
    LONGBLOB("longblob", false),
    DECIMAL("decimal", true),
    DATE("date", false),
    DATETIME("datetime", false);

    private String dateType;
    private boolean needLength;

    public static boolean contains(String type) {
        if (CharSequenceUtil.isEmpty((CharSequence)type)) {
            return false;
        }
        return Arrays.stream(TableColumnDataType.values()).filter(x -> type.equals(x.getDateType())).count() > 0L;
    }

    public static boolean needLength(String type) {
        if (CharSequenceUtil.isEmpty((CharSequence)type)) {
            return false;
        }
        for (TableColumnDataType t : TableColumnDataType.values()) {
            if (!type.equals(t.getDateType())) continue;
            return t.isNeedLength();
        }
        return false;
    }

    @Generated
    private TableColumnDataType(String dateType, boolean needLength) {
        this.dateType = dateType;
        this.needLength = needLength;
    }

    @Generated
    public String getDateType() {
        return this.dateType;
    }

    @Generated
    public boolean isNeedLength() {
        return this.needLength;
    }
}

