/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.custom.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.custom.entity.PurchaseCustomFormHead;
import com.els.modules.custom.service.BusinessCustomConfigService;
import com.els.modules.custom.service.PurchaseCustomFormHeadService;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Map;

@RpcService(value="businessCustomAuditCallBackServiceImpl")
public class BusinessCustomAdapter
implements WorkflowAuditOptCallBackService {
    @Resource
    private PurchaseCustomFormHeadService purchaseCustomFormHeadService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private BusinessCustomConfigService customConfigService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String businessId) {
        PurchaseCustomFormHead formHead = (PurchaseCustomFormHead)((Object)this.purchaseCustomFormHeadService.getById((Serializable)((Object)businessId)));
        return SrmUtil.toJSONObject((Object)((Object)formHead));
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseCustomFormHead updateHead = new PurchaseCustomFormHead();
        updateHead.setAuditStatus(auditStatus);
        updateHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        updateHead.setId(flowCallbackDTO.getBusinessId());
        this.purchaseCustomFormHeadService.updateById((Object)updateHead);
    }
}

