/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.email.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.email.api.dto.EmailConfigDTO;
import com.els.modules.email.api.dto.EmailSendLogDTO;
import com.els.modules.email.core.retry.EmailRetryService;
import com.els.modules.email.entity.EmailSendLog;
import com.els.modules.email.mapper.EmailSendLogMapper;
import com.els.modules.email.service.EmailSendLogService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class EmailSendLogServiceImpl
extends BaseServiceImpl<EmailSendLogMapper, EmailSendLog>
implements EmailSendLogService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmailSendLogServiceImpl.class);

    @Override
    public EmailConfigDTO saveOrUpdateEmailSendRecord(EmailConfigDTO config) {
        EmailSendLog sendLog;
        log.info("ElsEmailSendLogServiceImpl \u4fdd\u5b58\u90ae\u4ef6\u53d1\u9001\u8bb0\u5f55");
        if (CharSequenceUtil.isNotEmpty((CharSequence)config.getSendLogId()) && null != (sendLog = (EmailSendLog)((Object)this.getById((Serializable)((Object)config.getSendLogId()))))) {
            sendLog.setFromEmail(config.getEmailUsername());
            sendLog.setRetryCount("0".equals(config.getEmailSendStatus()) ? 0 : (sendLog.getRetryCount() == 0 && "1".equals(config.getEmailSendStatus()) ? sendLog.getRetryCount() : sendLog.getRetryCount() + 1));
            sendLog.setEmailSendStatus(config.getEmailSendStatus());
            config.setAttachmentFiles(null);
            sendLog.setMsgConfigContent(JSON.toJSONString((Object)config));
            sendLog.setErrorMsg(config.getErrorMsg());
            sendLog.setEmailHost(config.getEmailHost());
            sendLog.setEmailConfigId(config.getEmailConfigId());
            ((EmailSendLogMapper)this.baseMapper).updateById((Object)sendLog);
            return (EmailConfigDTO)Convert.convert(EmailConfigDTO.class, (Object)((Object)sendLog));
        }
        sendLog = new EmailSendLog();
        String currentElsAccount = config.getCurrentElsAccount();
        if (CharSequenceUtil.isEmpty((CharSequence)currentElsAccount)) {
            currentElsAccount = config.getElsAccount();
        }
        sendLog.setElsAccount(currentElsAccount);
        sendLog.setEmailHost(config.getEmailHost());
        sendLog.setFromEmail(config.getEmailUsername());
        sendLog.setErrorMsg(config.getErrorMsg());
        sendLog.setEmailSendStatus(config.getEmailSendStatus());
        sendLog.setRetryCount(0);
        if (null != config.getEmailBcc()) {
            sendLog.setEmailBc(String.join((CharSequence)",", config.getEmailBcc()));
        }
        sendLog.setEmailCc(config.getEmailCc());
        sendLog.setEmailSubject(config.getEmailSubject());
        sendLog.setEmailContent(config.getEmailContent());
        sendLog.setEmailConfigId(config.getEmailConfigId());
        if (null != config.getEmailTo()) {
            sendLog.setEmailTo(String.join((CharSequence)",", config.getEmailTo()));
        }
        sendLog.setMsgConfigContent(JSON.toJSONString((Object)config));
        this.save((Object)sendLog);
        log.info("ElsEmailSendLogServiceImpl \u4fdd\u5b58\u90ae\u4ef6\u53d1\u9001\u8bb0\u5f55\u5b8c\u6210");
        return (EmailConfigDTO)Convert.convert(EmailConfigDTO.class, (Object)((Object)sendLog));
    }

    @Override
    public void retry(String id) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(ParentEntity::getId, (Object)id);
        EmailSendLog sendLog = null;
        List list = ((EmailSendLogMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (!list.isEmpty()) {
            sendLog = (EmailSendLog)((Object)list.get(0));
        }
        if (null == sendLog) {
            throw new ELSBootException(I18nUtil.translate((String)"\u90ae\u4ef6\u8bb0\u5f55\u4e0d\u5b58\u5728"));
        }
        EmailSendLogDTO config = new EmailSendLogDTO();
        BeanUtils.copyProperties((Object)((Object)sendLog), (Object)config);
        config.setSendLogId(id);
        ((EmailRetryService)SpringContextUtils.getBean(EmailRetryService.class)).retrySendEmail(config);
    }

    @Override
    public List<EmailSendLogDTO> getNoSendEmailSendLog() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(EmailSendLog::getEmailSendStatus, (Object)"0")).le(BaseEntity::getUpdateTime, (Object)DateUtil.offsetMinute((Date)new Date(), (int)-10));
        List emailSendLogs = ((EmailSendLogMapper)this.baseMapper).selectList((Wrapper)wrapper);
        return Convert.toList(EmailSendLogDTO.class, (Object)emailSendLogs);
    }

    @Override
    public void updateRetryCount(String sendLogId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.eq(ParentEntity::getId, (Object)sendLogId);
        wrapper.setSql("retry_count = retry_count +1", new Object[0]);
        ((EmailSendLogMapper)this.baseMapper).update((Wrapper)wrapper);
    }
}

