/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.util.StrUtil;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.util.I18nUtil;
import com.els.modules.system.entity.DictItem;
import com.els.modules.system.entity.ElsCompanySet;
import com.els.modules.system.service.DictItemService;
import com.els.modules.system.service.DictService;
import com.els.modules.system.service.ElsCompanySetService;
import com.els.modules.system.vo.ElsCompanySetVO;
import com.els.modules.system.vo.ElsSetVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u4f01\u4e1a\u53c2\u6570\u8bbe\u7f6e")
@RestController
@RequestMapping(value={"/base/companySet"})
public class ElsCompanySetController
extends BaseController<ElsCompanySet, ElsCompanySetService> {
    @Autowired
    private ElsCompanySetService elsCompanySetService;
    @Autowired
    private DictService dictService;
    @Autowired
    private DictItemService dictItemService;

    @AutoLog(value="\u4f01\u4e1a\u53c2\u6570\u8bbe\u7f6e-\u67e5\u8be2\u53c2\u6570\u8bbe\u7f6e\u5217\u8868")
    @Operation(summary="\u67e5\u8be2\u53c2\u6570\u8bbe\u7f6e\u5217\u8868", description="\u67e5\u8be2\u53c2\u6570\u8bbe\u7f6e\u5217\u8868")
    @GetMapping(value={"/findList"})
    @RequiresPermissions(value={"system#companySet:findList"})
    public Result<?> findList() {
        ElsSetVO setVO = new ElsSetVO();
        List<ElsCompanySetVO> list = this.elsCompanySetService.findList(this.getTenantId());
        list.forEach(item -> {
            if (StrUtil.isNotBlank((CharSequence)item.getItemDescI18nKey()) && StrUtil.isNotBlank((CharSequence)item.getItemDesc())) {
                item.setItemDesc(I18nUtil.translate((String)item.getItemDescI18nKey(), (String)item.getItemDesc()));
            }
            if (StrUtil.isNotBlank((CharSequence)item.getItemNameI18nKey()) && StrUtil.isNotBlank((CharSequence)item.getItemName())) {
                item.setItemName(I18nUtil.translate((String)item.getItemNameI18nKey(), (String)item.getItemName()));
            }
        });
        setVO.setCompanySetList(list);
        return Result.ok((Object)setVO);
    }

    @SrmValidated
    @AutoLog(value="\u4f01\u4e1a\u53c2\u6570\u8bbe\u7f6e-\u4fdd\u5b58")
    @Operation(summary="\u4fdd\u5b58", description="\u4fdd\u5b58")
    @PostMapping(value={"/save"})
    @RequiresPermissions(value={"system#companySet:add"})
    @PermissionDataOpt(businessType="companySet", beanClass=ElsCompanySetService.class)
    public Result<?> save(@RequestBody ElsSetVO setVO) {
        String message = this.elsCompanySetService.save(setVO.getCompanySetList());
        return Result.ok((String)(message == null ? I18nUtil.translate((String)"i18n_alert_tkLR_2f0866fe", (String)"\u64cd\u4f5c\u6210\u529f") : message));
    }

    @Operation(summary="\u4f01\u4e1a\u53c2\u6570\u8bbe\u7f6e-\u83b7\u53d6\u4f01\u4e1a\u5f00\u542f\u6743\u9650\u7684\u6a21\u5757\u5217\u8868")
    @GetMapping(value={"/findOpenbusinessType"})
    @RequiresPermissions(value={"system#companySet:queryById"})
    public Result<?> findOpenbusinessType() {
        List<DictItem> dictItems = this.dictService.findOpenbusinessType();
        return Result.ok(dictItems);
    }
}

