/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enterprise.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.service.DictTranslateService;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.enterprise.entity.ElsEnterpriseInfo;
import com.els.modules.enterprise.entity.ElsEnterpriseInfoRecord;
import com.els.modules.enterprise.mapper.ElsEnterpriseInfoMapper;
import com.els.modules.enterprise.mapper.ElsEnterpriseInfoRecordMapper;
import com.els.modules.enterprise.rpc.service.EnterpriseInvokeBaseRpcService;
import com.els.modules.enterprise.rpc.service.EnterpriseInvokeSupplierRpcService;
import com.els.modules.enterprise.service.ElsEnterpriseInfoService;
import com.els.modules.enterprise.vo.EnterpriseInfoVo;
import com.els.modules.enterprise.vo.SupplierAddressInfoVo;
import com.els.modules.enterprise.vo.SupplierBankInfoVo;
import com.els.modules.enterprise.vo.SupplierContactsInfoVo;
import com.els.modules.supplier.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.supplier.api.dto.SupplierAddressInfoDTO;
import com.els.modules.supplier.api.dto.SupplierBankInfoDTO;
import com.els.modules.supplier.api.dto.SupplierContactsInfoDTO;
import com.els.modules.supplier.api.dto.SupplierMasterDataAndEnterpriseInfoDTO;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.CompanyService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ElsEnterpriseInfoServiceImpl
extends ServiceImpl<ElsEnterpriseInfoMapper, ElsEnterpriseInfo>
implements ElsEnterpriseInfoService,
CompanyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElsEnterpriseInfoServiceImpl.class);
    @Lazy
    @Resource
    private ElsEnterpriseInfoMapper elsEnterpriseInfoMapper;
    @Lazy
    @Resource
    private EnterpriseInvokeSupplierRpcService invokeSupplierRpcService;
    @Lazy
    @Resource
    private ElsEnterpriseInfoRecordMapper elsEnterpriseInfoRecordMapper;
    @Autowired
    @Lazy
    private ElsSubAccountService elsSubAccountService;
    @Lazy
    @Resource
    private EnterpriseInvokeBaseRpcService enterpriseInvokeBaseRpcService;
    @Resource
    @Lazy
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public void saveElsEnterpriseInfo(ElsEnterpriseInfo elsEnterpriseInfo) {
        ((ElsEnterpriseInfoMapper)this.baseMapper).insert((Object)elsEnterpriseInfo);
    }

    @Override
    public void updateElsEnterpriseInfo(ElsEnterpriseInfo elsEnterpriseInfo) {
        ((ElsEnterpriseInfoMapper)this.baseMapper).updateById((Object)elsEnterpriseInfo);
    }

    @Override
    public void delElsEnterpriseInfo(String id) {
        ((ElsEnterpriseInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsEnterpriseInfo(List<String> idList) {
        ((ElsEnterpriseInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public ElsEnterpriseInfo getByElsAccount(String elsAccount) {
        return this.elsEnterpriseInfoMapper.getByElsAccount(elsAccount);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void update(EnterpriseInfoVo enterpriseInfoVo) {
        List collect;
        Map<String, List<SupplierBankInfoVo>> itemMap;
        if (CollUtil.isNotEmpty(enterpriseInfoVo.getSupplierBankInfoList()) && CollUtil.isNotEmpty(itemMap = enterpriseInfoVo.getSupplierBankInfoList().stream().filter(x -> StrUtil.isNotBlank((CharSequence)x.getBankAccount())).collect(Collectors.groupingBy(SupplierBankInfoVo::getBankAccount)))) {
            for (String bankAccount : itemMap.keySet()) {
                List<SupplierBankInfoVo> itemMapList = itemMap.get(bankAccount);
                if (!CollUtil.isNotEmpty(itemMapList) || itemMapList.size() <= 1) continue;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_0WEeyIMK_3f1623ff", (String)"${0} \u94f6\u884c\u8d26\u53f7\u5df2\u5b58\u5728", (String[])new String[]{bankAccount}));
            }
        }
        if (CollUtil.isNotEmpty(enterpriseInfoVo.getSupplierContactsInfoList()) && !(collect = enterpriseInfoVo.getSupplierContactsInfoList().stream().map(SupplierContactsInfoVo::getSubAccount).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList())).isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_JeyVB_bee6f0d9", (String)"\u5b50\u8d26\u53f7\u91cd\u590d:") + collect);
        }
        enterpriseInfoVo.setMsgInfo(I18nUtil.translate((String)"i18n_alert_savaSuccess", (String)"\u4fdd\u5b58\u6210\u529f!"));
        boolean supplierInfoChangExistUnconfirmed = this.invokeSupplierRpcService.isSupplierInfoChangExistUnconfirmed(enterpriseInfoVo.getElsAccount());
        if (supplierInfoChangExistUnconfirmed) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_MKLMLjAEVHAHtW_4bc76bf5", (String)"\u5b58\u5728\u672a\u5b8c\u6210\u4f01\u4e1a\u4fe1\u606f\u53d8\u66f4\u5355\uff01"));
        }
        ElsEnterpriseInfoDTO elsEnterpriseInfoDTONew = new ElsEnterpriseInfoDTO();
        BeanUtils.copyProperties((Object)((Object)enterpriseInfoVo), (Object)elsEnterpriseInfoDTONew);
        List contactsInfoNew = BeanUtil.copyToList(enterpriseInfoVo.getSupplierContactsInfoList(), SupplierContactsInfoDTO.class);
        List addressInfoNew = BeanUtil.copyToList(enterpriseInfoVo.getSupplierAddressInfoList(), SupplierAddressInfoDTO.class);
        List bankInfoNew = BeanUtil.copyToList(enterpriseInfoVo.getSupplierBankInfoList(), SupplierBankInfoDTO.class);
        ElsEnterpriseInfo elsEnterpriseInfoOld = this.getByElsAccount(enterpriseInfoVo.getElsAccount());
        ElsEnterpriseInfoDTO elsEnterpriseInfoDTOOld = new ElsEnterpriseInfoDTO();
        BeanUtils.copyProperties((Object)((Object)elsEnterpriseInfoOld), (Object)elsEnterpriseInfoDTOOld);
        List<SupplierContactsInfoDTO> contactsInfoOld = this.invokeSupplierRpcService.getContactsDataOnlyAccount(enterpriseInfoVo.getElsAccount());
        List<SupplierAddressInfoDTO> addressInfoOld = this.invokeSupplierRpcService.getAddressDataOnlyAccount(enterpriseInfoVo.getElsAccount());
        List<SupplierBankInfoDTO> bankInfoOld = this.invokeSupplierRpcService.getBankDataOnlyAccount(enterpriseInfoVo.getElsAccount());
        EnterpriseInfoVo oldEnterpriseInfoVo = new EnterpriseInfoVo();
        BeanUtils.copyProperties((Object)((Object)elsEnterpriseInfoOld), (Object)((Object)oldEnterpriseInfoVo));
        oldEnterpriseInfoVo.setSupplierContactsInfoList(BeanUtil.copyToList(contactsInfoOld, SupplierContactsInfoVo.class));
        oldEnterpriseInfoVo.setSupplierAddressInfoList(BeanUtil.copyToList(addressInfoOld, SupplierAddressInfoVo.class));
        oldEnterpriseInfoVo.setSupplierBankInfoList(BeanUtil.copyToList(bankInfoOld, SupplierBankInfoVo.class));
        this.handleTagId(contactsInfoNew, addressInfoNew, bankInfoNew);
        List<SupplierMasterDataAndEnterpriseInfoDTO> purchaseList = this.invokeSupplierRpcService.selectPurchaseByToElsAccount(enterpriseInfoVo.getElsAccount());
        for (SupplierMasterDataAndEnterpriseInfoDTO infoDTO : purchaseList) {
            infoDTO.setSupplierInfoChangeAttachmentJson(JSONObject.toJSONString(enterpriseInfoVo.getSupplierInfoChangeAttachmentList()));
            infoDTO.setElsEnterpriseInfoNew(elsEnterpriseInfoDTONew);
            infoDTO.setSupplierContactsInfoListNew(contactsInfoNew);
            infoDTO.setSupplierAddressInfoListNew(addressInfoNew);
            infoDTO.setSupplierBankInfoListNew(bankInfoNew);
        }
        if (!purchaseList.isEmpty() && purchaseList.size() > 0) {
            String msgInfo = this.invokeSupplierRpcService.insertPurchaseInfoChang(purchaseList, enterpriseInfoVo.getUpdateType());
            if (StrUtil.isNotBlank((CharSequence)msgInfo)) {
                enterpriseInfoVo.setMsgInfo(msgInfo);
            }
            if ("1".equals(enterpriseInfoVo.getUpdateType()) && StrUtil.isBlank((CharSequence)msgInfo)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SThxLIiuPhxjAEVHAHt_843be3ac", (String)"\u65e0\u9700\u53d1\u5e03\uff0c\u672a\u68c0\u6d4b\u5230\u8981\u53d1\u5e03\u7684\u4f01\u4e1a\u4fe1\u606f\u53d8\u66f4\u5355"));
            }
        } else if ("1".equals(enterpriseInfoVo.getUpdateType())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SThxLIiuPhxjAEVHAHt_843be3ac", (String)"\u65e0\u9700\u53d1\u5e03\uff0c\u672a\u68c0\u6d4b\u5230\u8981\u53d1\u5e03\u7684\u4f01\u4e1a\u4fe1\u606f\u53d8\u66f4\u5355"));
        }
        this.updateEnterpriseInfo(enterpriseInfoVo, contactsInfoNew, addressInfoNew, bankInfoNew, elsEnterpriseInfoOld, contactsInfoOld, addressInfoOld, bankInfoOld);
    }

    public void updateEnterpriseInfo(EnterpriseInfoVo enterpriseInfoVo, List<SupplierContactsInfoDTO> contactsInfoNew, List<SupplierAddressInfoDTO> addressInfoNew, List<SupplierBankInfoDTO> bankInfoNew, ElsEnterpriseInfo elsEnterpriseInfoOld, List<SupplierContactsInfoDTO> contactsInfoOld, List<SupplierAddressInfoDTO> addressInfoOld, List<SupplierBankInfoDTO> bankInfoOld) {
        List<SupplierMasterDataDTO> datas;
        ArrayList<SupplierContactsInfoDTO> insertItems;
        ElsEnterpriseInfo elsEnterpriseInfo = new ElsEnterpriseInfo();
        BeanUtils.copyProperties((Object)((Object)enterpriseInfoVo), (Object)((Object)elsEnterpriseInfo));
        EnterpriseInfoVo infoRecord = this.insertInfoRecord(enterpriseInfoVo, elsEnterpriseInfoOld, contactsInfoOld, addressInfoOld, bankInfoOld);
        boolean count = this.updateById((Object)elsEnterpriseInfo);
        Assert.isTrue((boolean)count, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        if (contactsInfoNew != null) {
            this.invokeSupplierRpcService.deleteContactsByElsAccount(enterpriseInfoVo.getElsAccount());
            insertItems = new ArrayList<SupplierContactsInfoDTO>();
            for (SupplierContactsInfoDTO supplierContactsInfoDTO : contactsInfoNew) {
                supplierContactsInfoDTO.setId(null);
                supplierContactsInfoDTO.setTagId(StrUtil.isNotBlank((CharSequence)supplierContactsInfoDTO.getTagId()) ? supplierContactsInfoDTO.getTagId() : IdWorker.getIdStr());
                supplierContactsInfoDTO.setDeleted(CommonConstant.DEL_FLAG_0);
                supplierContactsInfoDTO.setCreateTime(new Date());
                insertItems.add(supplierContactsInfoDTO);
            }
            if (!insertItems.isEmpty()) {
                this.invokeSupplierRpcService.insertContactsBatchSomeColumn(insertItems);
            }
        }
        if (bankInfoNew != null) {
            this.invokeSupplierRpcService.deleteBankByElsAccount(enterpriseInfoVo.getElsAccount());
            insertItems = new ArrayList();
            for (SupplierBankInfoDTO supplierBankInfoDTO : bankInfoNew) {
                supplierBankInfoDTO.setId(null);
                supplierBankInfoDTO.setTagId(StrUtil.isNotBlank((CharSequence)supplierBankInfoDTO.getTagId()) ? supplierBankInfoDTO.getTagId() : IdWorker.getIdStr());
                supplierBankInfoDTO.setDeleted(CommonConstant.DEL_FLAG_0);
                supplierBankInfoDTO.setCreateTime(new Date());
                insertItems.add((SupplierContactsInfoDTO)supplierBankInfoDTO);
            }
            if (!insertItems.isEmpty()) {
                this.invokeSupplierRpcService.insertBankBatchSomeColumn(insertItems);
            }
        }
        if (addressInfoNew != null) {
            this.invokeSupplierRpcService.deleteAddressByElsAccount(enterpriseInfoVo.getElsAccount());
            insertItems = new ArrayList();
            for (SupplierAddressInfoDTO supplierAddressInfoDTO : addressInfoNew) {
                supplierAddressInfoDTO.setId(null);
                supplierAddressInfoDTO.setTagId(StrUtil.isNotBlank((CharSequence)supplierAddressInfoDTO.getTagId()) ? supplierAddressInfoDTO.getTagId() : IdWorker.getIdStr());
                supplierAddressInfoDTO.setDeleted(CommonConstant.DEL_FLAG_0);
                supplierAddressInfoDTO.setCreateTime(new Date());
                insertItems.add((SupplierContactsInfoDTO)supplierAddressInfoDTO);
            }
            if (!insertItems.isEmpty()) {
                this.invokeSupplierRpcService.insertAddressBatchSomeColumn(insertItems);
            }
        }
        if ((datas = this.invokeSupplierRpcService.listByToElsAccount(enterpriseInfoVo.getElsAccount())) != null && datas.size() > 0) {
            for (SupplierMasterDataDTO supplierMasterDataDTO : datas) {
                if (!supplierMasterDataDTO.getSupplierName().equals(elsEnterpriseInfo.getName())) {
                    supplierMasterDataDTO.setSupplierName(elsEnterpriseInfo.getName());
                    this.invokeSupplierRpcService.updateById(supplierMasterDataDTO);
                }
                if ("2".equals(supplierMasterDataDTO.getSupplierStatus())) {
                    MsgParamsVO msgParamsVO = this.parameterAssemble(supplierMasterDataDTO.getElsAccount(), StrUtil.isNotBlank((CharSequence)supplierMasterDataDTO.getPrincipal()) ? supplierMasterDataDTO.getPrincipal().split("_")[0] : "1001", infoRecord, enterpriseInfoVo);
                }
                supplierMasterDataDTO.setEnterpriseInfoRecordId(infoRecord.getElsEnterpriseInfoRecordId());
                this.invokeSupplierRpcService.updateById(supplierMasterDataDTO);
            }
        }
    }

    private void handleTagId(List<SupplierContactsInfoDTO> contactsInfoNew, List<SupplierAddressInfoDTO> addressInfoNew, List<SupplierBankInfoDTO> bankInfoNew) {
        if (CollUtil.isNotEmpty(contactsInfoNew) && contactsInfoNew.size() > 0) {
            contactsInfoNew.forEach(o -> o.setTagId(StrUtil.isNotBlank((CharSequence)o.getTagId()) ? o.getTagId() : IdWorker.getIdStr()));
        }
        if (CollUtil.isNotEmpty(addressInfoNew) && addressInfoNew.size() > 0) {
            addressInfoNew.forEach(o -> o.setTagId(StrUtil.isNotBlank((CharSequence)o.getTagId()) ? o.getTagId() : IdWorker.getIdStr()));
        }
        if (CollUtil.isNotEmpty(bankInfoNew) && bankInfoNew.size() > 0) {
            bankInfoNew.forEach(o -> o.setTagId(StrUtil.isNotBlank((CharSequence)o.getTagId()) ? o.getTagId() : IdWorker.getIdStr()));
        }
    }

    @Override
    public List<ElsEnterpriseInfo> selectWithoutElsAccountByElsAccountList(List<String> elsAccountList) {
        return ((ElsEnterpriseInfoMapper)this.baseMapper).selectWithoutElsAccountByElsAccountList(elsAccountList);
    }

    @Override
    public Map<String, Object> getEnterpriseOfSupplier(String elsAccount, String type) {
        List<String> supplierMasterElsAccount = this.invokeSupplierRpcService.getSupplierMasterElsAccount(elsAccount);
        QueryWrapper mapQueryWrapper = new QueryWrapper();
        List<Map<String, Object>> stringObjectMap = this.elsEnterpriseInfoMapper.getSupplierMasterElsAccount(supplierMasterElsAccount);
        HashMap<String, Object> dbmap = new HashMap<String, Object>();
        for (Map<String, Object> objectMap : stringObjectMap) {
            dbmap.put((String)objectMap.get("base"), objectMap.get("COUNT(id)"));
        }
        HashMap<String, Object> stringObjectHashMap = new HashMap<String, Object>();
        List dictDTOS = this.invokeBaseRpcService.queryDictItemsByCode("provinceAlias", "100000");
        for (DictDTO dictDTO : dictDTOS) {
            if (dbmap.containsKey(dictDTO.getValue())) {
                stringObjectHashMap.put(dictDTO.getValue(), dbmap.get(dictDTO.getValue()));
                continue;
            }
            stringObjectHashMap.put(dictDTO.getValue(), 0);
        }
        return stringObjectHashMap;
    }

    private MsgParamsVO parameterAssemble(String elsAccount, String subAccount, EnterpriseInfoVo infoRecord, EnterpriseInfoVo infoVo) {
        String id;
        List<TemplateConfigHeadDTO> enterpriseList;
        MsgParamsVO msgObj = new MsgParamsVO();
        LoginUserDTO user = SysUtil.getLoginUser();
        ElsSubAccountDTO sendObj = (ElsSubAccountDTO)SysUtil.copyProperties((Object)user, ElsSubAccountDTO.class);
        msgObj.setSendObj(sendObj);
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        ElsSubAccount subAccountInfo = this.elsSubAccountService.getByAccount(elsAccount, subAccount);
        ElsSubAccountDTO accountDTO = (ElsSubAccountDTO)SysUtil.copyProperties((Object)((Object)subAccountInfo), ElsSubAccountDTO.class);
        accountList.add(accountDTO);
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        receiverMap.put(elsAccount, accountList);
        msgObj.setReceiverMap(receiverMap);
        DictTranslateAspectParam param = new DictTranslateAspectParam();
        JSONObject oldObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)infoRecord, param);
        JSONObject newObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)infoVo, param);
        Set properties = newObject.keySet();
        List<TemplateHeadDTO> headList = this.enterpriseInvokeBaseRpcService.getDefaultTemplateByType("enterprise");
        HashMap enterpriseColumn = new HashMap();
        if (!headList.isEmpty() && (enterpriseList = this.enterpriseInvokeBaseRpcService.selectByMainId(id = headList.get(0).getId())) != null && enterpriseList.size() > 0) {
            for (TemplateConfigHeadDTO templateConfigHeadDTO : enterpriseList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("label", templateConfigHeadDTO.getFieldLabel());
                map.put("type", templateConfigHeadDTO.getFieldType());
                enterpriseColumn.put(templateConfigHeadDTO.getFieldName(), map);
            }
        }
        JSONObject data = new JSONObject();
        data.put("supplierAddressInfoList", (Object)new JSONArray());
        data.put("supplierBankInfoList", (Object)new JSONArray());
        data.put("supplierCertificatedInfoList", (Object)new JSONArray());
        data.put("supplierContactsInfoList", (Object)new JSONArray());
        data.put("supplierAddressInfoListOld", (Object)new JSONArray());
        data.put("supplierBankInfoListOld", (Object)new JSONArray());
        data.put("supplierCertificatedInfoListOld", (Object)new JSONArray());
        data.put("supplierContactsInfoListOld", (Object)new JSONArray());
        JSONArray array = new JSONArray();
        SimpleDateFormat dateStr = new SimpleDateFormat("yyyy-MM-dd");
        for (String string : properties) {
            String newValue = StrUtil.isNotBlank((CharSequence)newObject.getString(string + "_dictText")) ? newObject.getString(string + "_dictText") : newObject.getString(string);
            if (!StrUtil.isNotBlank((CharSequence)newValue)) continue;
            try {
                JSONArray oldArray;
                JSONArray tabArray = JSONObject.parseArray((String)newObject.getString(string));
                if (tabArray != null) {
                    for (Object object1 : tabArray) {
                        JSONObject jsonObject = JSONObject.parseObject((String)object1.toString());
                        Set keys = jsonObject.keySet();
                        for (String key : keys) {
                            if (!StrUtil.isNotBlank((CharSequence)jsonObject.getString(key + "_dictText"))) continue;
                            jsonObject.put(key, (Object)jsonObject.getString(key + "_dictText"));
                        }
                    }
                }
                if ((oldArray = JSONObject.parseArray((String)oldObject.getString(string))) != null) {
                    Object object1;
                    object1 = oldArray.iterator();
                    while (object1.hasNext()) {
                        Object object12 = object1.next();
                        JSONObject jsonObject = JSONObject.parseObject((String)object12.toString());
                        Set keys = jsonObject.keySet();
                        for (String key : keys) {
                            if (!StrUtil.isNotBlank((CharSequence)jsonObject.getString(key + "_dictText"))) continue;
                            jsonObject.put(key, (Object)jsonObject.getString(key + "_dictText"));
                        }
                    }
                }
                if ("supplierAddressInfoList".equals(string)) {
                    data.put("supplierAddressInfoList", (Object)tabArray);
                    data.put("supplierAddressInfoListOld", (Object)oldArray);
                }
                if ("supplierBankInfoList".equals(string)) {
                    data.put("supplierBankInfoList", (Object)tabArray);
                    data.put("supplierBankInfoListOld", (Object)oldArray);
                }
                if ("supplierCertificatedInfoList".equals(string)) {
                    data.put("supplierCertificatedInfoList", (Object)tabArray);
                    data.put("supplierCertificatedInfoListOld", (Object)oldArray);
                }
                if (!"supplierContactsInfoList".equals(string)) continue;
                data.put("supplierContactsInfoList", (Object)tabArray);
                data.put("supplierContactsInfoListOld", (Object)oldArray);
            }
            catch (Exception e) {
                Map map;
                String oldValue = StrUtil.isNotBlank((CharSequence)oldObject.getString(string + "_dictText")) ? oldObject.getString(string + "_dictText") : oldObject.getString(string);
                if (newValue.equals(oldValue) || "updateTime".equals(string) || "createTime".equals(string) || (map = (Map)enterpriseColumn.get(string)) == null) continue;
                JSONObject object = new JSONObject();
                if ("date".equals(map.get("type"))) {
                    Long newTime = null;
                    Long oldTime = null;
                    try {
                        newTime = dateStr.parse(newValue).getTime();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    if (StrUtil.isNotBlank((CharSequence)oldValue)) {
                        try {
                            oldTime = dateStr.parse(oldValue).getTime();
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                        if (oldTime == null || oldTime.equals(newTime)) continue;
                        object.put("column", map.get("label"));
                        object.put("old", (Object)dateStr.format(new Date(oldTime)));
                        object.put("new", (Object)dateStr.format(new Date(newTime)));
                        array.add((Object)object);
                        continue;
                    }
                    object.put("column", map.get("label"));
                    object.put("old", (Object)"");
                    object.put("new", (Object)dateStr.format(newTime));
                    array.add((Object)object);
                    continue;
                }
                object.put("column", map.get("label"));
                object.put("old", (Object)oldValue);
                object.put("new", (Object)newValue);
                array.add((Object)object);
            }
        }
        data.put("enterpriseInfoList", (Object)array);
        Map map = (Map)JSON.parse((String)data.toString());
        map.put("userName", subAccountInfo.getRealname());
        map.put("elsAccount", infoVo.getElsAccount());
        map.put("name", infoVo.getName());
        map.put("modifyPerson", "sale");
        msgObj.setParams((Object)map);
        return msgObj;
    }

    public EnterpriseInfoVo insertInfoRecord(EnterpriseInfoVo enterpriseInfoVo, ElsEnterpriseInfo elsEnterpriseOldInfo, List<SupplierContactsInfoDTO> contactsInfo, List<SupplierAddressInfoDTO> addressInfo, List<SupplierBankInfoDTO> bankInfo) {
        if (elsEnterpriseOldInfo != null) {
            EnterpriseInfoVo enterpriseInfoOldVo = new EnterpriseInfoVo();
            BeanUtils.copyProperties((Object)((Object)elsEnterpriseOldInfo), (Object)((Object)enterpriseInfoOldVo));
            enterpriseInfoOldVo.setSupplierContactsInfoList(BeanUtil.copyToList(contactsInfo, SupplierContactsInfoVo.class));
            enterpriseInfoOldVo.setSupplierAddressInfoList(BeanUtil.copyToList(addressInfo, SupplierAddressInfoVo.class));
            enterpriseInfoOldVo.setSupplierBankInfoList(BeanUtil.copyToList(bankInfo, SupplierBankInfoVo.class));
            int version = this.elsEnterpriseInfoRecordMapper.getMaxVersionByAccount(enterpriseInfoVo.getElsAccount());
            ElsEnterpriseInfoRecord infoRecord = new ElsEnterpriseInfoRecord();
            infoRecord.setElsAccount(enterpriseInfoVo.getElsAccount());
            infoRecord.setVersion(version);
            infoRecord.setInfo(JSONObject.toJSONString((Object)((Object)enterpriseInfoOldVo)));
            this.elsEnterpriseInfoRecordMapper.insert((Object)infoRecord);
            enterpriseInfoOldVo.setElsEnterpriseInfoRecordId(infoRecord.getId());
            return enterpriseInfoOldVo;
        }
        return null;
    }

    @Override
    public Map<String, String> getCompanyName(String elsAccount) {
        HashMap<String, String> map = new HashMap<String, String>();
        ElsEnterpriseInfo info = this.elsEnterpriseInfoMapper.getByElsAccount(elsAccount);
        if (info != null) {
            map.put("fullName", info.getName());
            map.put("shortName", info.getAlias());
        }
        return map;
    }
}

