/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.justauth.state;

import jakarta.annotation.Resource;
import java.util.concurrent.TimeUnit;
import me.zhyd.oauth.cache.AuthStateCache;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisStateCache
implements AuthStateCache {
    @Resource
    private RedisTemplate<String, String> redisTemplate;
    private static final String REDIS_KEY = "srm:base:third_auth:state:";

    public void cache(String key, String value) {
        this.cache(key, value, 600L);
    }

    public void cache(String key, String value, long timeout) {
        this.redisTemplate.opsForValue().set((Object)(REDIS_KEY + key), (Object)value, timeout, TimeUnit.MILLISECONDS);
    }

    public String get(String key) {
        return (String)this.redisTemplate.opsForValue().get((Object)(REDIS_KEY + key));
    }

    public boolean containsKey(String key) {
        if (Boolean.FALSE.equals(this.redisTemplate.hasKey((Object)(REDIS_KEY + key)))) {
            return false;
        }
        Long expire = this.redisTemplate.getExpire((Object)(REDIS_KEY + key), TimeUnit.MILLISECONDS);
        if (null == expire) {
            return false;
        }
        return expire > 0L;
    }
}

