/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.auth.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.useragent.UserAgent;
import cn.hutool.http.useragent.UserAgentUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.enumerate.DeployWayEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.util.AddressUtil;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.ConfigUtil;
import com.els.common.util.EmailUtil;
import com.els.common.util.FreeMarkerTemplateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.IPUtils;
import com.els.common.util.MqUtil;
import com.els.common.util.PasswordUtil;
import com.els.common.util.RedisKeyUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SrmRpcUtil;
import com.els.common.util.SysUtil;
import com.els.common.util.TenantParamUtil;
import com.els.common.util.encryption.RsaEncryptUtil;
import com.els.common.util.sms.SmsResult;
import com.els.common.util.sms.SmsUtil;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.account.password.entity.PasswordSecurity;
import com.els.modules.account.password.service.PasswordSecurityService;
import com.els.modules.auth.service.LoginService;
import com.els.modules.auth.vo.LoginByAccountVO;
import com.els.modules.auth.vo.LoginByPhoneVO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.enterprise.api.service.ElsEnterpriseInfoRpcService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.ElsTenant;
import com.els.modules.system.entity.SubaccountOrg;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.ElsTenantService;
import com.els.modules.system.service.SubaccountOrgService;
import com.j256.twofactorauth.TimeBasedOneTimePasswordUtil;
import freemarker.template.Template;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class LoginServiceImpl
implements LoginService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoginServiceImpl.class);
    private static final String PUBLIC_KEY = "srm:base:auth:publicKey:";
    private static final String TEMP_TOKEN = "srm:base:auth:tempToken:";
    private static final String PASSWORD_ERROR_COUNT = "srm:base:auth:passwordErrorCount:";
    private static final String ACCOUNT_LOCK = "srm:base:auth:accountLock:";
    private static final String ACCOUNT_AUTH_ERROR_COUNT_REDIS_KEY = "srm:base:auth:errorCount:";
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private ElsSubAccountService accountInfoService;
    @Resource
    private ElsTenantService tenantService;
    @Resource
    private PasswordSecurityService passwordSecurityService;
    @Resource
    private SubaccountOrgService accountOrgService;
    private final String version = this.getClass().getPackage().getImplementationVersion();

    @Override
    public JSONObject getEncryptedKey() throws Exception {
        JSONObject result = new JSONObject();
        String keyId = IdWorker.getIdStr();
        Map keyMap = RsaEncryptUtil.genKeyPair();
        result.put("key", keyMap.get("publicKey"));
        result.put("keyId", (Object)keyId);
        this.redisUtil.set(PUBLIC_KEY + keyId, keyMap.get("privateKey"), 86400L);
        return result;
    }

    private void accountLoginParamCheck(LoginByAccountVO login) {
        if (StrUtil.isBlank((CharSequence)login.getElsAccount())) {
            throw new ELSBootException("elsAccount \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isBlank((CharSequence)login.getSubAccount())) {
            throw new ELSBootException("subAccount \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isBlank((CharSequence)login.getPassword())) {
            throw new ELSBootException("password \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isBlank((CharSequence)login.getKeyId())) {
            throw new ELSBootException("\u5f53\u524d\u9875\u9762\u4fe1\u606f\u5df2\u7ecf\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u767b\u5f55\uff01");
        }
    }

    private void checkAccount(ElsSubAccount account) {
        if (account == null) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef"));
        }
        if (account.getStatus() == null || account.getStatus() != 1) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u8be5\u7528\u6237\u5df2\u51bb\u7ed3"));
        }
        if (account.getAccountValidityDate() != null && DateUtil.compare((Date)new Date(), (Date)account.getAccountValidityDate(), (String)"yyyy-MM-dd") > 0) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u8be5\u7528\u6237\u8d26\u53f7\u5df2\u5931\u6548\uff01"));
        }
        this.checkTenant(account);
    }

    private void checkTenant(ElsSubAccount account) {
        if (DeployWayEnum.SAAS.getValue().equals(ConfigUtil.getDeployWay()) && !ConfigUtil.getPurchaseAccount().equals(account.getElsAccount())) {
            ElsTenant tenant = this.tenantService.findTenant(account.getElsAccount());
            if (tenant == null) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u8be5ELS\u8d26\u53f7\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
            }
            if ("2".equals(tenant.getAccountStatus())) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u8be5ELS\u8d26\u53f7\u5df2\u51bb\u7ed3\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
            }
            if (tenant.getExpiryDate() != null && DateUtil.compare((Date)new Date(), (Date)tenant.getExpiryDate(), (String)"yyyy-MM-dd") > 0) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u8be5ELS\u8d26\u53f7\u5df2\u8fc7\u6709\u6548\u65e5\u671f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
            }
        }
    }

    private String getTempTokenRedisKey(String elsAccount, String subAccount, String tempToken) {
        StringBuilder builder = new StringBuilder(TEMP_TOKEN);
        builder.append(elsAccount).append(":").append(subAccount).append(":").append(tempToken);
        return builder.toString();
    }

    private String getAuthErrorCountRedisKey(String mobilePhone) {
        StringBuilder builder = new StringBuilder(ACCOUNT_AUTH_ERROR_COUNT_REDIS_KEY);
        builder.append(mobilePhone);
        return builder.toString();
    }

    private String getPasswordErrorCountRedisKey(String elsAccount, String subAccount) {
        StringBuilder builder = new StringBuilder(PASSWORD_ERROR_COUNT);
        builder.append(elsAccount).append(":").append(subAccount);
        return builder.toString();
    }

    @Override
    public String getAccountLockRedisKey(String elsAccount, String subAccount) {
        StringBuilder builder = new StringBuilder(ACCOUNT_LOCK);
        builder.append(elsAccount).append(":").append(subAccount);
        return builder.toString();
    }

    private void accountLockCheck(String elsAccount, String subAccount) {
        String accountLockRedisKey = this.getAccountLockRedisKey(elsAccount, subAccount);
        if (this.redisUtil.hasKey(accountLockRedisKey)) {
            long time = this.redisUtil.getExpire(accountLockRedisKey);
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5bc6\u7801\u9519\u8bef\u6b21\u6570\u8fc7\u591a\uff0c\u8d26\u53f7\u5df2\u7ecf\u9501\u5b9a\uff0c\u8bf7\u5728{0}\u79d2\u540e\u518d\u8bd5\uff01", (String[])new String[]{"" + time}));
        }
        PasswordSecurity security = this.passwordSecurityService.getByElsAccount(elsAccount);
        if (security != null) {
            Integer errorLock = security.getErrorLock();
            if (errorLock == null || errorLock == 0) {
                return;
            }
            String passwordErrorCountRedisKey = this.getPasswordErrorCountRedisKey(elsAccount, subAccount);
            if (!this.redisUtil.hasKey(passwordErrorCountRedisKey)) {
                return;
            }
            int errorLockTime = security.getErrorLockTime() == null ? 5 : security.getErrorLockTime();
            int errorCount = (Integer)this.redisUtil.get(passwordErrorCountRedisKey);
            if (errorCount >= errorLock) {
                this.redisUtil.set(accountLockRedisKey, (Object)"lock", (long)errorLockTime * 60L);
                this.redisUtil.del(new String[]{passwordErrorCountRedisKey});
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5bc6\u7801\u9519\u8bef\u6b21\u6570\u8fc7\u591a\uff0c\u8d26\u53f7\u5df2\u7ecf\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01"));
            }
        }
    }

    @Override
    public JSONObject loginByAccount(LoginByAccountVO login) {
        long beginTime = System.currentTimeMillis();
        try {
            this.accountLoginParamCheck(login);
            String elsAccount = login.getElsAccount().trim();
            String subAccount = login.getSubAccount().trim();
            String password = login.getPassword();
            String keyId = login.getKeyId();
            String tempToken = login.getTempToken();
            this.accountLockCheck(elsAccount, subAccount);
            ElsSubAccount account = this.accountInfoService.getByAccount(elsAccount, subAccount);
            if (StrUtil.isBlank((CharSequence)tempToken)) {
                this.checkAccount(account);
                if (!this.redisUtil.hasKey(PUBLIC_KEY + keyId)) {
                    throw new ELSBootException("\u5f53\u524d\u9875\u9762\u4fe1\u606f\u5df2\u7ecf\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u767b\u5f55\uff01");
                }
                try {
                    password = RsaEncryptUtil.decrypt((String)password, (String)((String)this.redisUtil.get(PUBLIC_KEY + keyId)));
                }
                catch (Exception e) {
                    log.error("RsaEncryptUtil_decrypt_failed:", (Throwable)e);
                }
                String checkPassword = PasswordUtil.encrypt((String)(account.getElsAccount() + "_" + account.getSubAccount()), (String)password, (String)account.getSalt());
                String userPassword = account.getPassword();
                if (!checkPassword.equals(userPassword)) {
                    String passwordErrorCountRedisKey = this.getPasswordErrorCountRedisKey(elsAccount, subAccount);
                    if (this.redisUtil.hasKey(passwordErrorCountRedisKey)) {
                        this.redisUtil.incr(passwordErrorCountRedisKey, 1L);
                    } else {
                        this.redisUtil.setIncr(passwordErrorCountRedisKey, (Object)1, 86400L);
                    }
                    throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef"));
                }
                String mfaSwitch = TenantParamUtil.getParamValueByCode((String)account.getElsAccount(), (String)"mfaSwitch");
                if ("1".equals(mfaSwitch)) {
                    JSONObject obj = new JSONObject();
                    obj.put("returnType", (Object)"mfaCheck");
                    if (StrUtil.isBlank((CharSequence)account.getPhone())) {
                        obj.put("sms", (Object)"0");
                    } else {
                        obj.put("sms", (Object)"1");
                        obj.put("phone", (Object)DesensitizedUtil.mobilePhone((String)account.getPhone()));
                    }
                    if (StrUtil.isBlank((CharSequence)account.getSecret())) {
                        obj.put("otp", (Object)"0");
                    } else {
                        obj.put("otp", (Object)"1");
                    }
                    tempToken = IdWorker.get32UUID();
                    obj.put("tempToken", (Object)tempToken);
                    this.redisUtil.set(this.getTempTokenRedisKey(account.getElsAccount(), account.getSubAccount(), tempToken), (Object)account.getPhone(), 600L);
                    if (StrUtil.isBlank((CharSequence)account.getPhone()) && StrUtil.isBlank((CharSequence)account.getSecret())) {
                        throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u8be5\u8d26\u53f7\u672a\u7ed1\u5b9a\u624b\u673a\u53f7\u4e14\u672a\u8bbe\u7f6eOTP\u5bc6\u94a5\uff0c\u4e8c\u6b21\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01"));
                    }
                    return obj;
                }
            } else {
                if (!this.redisUtil.hasKey(this.getTempTokenRedisKey(account.getElsAccount(), account.getSubAccount(), tempToken))) {
                    throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u4e34\u65f6Token\u5df2\u5931\u6548\uff0c\u8bf7\u8fd4\u56de\u767b\u5f55\u9875\u91cd\u65b0\u8fdb\u884c\u767b\u5f55\u64cd\u4f5c\uff01"));
                }
                this.checkMfa(login, account);
            }
            return this.buildLoginResult(beginTime, account);
        }
        catch (Exception e) {
            log.error("loginByAccount_failed:", (Throwable)e);
            ElsSubAccount account = new ElsSubAccount();
            BeanUtils.copyProperties((Object)login, (Object)((Object)account));
            this.sendLoginLog(beginTime, account, "1", "\u8d26\u53f7: " + account.getElsAccount() + "_" + account.getSubAccount() + ",\u767b\u5f55\u5931\u8d25\uff01\u65f6\u95f4\uff1a" + DateUtil.formatDateTime((Date)new Date()) + ",\u539f\u56e0\uff1a" + e.getMessage());
            throw e;
        }
    }

    @Override
    public JSONObject buildLoginResult(long beginTime, ElsSubAccount account) {
        Set keys;
        JSONObject result = new JSONObject();
        String password = account.getPassword();
        String elsAccount = account.getElsAccount();
        String subAccount = account.getSubAccount();
        JSONObject tenantParam = null;
        tenantParam = DeployWayEnum.SAAS.getValue().equals(ConfigUtil.getDeployWay()) ? TenantParamUtil.getParamObject((String)elsAccount) : TenantParamUtil.getParamObject((String)ConfigUtil.getPurchaseAccount());
        this.addCompanyInfo(tenantParam, elsAccount);
        String repeatLogin = tenantParam.getString("repeatLogin");
        if ("0".equals(repeatLogin) && CollUtil.isNotEmpty((Collection)(keys = this.redisUtil.getKeys(JwtUtil.getTokenRedisKeyPrefix((String)elsAccount, (String)subAccount) + "*")))) {
            this.redisUtil.dels(JwtUtil.getTokenRedisKeyPrefix((String)elsAccount, (String)subAccount));
            this.sendRepeatLoginAlert(account);
        }
        String token = JwtUtil.sign((String)elsAccount, (String)subAccount, (String)password);
        String tokenRedisKey = JwtUtil.getTokenRedisKey((String)elsAccount, (String)subAccount, (String)token);
        this.redisUtil.set(tokenRedisKey, (Object)token, (long)JwtUtil.expireTime());
        result.put("token", (Object)token);
        result.put("userInfo", (Object)this.accountInfoDesensitize(account));
        result.put("userOrg", (Object)this.getUserOrg(account.getId()));
        result.put("companySet", (Object)tenantParam);
        result.put("serviceAddress", (Object)ConfigUtil.getServiceAddress());
        result.put("srmVersion", (Object)this.version);
        String shiroRedisKey = RedisKeyUtil.getShiroRedisKey((String)elsAccount, (String)subAccount);
        this.redisUtil.del(new String[]{shiroRedisKey});
        this.redisUtil.del(new String[]{RedisKeyUtil.getPermissionMenuRedisKey((String)elsAccount, (String)subAccount)});
        this.redisUtil.del(new String[]{RedisKeyUtil.getAdminFlagRedisKey((String)elsAccount, (String)subAccount)});
        RedisKeyUtil.clearLoginUserCache((String)elsAccount, (String)subAccount);
        this.sendLoginLog(beginTime, account, "1", "\u8d26\u53f7: " + account.getElsAccount() + "_" + account.getSubAccount() + ",\u767b\u5f55\u6210\u529f\uff01\u65f6\u95f4\uff1a" + DateUtil.formatDateTime((Date)new Date()));
        return result;
    }

    private void addCompanyInfo(JSONObject tenantParam, String elsAccount) {
        ElsEnterpriseInfoDTO enterpriseInfo;
        if (!DeployWayEnum.SAAS.getValue().equals(ConfigUtil.getDeployWay())) {
            elsAccount = ConfigUtil.getPurchaseAccount();
        }
        if ((enterpriseInfo = ((ElsEnterpriseInfoRpcService)SrmRpcUtil.getExecuteServiceImpl(ElsEnterpriseInfoRpcService.class)).getByElsAccount(elsAccount)) != null) {
            tenantParam.put("companyName", (Object)enterpriseInfo.getName());
            tenantParam.put("companyLogo", (Object)enterpriseInfo.getEnterpriseLogo());
            tenantParam.put("companyShortName", (Object)enterpriseInfo.getAlias());
        }
    }

    private JSONObject getUserOrg(String accountId) {
        JSONObject userOrg = new JSONObject();
        List<SubaccountOrg> accountOrgList = this.accountOrgService.selectByMainId(accountId);
        Map<String, List<SubaccountOrg>> orgMap = accountOrgList.stream().collect(Collectors.groupingBy(SubaccountOrg::getOrgCategoryCode));
        for (String orgType : orgMap.keySet()) {
            List<SubaccountOrg> orgList = orgMap.get(orgType);
            JSONArray array = new JSONArray();
            for (SubaccountOrg accountOrg : orgList) {
                JSONObject obj = new JSONObject();
                obj.put("orgCode", (Object)accountOrg.getOrgCode());
                obj.put("orgName", (Object)accountOrg.getOrgName());
                array.add((Object)obj);
            }
            userOrg.put(orgType, (Object)array);
        }
        return userOrg;
    }

    private void sendRepeatLoginAlert(ElsSubAccount accountInfo) {
        if (StrUtil.isNotBlank((CharSequence)accountInfo.getEmail())) {
            try {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                String ip = IPUtils.getIpAddr();
                paramMap.put("systemAddr", ConfigUtil.getServiceAddress());
                paramMap.put("elsAccount", accountInfo.getElsAccount());
                paramMap.put("subAccount", accountInfo.getSubAccount());
                paramMap.put("loginTime", DateUtil.formatDateTime((Date)new Date()));
                paramMap.put("loginIp", ip);
                paramMap.put("loginCity", AddressUtil.getAddressCity((String)ip));
                Template temp = FreeMarkerTemplateUtils.getTemplate((String)"repeatLoginAlert.ftl");
                StringWriter stringWriter = new StringWriter();
                temp.process(paramMap, (Writer)stringWriter);
                EmailUtil.sendEmailToQueue((String)ConfigUtil.getPurchaseAccount(), (String)"SRM \u8d26\u53f7\u91cd\u590d\u767b\u5f55\u8b66\u544a!!!", (String)stringWriter.toString(), (String)accountInfo.getEmail(), (String[])new String[]{accountInfo.getEmail()});
            }
            catch (Exception e) {
                log.error("\u53d1\u9001\u91cd\u590d\u767b\u5f55\u8b66\u544a\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
    }

    private void sendLoginLog(long beginTime, ElsSubAccount accountInfo, String logType, String logContent) {
        JSONObject obj = new JSONObject();
        obj.put("id", (Object)IdWorker.getIdStr());
        obj.put("logType", (Object)logType);
        obj.put("logContent", (Object)logContent);
        obj.put("businessName", (Object)"\u767b\u5f55\u8ba4\u8bc1");
        obj.put("operateName", (Object)logType);
        HttpServletRequest httpServletRequest = SpringContextUtils.getHttpServletRequest();
        obj.put("ip", (Object)IPUtils.getIpAddr((HttpServletRequest)httpServletRequest));
        obj.put("createTime", (Object)DateUtil.formatDateTime((Date)new Date()));
        if (accountInfo != null) {
            obj.put("elsAccount", (Object)accountInfo.getElsAccount());
            obj.put("userId", (Object)accountInfo.getSubAccount());
            obj.put("userName", (Object)accountInfo.getRealname());
            obj.put("businessId", (Object)accountInfo.getId());
            obj.put("businessNumber", (Object)accountInfo.getSubAccount());
        }
        obj.put("requestType", (Object)(httpServletRequest.getMethod() + " " + httpServletRequest.getRequestURI()));
        obj.put("costTime", (Object)(System.currentTimeMillis() - beginTime));
        String userAgentString = httpServletRequest.getHeader("User-Agent");
        if (StringUtils.isNotBlank((CharSequence)userAgentString)) {
            UserAgent userAgent = UserAgentUtil.parse((String)userAgentString);
            obj.put("browser", (Object)userAgent.getBrowser().getName());
            obj.put("browserVersion", (Object)userAgent.getVersion());
            obj.put("operateSystem", (Object)userAgent.getOs().toString());
        }
        MqUtil.sendLogMsg((String)obj.toString());
    }

    private ElsSubAccount accountInfoDesensitize(ElsSubAccount account) {
        account.setPassword(null);
        account.setSecret(null);
        account.setSalt(null);
        return account;
    }

    private void checkMfa(LoginByAccountVO login, ElsSubAccount account) {
        String mfaType = login.getMfaType();
        String captcha = login.getCaptcha();
        if (StrUtil.isBlank((CharSequence)mfaType)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u4e8c\u6b21\u6821\u9a8c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if ("sms".equals(mfaType)) {
            String authCodeRedisKey = this.getSmsAuthCodeRedisKey(account.getPhone());
            if (!captcha.equals(this.redisUtil.get(authCodeRedisKey))) {
                String errorCountRedisKey = this.getAuthErrorCountRedisKey(account.getPhone());
                long errorCount = 1L;
                if (this.redisUtil.hasKey(errorCountRedisKey)) {
                    errorCount = this.redisUtil.incr(errorCountRedisKey, 1L);
                } else {
                    this.redisUtil.setIncr(errorCountRedisKey, (Object)errorCount);
                }
                if (errorCount > 2L) {
                    this.redisUtil.del(new String[]{authCodeRedisKey});
                    this.redisUtil.del(new String[]{errorCountRedisKey});
                }
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u8005\u5df2\u7ecf\u5931\u6548\uff01"));
            }
            this.redisUtil.del(new String[]{authCodeRedisKey});
        } else {
            try {
                String code = TimeBasedOneTimePasswordUtil.generateCurrentNumberString((String)account.getSecret());
                log.info("opt_check,captcha:" + captcha + ",code:" + code + ",otpSecret:" + account.getSecret());
                if (!captcha.equals(code)) {
                    throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u8005\u5df2\u7ecf\u5931\u6548\uff01"));
                }
            }
            catch (GeneralSecurityException e) {
                log.error("TimeBasedOneTimePasswordUtil_generateCurrentNumberString_failed:", (Throwable)e);
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"OTP\u9a8c\u8bc1\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01"));
            }
        }
    }

    private void phoneLoginParamCheck(LoginByPhoneVO login) {
        if (StrUtil.isBlank((CharSequence)login.getMobilePhone())) {
            throw new ELSBootException("mobilePhone \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isBlank((CharSequence)login.getCaptcha())) {
            throw new ELSBootException("captcha \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    @Override
    public JSONObject loginByPhone(LoginByPhoneVO login) {
        long beginTime = System.currentTimeMillis();
        try {
            ElsSubAccount accountInfo;
            this.phoneLoginParamCheck(login);
            String captcha = login.getCaptcha();
            String mobilePhone = login.getMobilePhone();
            String authCodeRedisKey = this.getSmsAuthCodeRedisKey(mobilePhone);
            if (!captcha.equals(this.redisUtil.get(authCodeRedisKey))) {
                String errorCountRedisKey = this.getAuthErrorCountRedisKey(mobilePhone);
                long errorCount = 1L;
                if (this.redisUtil.hasKey(errorCountRedisKey)) {
                    errorCount = this.redisUtil.incr(errorCountRedisKey, 1L);
                } else {
                    this.redisUtil.setIncr(errorCountRedisKey, (Object)errorCount);
                }
                if (errorCount > 2L) {
                    this.redisUtil.del(new String[]{authCodeRedisKey});
                    this.redisUtil.del(new String[]{errorCountRedisKey});
                }
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u8005\u5df2\u7ecf\u5931\u6548\uff01"));
            }
            String accountId = login.getAccountId();
            if (StrUtil.isBlank((CharSequence)accountId)) {
                List accountList = this.accountInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ElsSubAccount::getPhone, (Object)mobilePhone)).eq(ElsSubAccount::getStatus, (Object)"1"));
                List<ElsSubAccount> resultList = accountList.stream().filter(account -> account.getAccountValidityDate() == null || DateUtil.compare((Date)new Date(), (Date)account.getAccountValidityDate(), (String)"yyyy-MM-dd") <= 0).toList();
                if (resultList.isEmpty()) {
                    throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u8be5\u624b\u673a\u53f7\u5728\u7cfb\u7edf\u4e2d\u6ca1\u6709\u7ed1\u5b9a\u8d26\u53f7\uff01"));
                }
                if (resultList.size() > 1) {
                    JSONObject resultObj = new JSONObject();
                    resultObj.put("returnType", (Object)"selectAccount");
                    JSONArray array = new JSONArray();
                    for (ElsSubAccount account2 : resultList) {
                        JSONObject item = new JSONObject();
                        item.put("accountId", (Object)account2.getId());
                        item.put("elsAccount", (Object)account2.getElsAccount());
                        item.put("subAccount", (Object)account2.getSubAccount());
                        item.put("realname", (Object)account2.getRealname());
                        array.add((Object)item);
                    }
                    resultObj.put("accountList", (Object)array);
                    return resultObj;
                }
                accountInfo = resultList.get(0);
            } else {
                accountInfo = (ElsSubAccount)((Object)this.accountInfoService.getById((Serializable)((Object)accountId)));
                if (accountInfo == null) {
                    throw new ELSBootException(I18nUtil.translate((String)"", (String)"accountId \u53c2\u6570\u503c\u9519\u8bef\uff01"));
                }
            }
            this.checkAccount(accountInfo);
            this.redisUtil.del(new String[]{authCodeRedisKey});
            return this.buildLoginResult(beginTime, accountInfo);
        }
        catch (Exception e) {
            log.error("loginByPhone_failed:", (Throwable)e);
            ElsSubAccount account3 = new ElsSubAccount();
            account3.setId(login.getAccountId());
            this.sendLoginLog(beginTime, account3, "1", "\u624b\u673a\u53f7: " + login.getMobilePhone() + ",\u767b\u5f55\u5931\u8d25\uff01\u65f6\u95f4\uff1a" + DateUtil.formatDateTime((Date)new Date()) + ",\u539f\u56e0\uff1a" + e.getMessage());
            throw e;
        }
    }

    @Override
    public void logout() {
        long beginTime = System.currentTimeMillis();
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        ElsSubAccount account = new ElsSubAccount();
        BeanUtils.copyProperties((Object)loginUser, (Object)((Object)account));
        String token = SpringContextUtils.getHttpServletRequest().getHeader("X-Token");
        String tokenRedisKey = JwtUtil.getTokenRedisKey((String)loginUser.getElsAccount(), (String)loginUser.getSubAccount(), (String)token);
        this.redisUtil.del(new String[]{tokenRedisKey});
        String adminFlagRedisKey = RedisKeyUtil.getAdminFlagRedisKey((String)loginUser.getElsAccount(), (String)loginUser.getSubAccount());
        this.redisUtil.del(new String[]{adminFlagRedisKey});
        this.sendLoginLog(beginTime, account, "1", "\u8d26\u53f7: " + account.getElsAccount() + "_" + account.getSubAccount() + ",\u767b\u51fa\u6210\u529f\uff01\u65f6\u95f4\uff1a" + DateUtil.formatDateTime((Date)new Date()));
    }

    private String getSmsAuthCodeRedisKey(String mobilePhone) {
        return "sys:sms:captcha:" + mobilePhone;
    }

    @Override
    public void sendSmsAuthCode(String mobilePhone) {
        if (StrUtil.isBlank((CharSequence)mobilePhone)) {
            throw new ELSBootException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String redisKey = this.getSmsAuthCodeRedisKey(mobilePhone);
        if (this.redisUtil.hasKey(redisKey)) {
            throw new ELSBootException("\u9a8c\u8bc1\u7801\u5df2\u53d1\u9001\uff0c10\u5206\u949f\u5185\u6709\u6548");
        }
        String authCode = RandomUtil.randomNumbers((int)6);
        SmsResult smsResult = SmsUtil.sendSmsCode((String)ConfigUtil.getPurchaseAccount(), (String)mobilePhone, (String)authCode);
        if (!smsResult.isSuccess()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u77ed\u4fe1\u9a8c\u8bc1\u7801\u53d1\u9001\u5931\u8d25\uff1a") + smsResult.getMessage());
        }
        this.redisUtil.set(redisKey, (Object)authCode, 600L);
    }

    @Override
    public JSONObject loginByToken(String token) {
        String subAccount;
        long beginTime = System.currentTimeMillis();
        JSONObject accountObj = JwtUtil.getAccountObj((String)token);
        if (accountObj == null || !accountObj.containsKey((Object)"elsAccount")) {
            throw new AuthenticationException(I18nUtil.translate((String)"", (String)"token\u975e\u6cd5\u65e0\u6548!"));
        }
        String elsAccount = accountObj.getString("elsAccount");
        String tokenRedisKey = JwtUtil.getTokenRedisKey((String)elsAccount, (String)(subAccount = accountObj.getString("subAccount")), (String)token);
        if (!this.redisUtil.hasKey(tokenRedisKey)) {
            throw new AuthenticationException(I18nUtil.translate((String)"", (String)"Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55!"));
        }
        ElsSubAccount account = this.accountInfoService.getByAccount(elsAccount, subAccount);
        this.checkAccount(account);
        return this.buildLoginResult(beginTime, account);
    }
}

