/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.account.api.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.SrmPageDTO;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.SrmUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.RoleDTO;
import com.els.modules.account.api.service.UserRoleRpcService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.service.UserRoleService;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;

@RpcService
public class UserRoleBeanServiceImpl
implements UserRoleRpcService {
    @Resource
    private UserRoleService userRoleService;
    @Resource
    private ElsSubAccountService elsSubAccountService;
    @Resource
    private RoleService roleService;

    public List<ElsSubAccountDTO> getAccountListByRoles(String roles) {
        String[] roleArray = roles.split(",");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"role_id", (Object[])roleArray);
        List roleList = this.userRoleService.list((Wrapper)queryWrapper);
        if (roleList.isEmpty()) {
            return new ArrayList<ElsSubAccountDTO>();
        }
        List idList = roleList.stream().map(UserRole::getUserId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
        userWrapper.eq(ElsSubAccount::getStatus, (Object)1);
        userWrapper.in(ParentEntity::getId, idList);
        List accountList = this.elsSubAccountService.list((Wrapper)userWrapper);
        return SysUtil.copyProperties((List)accountList, ElsSubAccountDTO.class);
    }

    public List<ElsSubAccountDTO> getAccountListByRolesCode(String roles) {
        Object[] roleArray = roles.split(",");
        List list = ((LambdaQueryChainWrapper)this.roleService.lambdaQuery().in(Role::getRoleCode, roleArray)).list();
        List collect = list.parallelStream().map(ParentEntity::getId).collect(Collectors.toList());
        List roleList = ((LambdaQueryChainWrapper)this.userRoleService.lambdaQuery().in(UserRole::getRoleId, collect)).list();
        List idList = roleList.stream().map(UserRole::getUserId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
        userWrapper.eq(ElsSubAccount::getStatus, (Object)1);
        userWrapper.in(ParentEntity::getId, idList);
        List accountList = this.elsSubAccountService.list((Wrapper)userWrapper);
        return SysUtil.copyProperties((List)accountList, ElsSubAccountDTO.class);
    }

    public void insertRole(RoleDTO roleDTO) {
        Role role = new Role();
        BeanUtils.copyProperties((Object)roleDTO, (Object)((Object)role));
        this.roleService.save((Object)role);
    }

    public SrmPageDTO<RoleDTO> getRolePage(int pageIndex, int pageSize, String elsAccount) {
        Page page = new Page((long)pageIndex, (long)pageSize);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ParentEntity::getElsAccount, (Object)elsAccount);
        IPage pageList = this.roleService.page((IPage)page, (Wrapper)queryWrapper);
        ArrayList recordList = SysUtil.copyProperties((List)pageList.getRecords(), RoleDTO.class);
        return new SrmPageDTO(pageList.getTotal(), (List)recordList);
    }

    public SrmPageDTO<RoleDTO> getRolePageByName(int pageSize, int currentPage, String elsAccount, String roleName) {
        Page page = new Page((long)currentPage, (long)pageSize);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ParentEntity::getElsAccount, (Object)elsAccount);
        if (StrUtil.isNotBlank((CharSequence)roleName)) {
            wrapper.like(Role::getRoleName, (Object)roleName);
        }
        IPage rolePage = this.roleService.page((IPage)page, (Wrapper)wrapper);
        ArrayList recordList = SysUtil.copyProperties((List)rolePage.getRecords(), RoleDTO.class);
        return new SrmPageDTO(rolePage.getTotal(), rolePage.getPages(), (List)recordList);
    }

    public RoleDTO getRoleByElsAccountAndSysCode(String elsAccount, String code) {
        return (RoleDTO)SysUtil.copyProperties((Object)((Object)this.roleService.getRoleByElsAccountAndSysCode(elsAccount, code)), RoleDTO.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean createUserIfNotExist(ElsSubAccountDTO account) {
        String tenant = TenantContext.getTenant();
        try {
            TenantContext.setTenant((String)account.getElsAccount());
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.select(new SFunction[]{ParentEntity::getId});
            ((LambdaQueryWrapper)wrapper.eq(ParentEntity::getElsAccount, (Object)account.getElsAccount())).eq(ElsSubAccount::getSubAccount, (Object)account.getSubAccount());
            ElsSubAccount elsSubAccount = (ElsSubAccount)((Object)this.elsSubAccountService.getOne((Wrapper)wrapper));
            if (null != elsSubAccount) {
                account.setId(elsSubAccount.getId());
                Boolean bl = true;
                return bl;
            }
            this.elsSubAccountService.save((Object)((ElsSubAccount)((Object)SysUtil.copyProperties((Object)account, ElsSubAccount.class))));
            Boolean bl = false;
            return bl;
        }
        finally {
            if (StrUtil.isNotBlank((CharSequence)tenant)) {
                TenantContext.setTenant((String)tenant);
            } else {
                TenantContext.clear();
            }
        }
    }

    public void saveUserRole(String accountId, String roleId) {
        this.userRoleService.save(new UserRole(accountId, roleId));
    }

    public List<String> getAccountIdByRoleIdList(List<String> roleIds) {
        if (CollectionUtil.isEmpty(roleIds)) {
            return new ArrayList<String>();
        }
        return ((LambdaQueryChainWrapper)this.userRoleService.lambdaQuery().in(UserRole::getRoleId, roleIds)).list().stream().map(UserRole::getUserId).distinct().toList();
    }

    public List<RoleDTO> getRoleIdByAccountId(String accountId) {
        List roleAccountList = ((LambdaQueryChainWrapper)this.userRoleService.lambdaQuery().eq(UserRole::getUserId, (Object)accountId)).list();
        if (CollectionUtil.isEmpty((Collection)roleAccountList)) {
            return new ArrayList<RoleDTO>();
        }
        List roleId = roleAccountList.stream().map(UserRole::getRoleId).collect(Collectors.toList());
        List list = ((LambdaQueryChainWrapper)this.roleService.lambdaQuery().in(ParentEntity::getId, roleId)).list();
        return SrmUtil.copyProperties((List)list, RoleDTO.class);
    }

    public RoleDTO getRoleByRoleCode(String roleCode) {
        List roles = ((LambdaQueryChainWrapper)this.roleService.lambdaQuery().eq(Role::getRoleCode, (Object)roleCode)).list();
        if (CollectionUtil.isEmpty((Collection)roles)) {
            return null;
        }
        return (RoleDTO)SrmUtil.copyProperties(roles.get(0), RoleDTO.class);
    }
}

