/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.FieldDescribe;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.enumerate.ElsBarcodeBusinessEnum;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.barcode.api.ElsTableRpcService;
import com.els.modules.barcode.entity.ElsBarcodeAttribute;
import com.els.modules.barcode.enumerate.SrmEnabledStatusEnum;
import com.els.modules.barcode.rpc.service.ElsTableSelectService;
import com.els.modules.barcode.service.ElsBarcodeAttributeService;
import com.els.modules.barcode.vo.ElsBarcodeAttributeVO;
import com.els.modules.barcode.vo.ElsBarcodeFiledVO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u6761\u7801\u5c5e\u6027\u914d\u7f6e")
@RestController
@RequestMapping(value={"/base/barcode/elsBarcodeAttribute"})
public class ElsBarcodeAttributeController
extends BaseController<ElsBarcodeAttribute, ElsBarcodeAttributeService> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElsBarcodeAttributeController.class);
    @Autowired
    private ElsBarcodeAttributeService elsBarcodeAttributeService;
    @Autowired
    private ElsTableSelectService elsTableSelectService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @RequiresPermissions(value={"barcode#attribute:list"})
    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="barcodeInfoAttribute")
    public Result<?> queryPageList(ElsBarcodeAttribute elsBarcodeAttribute, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsBarcodeAttribute), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.elsBarcodeAttributeService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @RequiresPermissions(value={"barcode#attribute:list"})
    @Operation(summary="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", description="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/count"})
    @PermissionDataView(businessType="barcodeInfoAttribute")
    public Result<?> queryTabsCount(ElsBarcodeAttribute elsBarcodeAttribute, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select((Object[])new String[]{"attribute_status", "count(0) as participate_quantity"});
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.groupBy((Object)"attribute_status");
        List list = ((ElsBarcodeAttributeService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(ElsBarcodeAttribute::getAttributeStatus, ElsBarcodeAttribute::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "attributeStatus", null, (long)all.intValue()));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("sampleCheckProjectStatus", TenantContext.getTenant());
        for (DictDTO status : srmContractStatus) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "attributeStatus", status.getValue(), (long)total.intValue()));
        }
        return Result.ok(result);
    }

    @RequiresPermissions(value={"barcode#attribute:list"})
    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2(\u542f\u52a8)", description="\u5206\u9875\u5217\u8868\u67e5\u8be2(\u542f\u52a8)")
    @GetMapping(value={"/enableList"})
    public Result<?> queryPageEnableList(ElsBarcodeAttribute elsBarcodeAttribute, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsBarcodeAttribute), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"attribute_status", (Object)SrmEnabledStatusEnum.ENABLED.getValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsBarcodeAttributeService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @RequiresPermissions(value={"barcode#attribute:changeStatus"})
    @AutoLog(value="\u72b6\u6001\u53d8\u66f4")
    @Operation(summary="\u72b6\u6001\u53d8\u66f4", description="\u72b6\u6001\u53d8\u66f4")
    @PostMapping(value={"/changeStatus"})
    public Result<?> changeStatus(@RequestBody ElsBarcodeAttributeVO elsBarcodeAttributeVO) {
        if ("1".equals(elsBarcodeAttributeVO.getStatusType())) {
            elsBarcodeAttributeVO.setAttributeStatus(SrmEnabledStatusEnum.ENABLED.getValue());
        } else if ("2".equals(elsBarcodeAttributeVO.getStatusType())) {
            elsBarcodeAttributeVO.setAttributeStatus(SrmEnabledStatusEnum.DISABLED.getValue());
        }
        ElsBarcodeAttribute elsBarcodeAttribute = new ElsBarcodeAttribute();
        BeanUtils.copyProperties((Object)((Object)elsBarcodeAttributeVO), (Object)((Object)elsBarcodeAttribute));
        this.elsBarcodeAttributeService.updateById((Object)elsBarcodeAttribute);
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(value="\u6761\u7801\u5c5e\u6027\u914d\u7f6e-\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @PermissionDataOpt(businessType="barcodeInfoAttribute", beanClass=ElsBarcodeAttributeService.class)
    @RequiresPermissions(value={"barcode#attribute:add"})
    public Result<?> add(@RequestBody ElsBarcodeAttribute elsBarcodeAttribute) {
        this.elsBarcodeAttributeService.saveElsBarcodeAttribute(elsBarcodeAttribute);
        return Result.ok((Object)((Object)elsBarcodeAttribute));
    }

    @SrmValidated
    @AutoLog(value="\u6761\u7801\u5c5e\u6027\u914d\u7f6e-\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @PermissionDataOpt(businessType="barcodeInfoAttribute", beanClass=ElsBarcodeAttributeService.class)
    @RequiresPermissions(value={"barcode#attribute:edit"})
    public Result<?> edit(@RequestBody ElsBarcodeAttribute elsBarcodeAttribute) {
        this.elsBarcodeAttributeService.updateElsBarcodeAttribute(elsBarcodeAttribute);
        String id = elsBarcodeAttribute.getId();
        return this.queryById(id);
    }

    @AutoLog(value="\u6761\u7801\u5c5e\u6027\u914d\u7f6e-\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"barcode#attribute:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.elsBarcodeAttributeService.delElsBarcodeAttribute(id);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"barcode#attribute:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        ElsBarcodeAttribute elsBarcodeAttribute = (ElsBarcodeAttribute)((Object)this.elsBarcodeAttributeService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)elsBarcodeAttribute));
    }

    @RequiresPermissions(value={"barcode#attribute:queryById"})
    @Operation(summary="\u8868\u5b57\u6bb5\u5217\u8868\u67e5\u8be2", description="\u8868\u5b57\u6bb5\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryPageFieldList"})
    public Result<?> queryPageFieldList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        try {
            Field[] fields;
            String keyWord = req.getParameter("keyWord");
            String roleType = req.getParameter("roleType");
            ArrayList<ElsBarcodeFiledVO> filedList = new ArrayList<ElsBarcodeFiledVO>();
            String businessType = req.getParameter("businessType");
            String classPath = null;
            classPath = "sale".equals(roleType) ? (StrUtil.isBlank((CharSequence)ElsBarcodeBusinessEnum.getSalePathByValue((String)businessType)) ? ElsBarcodeBusinessEnum.getPathByValue((String)businessType) : ElsBarcodeBusinessEnum.getSalePathByValue((String)businessType)) : ElsBarcodeBusinessEnum.getPathByValue((String)businessType);
            if (StrUtil.isBlank((CharSequence)classPath)) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_APEStFmhxuERdW_59629763", (String)"\u5f53\u524d\u4e1a\u52a1\u5355\u636e\u67e5\u8be2\u4e0d\u5230\u914d\u7f6e\u9879\uff01"));
            }
            Class<?> clazz = Class.forName(classPath);
            for (Field filed : fields = clazz.getDeclaredFields()) {
                boolean annotation;
                if (!filed.isAccessible()) {
                    filed.setAccessible(true);
                }
                if (!(annotation = filed.isAnnotationPresent(FieldDescribe.class))) continue;
                FieldDescribe methodAnno = filed.getAnnotation(FieldDescribe.class);
                ElsBarcodeFiledVO obj = new ElsBarcodeFiledVO();
                obj.setFiledName(methodAnno.name());
                obj.setFiled(filed.getName());
                obj.setFiledType(filed.getType().getName());
                if (StrUtil.isNotBlank((CharSequence)keyWord) && !methodAnno.name().contains(keyWord) && !filed.getName().contains(keyWord)) continue;
                filedList.add(obj);
            }
            Page filePage = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
            filePage.setRecords(filedList);
            filePage.setTotal((long)filedList.size());
            filePage.setSize((long)pageSize.intValue());
            filePage.setPages((long)pageNo.intValue());
            return Result.ok((Object)filePage);
        }
        catch (ClassNotFoundException e) {
            log.error("queryPageFieldList_failed:", (Throwable)e);
            return Result.ok(null);
        }
    }

    @RequiresPermissions(value={"barcode#attribute:queryById"})
    @Operation(summary="\u8868\u5b57\u6bb5\u503c\u5217\u8868\u67e5\u8be2", description="\u8868\u5b57\u6bb5\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryPageFieldValueList"})
    public Result<?> queryPageFieldValueList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        try {
            ArrayList filedList = new ArrayList();
            String businessType = req.getParameter("businessType");
            String documentType = req.getParameter("documentQueryType");
            String businessField = req.getParameter("businessField");
            if (StrUtil.isBlank((CharSequence)businessType)) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_EStFxOLV_fe2610d0", (String)"\u4e1a\u52a1\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (StrUtil.isBlank((CharSequence)businessField)) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_ESJOxOLV_1cf946d5", (String)"\u4e1a\u52a1\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            String serviceName = ElsBarcodeBusinessEnum.getPathByService((String)businessType);
            if (StrUtil.isBlank((CharSequence)serviceName)) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_APEStFmhxuERdW_59629763", (String)"\u5f53\u524d\u4e1a\u52a1\u5355\u636e\u67e5\u8be2\u4e0d\u5230\u914d\u7f6e\u9879\uff01"));
            }
            ElsTableRpcService elsTableRpcService = this.elsTableSelectService.getTableService(serviceName);
            IPage list = elsTableRpcService.selectListByBusinessType(businessType, businessField, pageNo, pageSize, documentType, req.getParameterMap());
            return Result.ok((Object)list);
        }
        catch (Exception e) {
            log.error("queryPageFieldValueList_failed:", (Throwable)e);
            return Result.ok(null);
        }
    }

    @RequiresPermissions(value={"barcode#attribute:queryById"})
    @Operation(summary="\u8868\u5b57\u6bb5\u503c\u5217\u8868\u67e5\u8be2", description="\u8868\u5b57\u6bb5\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/getPageFieldString"})
    public Result<?> getPageFieldString(HttpServletRequest req) {
        try {
            String businessType = req.getParameter("businessType");
            String documentType = req.getParameter("documentQueryType");
            String businessField = req.getParameter("businessField");
            if (StrUtil.isBlank((CharSequence)businessType)) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_EStFxOLV_fe2610d0", (String)"\u4e1a\u52a1\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (StrUtil.isBlank((CharSequence)businessField)) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_ESJOxOLV_1cf946d5", (String)"\u4e1a\u52a1\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            String serviceName = ElsBarcodeBusinessEnum.getPathByService((String)businessType);
            if (StrUtil.isBlank((CharSequence)serviceName)) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_APEStFmhxuERdW_59629763", (String)"\u5f53\u524d\u4e1a\u52a1\u5355\u636e\u67e5\u8be2\u4e0d\u5230\u914d\u7f6e\u9879\uff01"));
            }
            ElsTableRpcService elsTableRpcService = this.elsTableSelectService.getTableService(serviceName);
            IPage list = elsTableRpcService.selectListByBusinessType(businessType, businessField, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE), documentType, req.getParameterMap());
            String result = null;
            if (ObjectUtil.isNotEmpty((Object)list) && CollUtil.isNotEmpty((Collection)list.getRecords())) {
                result = list.getRecords().stream().map(x -> x.getFieldValue()).collect(Collectors.joining(","));
            }
            return Result.ok(result);
        }
        catch (Exception e) {
            log.error("queryPageFieldValueList_failed:", (Object)e.getMessage());
            return Result.ok(null);
        }
    }
}

