/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.justauth.extend;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.modules.account.entity.ExternalVoucherParam;
import com.els.modules.account.enums.ExternalVoucherTypeEnum;
import com.els.modules.account.mapper.ExternalVoucherParamMapper;
import com.els.modules.justauth.extend.ConfigExtendInter;
import com.els.modules.justauth.vo.ConfigExtendVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultConfigExtendImpl
implements ConfigExtendInter {
    @Autowired
    private ExternalVoucherParamMapper externalVoucherParamMapper;

    @Override
    public List<ConfigExtendVO> buildExtendParam(String authType, String authTypeKey) {
        if (CharSequenceUtil.isEmpty((CharSequence)authTypeKey)) {
            authTypeKey = authType;
        }
        return this.getExternalVoucherParam(authType, authTypeKey);
    }

    @Override
    public String buildExtendParamString(String authType, String authTypeKey) {
        List<ConfigExtendVO> vos = this.buildExtendParam(authType, authTypeKey);
        JSONObject object = new JSONObject();
        for (ConfigExtendVO vo : vos) {
            object.put((Object)vo.getParamName(), (Object)vo.getDefaultValue());
        }
        if (object.size() == 0) {
            return "";
        }
        return object.toJSONString(new JSONWriter.Feature[0]);
    }

    @Override
    public JSONObject parseExtendParam(String authType, String authTypeKey, String extendParam) {
        if (CharSequenceUtil.isEmpty((CharSequence)extendParam)) {
            return new JSONObject();
        }
        return JSONObject.parseObject((String)extendParam);
    }

    protected List<ConfigExtendVO> getExternalVoucherParam(String type, String typeKey) {
        ArrayList<ConfigExtendVO> list = new ArrayList<ConfigExtendVO>();
        if (ExternalVoucherTypeEnum.isBindLoginType(type)) {
            list.add(new ConfigExtendVO("configType", false, false, "dataConfig"));
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(ExternalVoucherParam::getVoucherType, (Object)type)).eq(ExternalVoucherParam::getVoucherKey, (Object)typeKey);
        List externalVoucherParams = this.externalVoucherParamMapper.selectList((Wrapper)wrapper);
        if (CollUtil.isEmpty((Collection)externalVoucherParams)) {
            return list;
        }
        for (ExternalVoucherParam p : externalVoucherParams) {
            ConfigExtendVO vo = new ConfigExtendVO();
            vo.setParamName(p.getParamName());
            vo.setConfigRequired("1".equals(p.getConfigRequired()));
            vo.setAuthRequired("1".equals(p.getAuthRequired()));
            vo.setDefaultValue(CharSequenceUtil.emptyToDefault((CharSequence)p.getParamDefaultValue(), (String)""));
            list.add(vo);
        }
        return list;
    }
}

