/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.todo.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.ConfigUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SrmUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.system.entity.Permission;
import com.els.modules.system.service.PermissionExtendService;
import com.els.modules.todo.entity.WorkstationConfig;
import com.els.modules.todo.entity.WorkstationConfigAccount;
import com.els.modules.todo.service.WorkstationConfigAccountService;
import com.els.modules.todo.service.WorkstationConfigService;
import com.els.modules.todo.vo.WorkstationConfigVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u5de5\u4f5c\u53f0\u914d\u7f6e")
@RestController
@RequestMapping(value={"/base/workstationConfig"})
public class WorkstationConfigController {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private PermissionExtendService permissionExtendService;
    @Autowired
    private WorkstationConfigAccountService workstationConfigAccountService;
    @Autowired
    private WorkstationConfigService workstationConfigService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"workstationConfig:list"})
    public Result<?> queryPageList(WorkstationConfig config, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)config), (Map)req.getParameterMap());
        queryWrapper.lambda().in(ParentEntity::getElsAccount, new Object[]{TenantContext.getTenant(), ConfigUtil.getPurchaseAccount()});
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.workstationConfigService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u4f01\u4e1a\u5de5\u4f5c\u53f0\u914d\u7f6e", value="\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"workstationConfig:add"})
    public Result<?> add(@RequestBody WorkstationConfig config) {
        this.workstationConfigService.add(config);
        return Result.ok((Object)((Object)config));
    }

    @AutoLog(busModule="\u4f01\u4e1a\u5de5\u4f5c\u53f0\u914d\u7f6e", value="\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"workstationConfig:edit"})
    public Result<?> edit(@RequestBody WorkstationConfig config) {
        this.workstationConfigService.edit(config);
        return this.queryById(config.getId());
    }

    @AutoLog(busModule="\u4f01\u4e1a\u5de5\u4f5c\u53f0\u914d\u7f6e", value="\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"workstationConfig:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.workstationConfigService.delete(id);
        return Result.ok();
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"workstationConfig:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        WorkstationConfig config = (WorkstationConfig)((Object)this.workstationConfigService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)config));
    }

    @Operation(summary="\u83b7\u53d6\u4e1a\u52a1\u4ee3\u529e\u914d\u7f6e", description="\u83b7\u53d6\u4e1a\u52a1\u4ee3\u529e\u914d\u7f6e")
    @GetMapping(value={"/getBusinessToDoConfig"})
    public Result<?> getBusinessToDoConfig() {
        LoginUserDTO loginUser = SrmUtil.getLoginUser();
        String redisKey = "sys:workstation:menu:" + loginUser.getElsAccount() + ":" + loginUser.getSubAccount();
        List<Permission> permissionList = (List<Permission>)this.redisUtil.get(redisKey);
        String accountId = loginUser.getId();
        if (CollectionUtil.isEmpty((Collection)permissionList)) {
            permissionList = this.permissionExtendService.getByAccountId(TenantContext.getTenant(), accountId);
            this.redisUtil.set(redisKey, permissionList);
        }
        List<String> menuIdList = permissionList.stream().filter(resource -> resource.getMenuType() != null && resource.getMenuType() == 1).map(ParentEntity::getId).toList();
        List userConfigList = this.workstationConfigAccountService.list((Wrapper)new LambdaQueryWrapper().eq(WorkstationConfigAccount::getAccountId, (Object)accountId));
        Map workstationIdMap = userConfigList.stream().collect(Collectors.toMap(WorkstationConfigAccount::getWorkstationId, Function.identity()));
        List enterpriseConfigList = this.workstationConfigService.list((Wrapper)new LambdaQueryWrapper().in(WorkstationConfig::getMenuId, menuIdList));
        ArrayList<WorkstationConfigVO> configList = new ArrayList<WorkstationConfigVO>();
        for (WorkstationConfig enterpriseConfig : enterpriseConfigList) {
            WorkstationConfigVO config = new WorkstationConfigVO();
            BeanUtils.copyProperties((Object)((Object)enterpriseConfig), (Object)((Object)config));
            String workstationId = enterpriseConfig.getId();
            if (workstationIdMap.isEmpty()) {
                config.setSelected("1");
            } else {
                config.setSelected(workstationIdMap.containsKey(workstationId) ? "1" : "0");
            }
            config.setSortNo(workstationIdMap.containsKey(workstationId) ? ((WorkstationConfigAccount)((Object)workstationIdMap.get(workstationId))).getSortNo() : enterpriseConfig.getSortNo().add(new BigDecimal("999")));
            configList.add(config);
        }
        configList.sort(Comparator.nullsLast(Comparator.comparing(WorkstationConfig::getSortNo)));
        return Result.ok(configList);
    }

    @AutoLog(busModule="\u7528\u6237\u5de5\u4f5c\u53f0\u914d\u7f6e", value="\u4fdd\u5b58")
    @Operation(summary="\u7528\u6237\u5de5\u4f5c\u53f0\u914d\u7f6e\u4fdd\u5b58", description="\u7528\u6237\u5de5\u4f5c\u53f0\u914d\u7f6e\u4fdd\u5b58")
    @PostMapping(value={"/save"})
    @RequiresPermissions(value={"userWorkstationConfig:save"})
    public Result<?> save(@RequestBody List<WorkstationConfigVO> configList) {
        this.workstationConfigAccountService.save(configList);
        return Result.ok();
    }
}

