/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.email.core;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.extra.mail.MailAccount;
import cn.hutool.setting.GroupedMap;
import cn.hutool.setting.Setting;
import com.els.common.exception.ELSBootException;
import com.els.common.trace.TraceIdHolder;
import com.els.common.util.ConfigUtil;
import com.els.common.util.LoginUserContext;
import com.els.common.util.SpringContextUtils;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.email.api.dto.EmailConfigDTO;
import com.els.modules.email.api.dto.EmailSendLogDTO;
import com.els.modules.email.api.dto.EmailSendResultDto;
import com.els.modules.email.core.SrmEmailSetting;
import com.els.modules.email.core.sender.SrmEmailSender;
import com.els.modules.email.service.EmailConfigService;
import com.els.modules.email.service.EmailSendLogService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import lombok.Generated;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmEmailBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SrmEmailBuilder.class);
    public static final String QUEUE = "srm:base:email:send:queue";

    public static EmailSendResultDto sendEmailImmediately(String elsAccount, String[] to, String subject, String content, String cc, Map<String, String> attachmentPathMap, List<String> attachmentIdMap, EmailSendLogDTO sendLogDTO) {
        Map<String, List<EmailConfigDTO>> emailConfigMap = ((EmailConfigService)SpringContextUtils.getBean(EmailConfigService.class)).mapEmailConfigs(elsAccount);
        if (CollectionUtil.isEmpty(emailConfigMap)) {
            throw new ELSBootException("\u8bf7\u5148\u914d\u7f6eEmail\u914d\u7f6e");
        }
        List<EmailConfigDTO> configList = emailConfigMap.remove(elsAccount);
        if (CollectionUtil.isEmpty(configList) && !"100000".equalsIgnoreCase(ConfigUtil.getPurchaseAccount())) {
            configList = emailConfigMap.remove(ConfigUtil.getPurchaseAccount());
        }
        if (CollectionUtil.isEmpty(configList)) {
            configList = emailConfigMap.remove("100000");
        }
        int size = configList.size();
        ArrayList<String> ignoreIds = new ArrayList<String>();
        EmailSendResultDto resultDto = null;
        while (ignoreIds.size() < size) {
            EmailConfigDTO config = SrmEmailBuilder.selectConfig(configList, ignoreIds);
            if (null == config && emailConfigMap.containsKey(ConfigUtil.getPurchaseAccount())) {
                ignoreIds.clear();
                configList = emailConfigMap.remove(ConfigUtil.getPurchaseAccount());
                if (CollectionUtil.isNotEmpty(configList)) {
                    size = configList.size();
                    config = SrmEmailBuilder.selectConfig(configList, ignoreIds);
                }
            }
            if (null == config && emailConfigMap.containsKey("100000")) {
                ignoreIds.clear();
                configList = emailConfigMap.remove("100000");
                if (CollectionUtil.isNotEmpty(configList)) {
                    size = configList.size();
                    config = SrmEmailBuilder.selectConfig(configList, ignoreIds);
                }
            }
            if (null == config) break;
            ignoreIds.add(config.getId());
            if (ignoreIds.size() == size) {
                config.setPersistenceWhileFailed(true);
            }
            try {
                resultDto = SrmEmailBuilder.sendEmailImmediately(config, to, subject, content, cc, attachmentPathMap, attachmentIdMap, null, sendLogDTO);
                if (!resultDto.isResult()) continue;
                break;
            }
            catch (Exception e) {
                if (ignoreIds.size() != size) continue;
                throw e;
            }
        }
        return resultDto;
    }

    public static EmailSendResultDto sendEmailImmediately(EmailConfigDTO config, String[] to, String subject, String content, String cc, Map<String, String> attachmentPathMap, List<String> attachmentIdMap, File[] attachmentFiles, EmailSendLogDTO sendLogDTO) {
        config.setEmailContent(content);
        config.setEmailCc(cc);
        config.setEmailSubject(subject);
        config.setEmailTo(to);
        config.setAttachmentFiles(attachmentFiles);
        Map<String, String> fileMap = SrmEmailBuilder.buildSrmAttachmentMap(attachmentIdMap);
        if (null == attachmentPathMap) {
            attachmentPathMap = new HashMap<String, String>();
        }
        if (null != fileMap) {
            attachmentPathMap.putAll(fileMap);
        }
        config.setAttachmentPathList(attachmentPathMap);
        LoginUserDTO loginUser = LoginUserContext.getUser();
        if (null != loginUser && CharSequenceUtil.isEmpty((CharSequence)config.getCurrentElsAccount())) {
            config.setCurrentElsAccount(loginUser.getElsAccount());
        }
        if (null != sendLogDTO) {
            config.setSendLogId(sendLogDTO.getId());
            config.setCurrentElsAccount(CharSequenceUtil.emptyToDefault((CharSequence)config.getCurrentElsAccount(), (String)sendLogDTO.getElsAccount()));
        }
        config.setPersistenceWhileFailed(true);
        SrmEmailSender mailSender = SrmEmailBuilder.buildEmailSender(config);
        return mailSender.sendEmail(config);
    }

    public static void sendEmailToQueue(String elsAccount, String[] to, String subject, String content, String cc, Map<String, String> attachmentPathMap, List<String> attachmentIdMap) {
        EmailConfigDTO config = ((EmailConfigService)SpringContextUtils.getBean(EmailConfigService.class)).getEmailConfig(elsAccount);
        if (null == config) {
            throw new ELSBootException("\u8bf7\u5148\u914d\u7f6eEmail\u914d\u7f6e");
        }
        config.setAttachmentFiles(null);
        SrmEmailBuilder.sendEmailToQueue(config, to, subject, content, cc, attachmentPathMap, attachmentIdMap);
    }

    public static void sendEmailToQueue(EmailConfigDTO config, String[] to, String subject, String content, String cc, Map<String, String> attachmentPathMap, List<String> attachmentIdMap) {
        try {
            config.setEmailContent(content);
            config.setEmailCc(cc);
            config.setEmailSubject(subject);
            config.setEmailTo(to);
            Map<String, String> fileMap = SrmEmailBuilder.buildSrmAttachmentMap(attachmentIdMap);
            if (null == attachmentPathMap) {
                attachmentPathMap = new HashMap<String, String>();
            }
            if (null != fileMap) {
                attachmentPathMap.putAll(fileMap);
            }
            config.setAttachmentPathList(attachmentPathMap);
            LoginUserDTO loginUser = LoginUserContext.getUser();
            if (null != loginUser && CharSequenceUtil.isEmpty((CharSequence)config.getCurrentElsAccount())) {
                config.setCurrentElsAccount(loginUser.getElsAccount());
            }
            config.setLoginUserDTO(loginUser);
            config.setTraceId(TraceIdHolder.get());
            config.setEmailSendStatus("0");
            EmailConfigDTO dbConfig = ((EmailSendLogService)SpringContextUtils.getBean(EmailSendLogService.class)).saveOrUpdateEmailSendRecord(config);
            config.setSendLogId(dbConfig.getId());
            RedissonClient redissonClient = (RedissonClient)SpringContextUtils.getBean(RedissonClient.class);
            RBlockingQueue queue = redissonClient.getBlockingQueue(QUEUE);
            config.setSaveCheckDataToLog(true);
            queue.add((Object)config);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u90ae\u4ef6\u5230redis\u961f\u5217\u5f02\u5e38:{}", (Object)e.getMessage());
            throw e;
        }
    }

    public static void sendEmailEpImmediately(String elsAccount, String[] to, String subject, String content, String cc, Map<String, String> attachmentPathMap, List<String> attachmentIdMap, EmailSendLogDTO sendLogDto) {
        Map<String, List<EmailConfigDTO>> emailConfigMap = ((EmailConfigService)SpringContextUtils.getBean(EmailConfigService.class)).mapEmailConfigs(elsAccount);
        if (CollectionUtil.isEmpty(emailConfigMap)) {
            throw new ELSBootException("\u8bf7\u5148\u914d\u7f6eEmail\u914d\u7f6e");
        }
        List<EmailConfigDTO> configList = emailConfigMap.remove(elsAccount);
        if (CollectionUtil.isEmpty(configList) && !"100000".equalsIgnoreCase(ConfigUtil.getPurchaseAccount())) {
            configList = emailConfigMap.remove(ConfigUtil.getPurchaseAccount());
        }
        if (CollectionUtil.isEmpty(configList)) {
            configList = emailConfigMap.remove("100000");
        }
        int size = configList.size();
        ArrayList<String> ignoreIds = new ArrayList<String>();
        while (ignoreIds.size() < size) {
            EmailConfigDTO config = SrmEmailBuilder.selectConfig(configList, ignoreIds);
            if (null == config && emailConfigMap.containsKey(ConfigUtil.getPurchaseAccount())) {
                ignoreIds.clear();
                configList = emailConfigMap.remove(ConfigUtil.getPurchaseAccount());
                if (CollectionUtil.isNotEmpty(configList)) {
                    size = configList.size();
                    config = SrmEmailBuilder.selectConfig(configList, ignoreIds);
                }
            }
            if (null == config && emailConfigMap.containsKey("100000")) {
                ignoreIds.clear();
                configList = emailConfigMap.remove("100000");
                if (CollectionUtil.isNotEmpty(configList)) {
                    size = configList.size();
                    config = SrmEmailBuilder.selectConfig(configList, ignoreIds);
                }
            }
            if (null == config) break;
            ignoreIds.add(config.getId());
            config.setPersistenceWhileFailed(false);
            if (ignoreIds.size() == size) {
                config.setPersistenceWhileFailed(true);
            }
            try {
                SrmEmailBuilder.sendEmailEpImmediately(config, to, subject, content, cc, attachmentPathMap, attachmentIdMap, null, sendLogDto);
                break;
            }
            catch (Exception e) {
                if (ignoreIds.size() != size) continue;
                throw e;
            }
        }
    }

    public static void sendEmailEpImmediately(EmailConfigDTO config, String[] to, String subject, String content, String cc, Map<String, String> attachmentPathMap, List<String> attachmentIdMap, File[] attachmentFiles, EmailSendLogDTO sendLogDto) {
        config.setEmailContent(content);
        config.setEmailCc(cc);
        config.setEmailSubject(subject);
        config.setEmailTo(to);
        config.setAttachmentFiles(attachmentFiles);
        Map<String, String> fileMap = SrmEmailBuilder.buildSrmAttachmentMap(attachmentIdMap);
        if (null == attachmentPathMap) {
            attachmentPathMap = new HashMap<String, String>();
        }
        if (null != fileMap) {
            attachmentPathMap.putAll(fileMap);
        }
        config.setAttachmentPathList(attachmentPathMap);
        LoginUserDTO loginUser = LoginUserContext.getUser();
        if (null != loginUser && CharSequenceUtil.isEmpty((CharSequence)config.getCurrentElsAccount())) {
            config.setCurrentElsAccount(loginUser.getElsAccount());
        }
        if (null != sendLogDto) {
            config.setSendLogId(sendLogDto.getId());
            config.setCurrentElsAccount(CharSequenceUtil.emptyToDefault((CharSequence)config.getCurrentElsAccount(), (String)sendLogDto.getElsAccount()));
        }
        SrmEmailSender mailSender = SrmEmailBuilder.buildEmailSender(config);
        mailSender.sendEmailEp(config);
    }

    public static SrmEmailSender buildEmailSender(EmailConfigDTO config) {
        Map emailSenderMap = SpringContextUtils.getApplicationContext().getBeansOfType(SrmEmailSender.class);
        List enableSenderList = emailSenderMap.values().stream().filter(x -> null != x.getSupportProtocol() && (x.getSupportProtocol().size() == 0 || x.getSupportProtocol().stream().filter(j -> j.getProtocol().contains(config.getEmailProtocol())).toList().size() > 0)).sorted(Comparator.comparing(SrmEmailSender::order)).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(enableSenderList)) {
            throw new ELSBootException("\u4e0d\u652f\u6301\u5f53\u524d\u7684\u90ae\u4ef6\u534f\u8bae");
        }
        return (SrmEmailSender)enableSenderList.get(0);
    }

    public static MailAccount buildMailAccountByConfig(String configString) {
        SrmEmailSetting srmEmailSetting = new SrmEmailSetting(configString);
        GroupedMap srmGroupedMap = srmEmailSetting.getSrmGroupedMap();
        srmGroupedMap.forEach((k, v) -> srmEmailSetting.putAll((Map)v));
        return new MailAccount((Setting)srmEmailSetting);
    }

    public static Map<String, String> buildSrmAttachmentMap(List<String> attachmentIdMap) {
        if (CollectionUtil.isEmpty(attachmentIdMap)) {
            return null;
        }
        return null;
    }

    public static EmailConfigDTO selectConfig(List<EmailConfigDTO> elsEmailConfig, List<String> ignoreIds) {
        List<EmailConfigDTO> filterConfigList = elsEmailConfig.stream().filter(x -> CollectionUtil.isEmpty((Collection)ignoreIds) || !ignoreIds.contains(x.getId())).toList();
        if (filterConfigList.isEmpty()) {
            return null;
        }
        int totalWeight = filterConfigList.stream().mapToInt(EmailConfigDTO::getEmailWeight).sum();
        int randomIndex = -1;
        double randomValue = new Random().nextDouble() * (double)totalWeight;
        for (int i = 0; i < filterConfigList.size(); ++i) {
            if (!((randomValue -= (double)filterConfigList.get(i).getEmailWeight().intValue()) <= 0.0)) continue;
            randomIndex = i;
            break;
        }
        if (randomIndex != -1) {
            return filterConfigList.get(randomIndex);
        }
        return filterConfigList.get(0);
    }
}

