/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.email.core.retry;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.json.JSONUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.LoginUserContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.email.api.dto.EmailConfigDTO;
import com.els.modules.email.api.dto.EmailSendLogDTO;
import com.els.modules.email.core.SrmEmailBuilder;
import com.els.modules.email.core.retry.EmailRetryService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EmailRetryServiceImpl
implements EmailRetryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmailRetryServiceImpl.class);

    @Override
    public void retrySendEmail(EmailSendLogDTO sendLogDto) {
        String msgConfigContent = sendLogDto.getMsgConfigContent();
        if (CharSequenceUtil.isEmpty((CharSequence)msgConfigContent)) {
            throw new ELSBootException(I18nUtil.translate((String)"\u90ae\u4ef6\u53d1\u9001\u8bb0\u5f55\u4fe1\u606f\u6709\u8bef\uff0c\u65e0\u6cd5\u91cd\u8bd5"));
        }
        EmailConfigDTO config = (EmailConfigDTO)JSONUtil.toBean((String)msgConfigContent, EmailConfigDTO.class);
        config.setSendLogId(sendLogDto.getId());
        LoginUserDTO loginUser = LoginUserContext.getUser();
        if (null != loginUser && CharSequenceUtil.isEmpty((CharSequence)config.getCurrentElsAccount())) {
            config.setCurrentElsAccount(loginUser.getElsAccount());
        }
        SrmEmailBuilder.sendEmailEpImmediately(sendLogDto.getElsAccount(), config.getEmailTo(), sendLogDto.getEmailSubject(), sendLogDto.getEmailContent(), sendLogDto.getEmailCc(), config.getAttachmentPathList(), null, sendLogDto);
    }
}

