/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.els.common.util.SpringContextUtils;
import com.els.modules.account.entity.ExternalAccount;
import com.els.modules.account.service.ExternalAccountService;
import com.els.modules.integration.api.dto.ExternalVoucherDto;
import com.els.modules.justauth.util.ThirdAuthUtil;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.enums.SendMsgTypeEnum;
import com.els.modules.message.handle.impl.AbstractSendMsgImpl;
import com.els.modules.message.vo.MsgVO;
import com.els.modules.system.entity.ElsSubAccount;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WxSendMsgImpl
extends AbstractSendMsgImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WxSendMsgImpl.class);

    @Override
    public void doSendMsg(MsgVO msg) {
        ElsMsgConfigItem configItem = msg.getConfigItem();
        if (null == configItem) {
            log.warn("WxSendMsgImpl\u51c6\u5907\u6267\u884c\u53d1\u9001\u5fae\u4fe1\u6d88\u606f\u7684\u903b\u8f91");
            return;
        }
        ElsSubAccount receiveAccountInfo = msg.getReceiveAccountInfo();
        ExternalAccountService externalAccountService = (ExternalAccountService)SpringContextUtils.getBean(ExternalAccountService.class);
        ExternalAccount externalAccount = externalAccountService.getEnableAccount(receiveAccountInfo.getElsAccount(), receiveAccountInfo.getId());
        if (null == externalAccount) {
            log.warn("WxSendMsgImpl receive not bind WECHAT_MP");
            return;
        }
        if (StrUtil.isBlank((CharSequence)configItem.getTemplateNumber())) {
            log.error(":::elsAccount:{}\u53d1\u9001\u516c\u4f17\u53f7\u6d88\u606f\u914d\u7f6e\u6ca1\u6709\u914d\u7f6e\u6a21\u677f\u53f7...", (Object)msg.getBusAccount());
            return;
        }
        ExternalVoucherDto config = this.getJustConfig(receiveAccountInfo.getElsAccount(), "wechat_mp");
        if (null == config || StrUtil.isEmpty((CharSequence)config.getVoucherKey())) {
            log.error(":::\u516c\u4f17\u53f7\u914d\u7f6e\u4e0d\u5b58\u5728,elsAccount:{}", (Object)receiveAccountInfo.getElsAccount());
            return;
        }
        this.send(msg, configItem, config, externalAccount.getExternalAccountId());
    }

    @Override
    protected String getOauthUrl() {
        return "/els/base/thirdLogin/loadQrCode/%s/mobile/wechat_mp";
    }

    protected void send(MsgVO msg, ElsMsgConfigItem configItem, ExternalVoucherDto config, String openId) {
        String urlString = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + ThirdAuthUtil.getWechatMpToken(config.getElsAccount(), config);
        JSONObject body = new JSONObject();
        body.put((Object)"template_id", (Object)configItem.getTemplateNumber());
        String linkUrl = this.buildLinkUrl(msg.getBusinessObj(), configItem.getLinkUrl(), "", msg.getBusAccount(), msg.getReceiveAccountInfo());
        body.put((Object)"url", (Object)linkUrl);
        String msgContent = this.parseContentTemplateText("", configItem.getMsgContent(), (Map<String, Object>)msg.getBusinessObj());
        body.put((Object)"data", (Object)JSONObject.parse((String)msgContent, (JSONReader.Feature[])new JSONReader.Feature[0]));
        body.put((Object)"touser", (Object)openId);
        String result = HttpUtil.post((String)urlString, (String)body.toString());
        try {
            String errmsg;
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (jsonObject.containsKey("errmsg") && CharSequenceUtil.isNotEmpty((CharSequence)(errmsg = jsonObject.getString("errmsg"))) && errmsg.contains("invalid credential")) {
                ThirdAuthUtil.cleanThirdToken("wechat_mp", config.getElsAccount());
                urlString = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + ThirdAuthUtil.getWechatMpToken(config.getElsAccount(), config);
                result = HttpUtil.post((String)urlString, (String)body.toString());
                log.error(":::WxGroupSendMsgImpl reSend message result:{}", (Object)result);
            }
        }
        catch (Exception e) {
            log.error("WxGroupSendMsgImpl.doSendMsg.reSend \u5fae\u4fe1\u53d1\u9001\u6d88\u606f\u5f02\u5e38:", (Throwable)e);
        }
    }

    @Override
    public String supportType() {
        return SendMsgTypeEnum.WE_CHAT.getType();
    }

    public static void main(String[] args) {
        String token = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=46_cdvi4kKxG51o5_ao4LYEVUKSrVEJ2tKBwrgKE688wb6NOaXJuSyH4AJzZmdAHZ_CepbFFpP6AjmiPXQBDMuh50-zESXmm5E28EcH5q5_YJJwXXFyuUuCs-7sjmW5Ydt9BBB_1U2Ztcd4CCgkIOTfABACIN";
        String body = "{\r\n           \"touser\":\"oCQZC6GSLuribL-Ez_WK_Qz4o4XU\",\r\n           \"template_id\":\"TrCHKlWNdYk8_4v-T1ovVbi1t4IOC9guBrj84diJpyo\",\r\n           \"url\":\"http://v5sit.51qqt.com/user/login\",           \r\n           \"data\":{\r\n           \t\"number\": {\r\n                       \"value\":\"aaa\",\r\n                       \"color\":\"#173177\"\r\n                   }\r\n           }\r\n}";
        HttpUtil.post((String)token, (String)body);
    }
}

