/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.message.api.dto.MsgConfigItemDTO;
import com.els.modules.system.entity.ElsAlertConfig;
import com.els.modules.system.rpc.service.JobInvokeBaseRpcService;
import com.els.modules.system.rpc.service.JobInvokeMessageRpcService;
import com.els.modules.system.service.ElsAlertConfigService;
import com.els.modules.system.vo.ElsAlertConfigVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u9884\u8b66")
@RestController
@RequestMapping(value={"/job/elsAlertConfig"})
public class ElsAlertConfigController
extends BaseController<ElsAlertConfig, ElsAlertConfigService> {
    @Autowired
    private ElsAlertConfigService elsAlertConfigService;
    @Resource
    private JobInvokeMessageRpcService msgConfigRpcService;
    @Resource
    private JobInvokeBaseRpcService baseRpcService;
    private static final String ALERT_NUMBER = "alertNumber";

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"alert#elsAlertConfig:list"})
    public Result<?> queryPageList(ElsAlertConfig elsAlertConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsAlertConfig), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsAlertConfigService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/sysList"})
    @RequiresPermissions(value={"alert#elsAlertConfig:sysList"})
    public Result<?> querySysPageList(ElsAlertConfig elsAlertConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsAlertConfig), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsAlertConfigService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u9884\u8b66\u7ba1\u7406-\u6dfb\u52a0", logType=2, operateType=2)
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"alert#elsAlertConfig:add"})
    public Result<?> add(@RequestBody ElsAlertConfigVO configVO) {
        ElsAlertConfig elsAlertConfig = new ElsAlertConfig();
        BeanUtil.copyProperties((Object)((Object)configVO), (Object)((Object)elsAlertConfig), (String[])new String[0]);
        elsAlertConfig.setAlertCode(this.baseRpcService.getNextCode(ALERT_NUMBER, (Object)elsAlertConfig));
        this.elsAlertConfigService.saveElsAlertConfig(elsAlertConfig, configVO.getElsMsgConfigItemList());
        return Result.ok((Object)((Object)elsAlertConfig));
    }

    @AutoLog(value="\u9884\u8b66\u7ba1\u7406-\u9009\u62e9100000\u6570\u636e\u6dfb\u52a0\u81f3\u4f01\u4e1a\u7ea7", logType=2, operateType=2)
    @Operation(summary="\u9009\u62e9100000\u6570\u636e\u6dfb\u52a0\u81f3\u4f01\u4e1a\u7ea7", description="\u9009\u62e9100000\u6570\u636e\u6dfb\u52a0\u81f3\u4f01\u4e1a\u7ea7")
    @GetMapping(value={"/addBy100000"})
    @RequiresPermissions(value={"alert#elsAlertConfig:add"})
    public Result<?> addBy100000(@RequestParam(name="id", required=true) String id) {
        this.elsAlertConfigService.addBy100000(id);
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(value="\u9884\u8b66\u7ba1\u7406-\u7f16\u8f91", logType=2, operateType=3)
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"alert#elsAlertConfig:edit"})
    public Result<?> edit(@RequestBody ElsAlertConfigVO configVO) {
        ElsAlertConfig elsAlertConfig = new ElsAlertConfig();
        BeanUtil.copyProperties((Object)((Object)configVO), (Object)((Object)elsAlertConfig), (String[])new String[0]);
        this.elsAlertConfigService.updateElsAlertConfig(elsAlertConfig, configVO.getElsMsgConfigItemList());
        String id = elsAlertConfig.getId();
        return this.queryById(id);
    }

    @AutoLog(value="\u9884\u8b66\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664", logType=2, operateType=4)
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"alert#elsAlertConfig:delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.elsAlertConfigService.delElsAlertConfig(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u9884\u8b66\u7ba1\u7406-\u6279\u91cf\u5220\u9664", logType=2, operateType=4)
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"alert#elsAlertConfig:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.elsAlertConfigService.delBatchElsAlertConfig(idList);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"alert#elsAlertConfig:view"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        ElsAlertConfig elsAlertConfig = (ElsAlertConfig)((Object)this.elsAlertConfigService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        List<MsgConfigItemDTO> itemList = this.msgConfigRpcService.findListByMainId(id);
        ElsAlertConfigVO configVO = new ElsAlertConfigVO();
        BeanUtil.copyProperties((Object)((Object)elsAlertConfig), (Object)((Object)configVO), (String[])new String[0]);
        configVO.setElsMsgConfigItemList(itemList);
        return Result.ok((Object)((Object)configVO));
    }
}

