/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.auth.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.exception.ELSBootException;
import com.els.common.util.ConfigUtil;
import com.els.common.util.EmailUtil;
import com.els.common.util.FreeMarkerTemplateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.sms.SmsResult;
import com.els.common.util.sms.SmsUtil;
import com.els.modules.auth.service.ForgetPasswordService;
import com.els.modules.auth.vo.AccountInfoVO;
import com.els.modules.auth.vo.CheckAuthCodeResultVO;
import com.els.modules.auth.vo.CheckAuthCodeVO;
import com.els.modules.auth.vo.SendAuthCodeVO;
import com.els.modules.auth.vo.UpdatePasswordVO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.vo.ChangePasswordParamVO;
import freemarker.template.Template;
import jakarta.annotation.Resource;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service
public class ForgetPasswordServiceImpl
implements ForgetPasswordService {
    private static final String ACCOUNT_AUTH_CODE_REDIS_KEY = "srm:base:auth:authCode:";
    private static final String ACCOUNT_AUTH_ERROR_COUNT_REDIS_KEY = "srm:base:auth:errorCount:";
    private static final String TEMP_TOKEN = "srm:base:auth:tempToken:";
    @Resource
    private ElsSubAccountService subAccountService;
    @Resource
    private RedisUtil redisUtil;

    private ElsSubAccount checkAccount(String elsAccount, String subAccount) {
        ElsSubAccount accountInfo = this.subAccountService.getByAccount(elsAccount, subAccount);
        if (accountInfo == null) {
            throw new ELSBootException("\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        if (accountInfo.getStatus() == null || accountInfo.getStatus() != 1) {
            throw new ELSBootException(I18nUtil.translate((String)"\u8be5\u7528\u6237\u5df2\u51bb\u7ed3"));
        }
        if (accountInfo.getAccountValidityDate() != null && DateUtil.compare((Date)new Date(), (Date)accountInfo.getAccountValidityDate(), (String)"yyyy-MM-dd") > 0) {
            throw new ELSBootException(I18nUtil.translate((String)"\u8be5\u7528\u6237\u8d26\u53f7\u5df2\u5931\u6548\uff01"));
        }
        return accountInfo;
    }

    @Override
    public AccountInfoVO getAccountInfo(String elsAccount, String subAccount) {
        ElsSubAccount accountInfo = this.checkAccount(elsAccount, subAccount);
        AccountInfoVO accountInfoVO = new AccountInfoVO();
        accountInfoVO.setElsAccount(accountInfo.getElsAccount());
        accountInfoVO.setSubAccount(accountInfo.getSubAccount());
        if (StrUtil.isNotBlank((CharSequence)accountInfo.getPhone())) {
            accountInfoVO.setMobilePhone(StrUtil.hide((CharSequence)accountInfo.getPhone(), (int)2, (int)(accountInfo.getPhone().length() - 2)));
        }
        if (StrUtil.isNotBlank((CharSequence)accountInfo.getEmail())) {
            accountInfoVO.setEmail(DesensitizedUtil.email((String)accountInfo.getEmail()));
        }
        return accountInfoVO;
    }

    private String getAuthCodeRedisKey(String elsAccount, String subAccount) {
        StringBuilder builder = new StringBuilder(ACCOUNT_AUTH_CODE_REDIS_KEY);
        builder.append(elsAccount).append(":").append(subAccount);
        return builder.toString();
    }

    private String getAuthErrorCountRedisKey(String elsAccount, String subAccount) {
        StringBuilder builder = new StringBuilder(ACCOUNT_AUTH_ERROR_COUNT_REDIS_KEY);
        builder.append(elsAccount).append(":").append(subAccount);
        return builder.toString();
    }

    private String getTempTokenRedisKey(String elsAccount, String subAccount) {
        StringBuilder builder = new StringBuilder(TEMP_TOKEN);
        builder.append(elsAccount).append(":").append(subAccount);
        return builder.toString();
    }

    @Override
    public void sendAuthCode(SendAuthCodeVO sendAuthCodeVO) {
        ElsSubAccount accountInfo = this.checkAccount(sendAuthCodeVO.getElsAccount(), sendAuthCodeVO.getSubAccount());
        String redisKey = this.getAuthCodeRedisKey(accountInfo.getElsAccount(), accountInfo.getSubAccount());
        if (this.redisUtil.hasKey(redisKey)) {
            throw new ELSBootException("\u9a8c\u8bc1\u7801\u5df2\u53d1\u9001\uff0c10\u5206\u949f\u5185\u6709\u6548");
        }
        String authCode = RandomUtil.randomNumbers((int)6);
        if ("mobilePhone".equals(sendAuthCodeVO.getSendType())) {
            if (StrUtil.isBlank((CharSequence)accountInfo.getPhone()) || !accountInfo.getPhone().equals(sendAuthCodeVO.getMobilePhone())) {
                throw new ELSBootException("\u624b\u673a\u53f7\u9519\u8bef");
            }
            SmsResult result = SmsUtil.sendSmsCode((String)ConfigUtil.getPurchaseAccount(), (String)accountInfo.getPhone(), (String)authCode);
            if (!result.isSuccess()) {
                throw new ELSBootException(result.getMessage());
            }
        } else {
            if (StrUtil.isBlank((CharSequence)accountInfo.getEmail()) || !accountInfo.getEmail().equals(sendAuthCodeVO.getEmail())) {
                throw new ELSBootException("\u90ae\u7bb1\u9519\u8bef");
            }
            try {
                Template temp = FreeMarkerTemplateUtils.getTemplate((String)"emailAuthCodeTemp.ftl");
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                paramsMap.put("authCode", authCode);
                StringWriter stringWriter = new StringWriter();
                temp.process(paramsMap, (Writer)stringWriter);
                EmailUtil.sendEmailAuthCode((String)ConfigUtil.getPurchaseAccount(), (String)"SRM \u90ae\u7bb1\u9a8c\u8bc1\u7801", (String)stringWriter.toString(), (String)sendAuthCodeVO.getEmail());
            }
            catch (Exception e) {
                throw new ELSBootException("\u53d1\u9001\u90ae\u7bb1\u9a8c\u8bc1\u7801\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        this.redisUtil.set(redisKey, (Object)authCode, 600L);
    }

    @Override
    public CheckAuthCodeResultVO checkAuthCode(CheckAuthCodeVO checkAuthCodeVO) {
        ElsSubAccount accountInfo = this.checkAccount(checkAuthCodeVO.getElsAccount(), checkAuthCodeVO.getSubAccount());
        String redisKey = this.getAuthCodeRedisKey(accountInfo.getElsAccount(), accountInfo.getSubAccount());
        if (!this.redisUtil.hasKey(redisKey)) {
            throw new ELSBootException("\u9a8c\u8bc1\u7801\u5df2\u7ecf\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\uff01");
        }
        String authCode = (String)this.redisUtil.get(redisKey);
        if (!authCode.equals(checkAuthCodeVO.getAuthCode())) {
            String errorCountRedisKey = this.getAuthErrorCountRedisKey(accountInfo.getElsAccount(), accountInfo.getSubAccount());
            long errorCount = 1L;
            if (this.redisUtil.hasKey(errorCountRedisKey)) {
                errorCount = this.redisUtil.incr(errorCountRedisKey, 1L);
            } else {
                this.redisUtil.setIncr(errorCountRedisKey, (Object)errorCount);
            }
            if (errorCount > 2L) {
                this.redisUtil.del(new String[]{redisKey});
                this.redisUtil.del(new String[]{errorCountRedisKey});
            }
            throw new ELSBootException("\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        String tempToken = IdWorker.get32UUID();
        CheckAuthCodeResultVO resultVO = new CheckAuthCodeResultVO();
        resultVO.setCheckResult(true);
        resultVO.setTempToken(tempToken);
        this.redisUtil.del(new String[]{redisKey});
        String tempTokenKey = this.getTempTokenRedisKey(accountInfo.getElsAccount(), accountInfo.getSubAccount());
        this.redisUtil.set(tempTokenKey, (Object)tempToken, 600L);
        return resultVO;
    }

    @Override
    public void updatePassword(UpdatePasswordVO passwordVO) {
        ElsSubAccount accountInfo = this.checkAccount(passwordVO.getElsAccount(), passwordVO.getSubAccount());
        String tempTokenKey = this.getTempTokenRedisKey(accountInfo.getElsAccount(), accountInfo.getSubAccount());
        String tempToken = (String)this.redisUtil.get(tempTokenKey);
        if (StrUtil.isBlank((CharSequence)tempToken) || !tempToken.equals(passwordVO.getTempToken())) {
            this.redisUtil.del(new String[]{tempTokenKey});
            throw new ELSBootException("\u4e34\u65f6token\u9a8c\u8bc1\u5931\u8d25");
        }
        ChangePasswordParamVO paramVO = new ChangePasswordParamVO();
        paramVO.setId(accountInfo.getId());
        paramVO.setElsAccount(accountInfo.getElsAccount());
        paramVO.setConfirmPassword(passwordVO.getPassword());
        this.subAccountService.changePassword(paramVO);
        this.redisUtil.del(new String[]{tempTokenKey});
    }
}

