/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.core;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.BooleanUtil;
import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.im.core.cluster.ICluster;
import com.els.modules.im.core.config.ImClusterConfig;
import com.els.modules.im.core.config.ImConfig;
import com.els.modules.im.core.constant.TioConfigConstant;
import com.els.modules.im.core.packets.ClusterToGroupPackets;
import com.els.modules.im.core.packets.ImPackets;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.intf.Packet;
import org.tio.server.TioServerConfig;
import org.tio.utils.lock.SetWithLock;
import org.tio.websocket.common.WsResponse;

public class ImSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImSender.class);

    private static boolean isCluster() {
        ImClusterConfig cluster = TioConfigConstant.imConfig.getCluster();
        return cluster != null && BooleanUtil.isTrue((Boolean)cluster.getOpen());
    }

    public static void sendToGroupChannelContext(String groupId, List<String> ignoredUserIds, TioConfig tioConfig, ImPackets packet) {
        ImSender.sendToGroupChannelContext(groupId, null, ignoredUserIds, tioConfig, packet);
    }

    public static void sendToGroupChannelContext(String groupId, List<String> toUserIds, List<String> ignoredUserIds, TioConfig tioConfig, ImPackets packet) {
        List<ChannelContext> imChannelContextList = ImSender.getByGroup(groupId, tioConfig);
        boolean hasLocalChannels = CollectionUtils.isNotEmpty(imChannelContextList);
        if (hasLocalChannels) {
            try {
                for (ChannelContext context : imChannelContextList) {
                    if (CollectionUtil.isNotEmpty(ignoredUserIds) && ignoredUserIds.contains(context.userid) || CollectionUtil.isNotEmpty(toUserIds) && !toUserIds.contains(context.userid)) continue;
                    ImSender.sendToChannel(context, packet);
                }
            }
            catch (Exception e) {
                log.error("ImSender::\u53d1\u9001\u7fa4\u804a\u6d88\u606f\u7ed9\u672c\u5730\u7528\u6237\u5931\u8d25:{}", (Object)e.getMessage());
            }
        }
        if (ImSender.isCluster() && !packet.isFromCluster()) {
            ImSender.clusterToGroupChannel(groupId, toUserIds, ignoredUserIds, packet);
        }
    }

    private static void clusterToGroupChannel(String groupId, List<String> toUserIds, List<String> ignoredUserIds, ImPackets packet) {
        if (ImSender.isCluster() && !packet.isFromCluster()) {
            log.info("ImSender::\u51c6\u5907\u53d1\u9001\u96c6\u7fa4\u7fa4\u804a\u6d88\u606f,\u7fa4\u7ec4ID:{},\u76ee\u6807\u7528\u6237:{},\u5ffd\u7565\u7528\u6237:{},\u6d88\u606f\u5185\u5bb9:{}", new Object[]{groupId, toUserIds, ignoredUserIds, packet});
            ICluster defaultImCluster = (ICluster)SpringContextUtils.getBean((String)"defaultImCluster", ICluster.class);
            defaultImCluster.clusterToGroup(Lists.newArrayList((Object[])new ClusterToGroupPackets[]{new ClusterToGroupPackets(groupId, ignoredUserIds, toUserIds)}), packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendToGroup(String groupId, List<String> toUserIds, List<String> ignoredUserIds, TioConfig tioConfig, ImPackets packet) {
        try {
            WsResponse toWsResponse = null != packet.getData() ? WsResponse.fromText((String)JSON.toJSONString((Object)packet.getData()), (String)"utf-8") : WsResponse.fromBytes((byte[])packet.getBody());
            Tio.sendToGroup((TioConfig)tioConfig, (String)groupId, (Packet)toWsResponse, channelContext -> {
                String userid = channelContext.userid;
                if (CollectionUtil.isNotEmpty((Collection)toUserIds)) {
                    return toUserIds.contains(userid);
                }
                if (CollectionUtil.isNotEmpty((Collection)ignoredUserIds)) {
                    return !ignoredUserIds.contains(userid);
                }
                return true;
            });
        }
        catch (Exception e) {
            log.error("\u53d1\u9001IM\u6d88\u606f\u7ed9\u7fa4\u7ec4\u5931\u8d25{}", (Object)e.getMessage());
        }
        finally {
            log.info("ImSender::\u53d1\u9001\u96c6\u7fa4\u7fa4\u804a\u6d88\u606f\u7ed9\u7fa4\u7ec4:{},\u6d88\u606f\u5185\u5bb9:{}", (Object)groupId, (Object)packet);
            ImSender.clusterToGroupChannel(groupId, toUserIds, ignoredUserIds, packet);
        }
    }

    public static void sendToChannel(ChannelContext context, ImPackets imPacket) {
        if (context == null) {
            log.warn("\u5f53\u524d\u7528\u6237\u6e20\u9053\u4e3a\u7a7a");
            return;
        }
        String messageId = CharSequenceUtil.isEmpty((CharSequence)imPacket.getMessageId()) ? IdWorker.getIdStr() : imPacket.getMessageId();
        RedisUtil redisUtil = (RedisUtil)SpringContextUtils.getBean(RedisUtil.class);
        if (redisUtil.hasKey("srm:im:user:message:send:" + context.userid + ":" + messageId)) {
            return;
        }
        WsResponse toWsResponse = null != imPacket.getData() ? WsResponse.fromText((String)JSON.toJSONString((Object)imPacket.getData()), (String)"utf-8") : WsResponse.fromBytes((byte[])imPacket.getBody());
        boolean flag = Tio.send((ChannelContext)context, (Packet)toWsResponse);
        if (flag) {
            redisUtil.set("srm:im:user:message:send:" + context.userid + ":" + messageId, (Object)1, (long)((ImConfig)SpringContextUtils.getBean(ImConfig.class)).getMsgSendFlagTime().intValue());
        }
    }

    public static void sendToUserChannelContext(String userId, TioConfig tioConfig, ImPackets packet) {
        List<ChannelContext> imChannelContexts = ImSender.getByUserId(userId, tioConfig);
        boolean hasLocalChannels = CollectionUtils.isNotEmpty(imChannelContexts);
        if (hasLocalChannels) {
            try {
                for (ChannelContext context : imChannelContexts) {
                    ImSender.sendToChannel(context, packet);
                }
            }
            catch (Exception e) {
                log.error("ImSender::\u53d1\u9001\u5355\u804a\u6d88\u606f\u7ed9\u672c\u5730\u7528\u6237\u5931\u8d25:{}", (Object)e.getMessage());
            }
        }
        if (ImSender.isCluster() && !packet.isFromCluster()) {
            ICluster defaultImCluster = (ICluster)SpringContextUtils.getBean((String)"defaultImCluster", ICluster.class);
            defaultImCluster.clusterToUser(Lists.newArrayList((Object[])new String[]{userId}), packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void sendToUser(String userId, TioConfig tioConfig, ImPackets imPacket) {
        boolean flag;
        block6: {
            RedisUtil redisUtil;
            block5: {
                flag = false;
                redisUtil = (RedisUtil)SpringContextUtils.getBean(RedisUtil.class);
                if (!redisUtil.hasKey("srm:im:user:message:send:" + userId + ":" + imPacket.getMessageId())) break block5;
                if (!ImSender.isCluster() || flag || imPacket.isFromCluster()) return;
                log.info("ImSender::\u53d1\u9001\u96c6\u7fa4\u5355\u804a\u6d88\u606f\u7ed9\u7528\u6237:{},\u6d88\u606f\u5185\u5bb9:{}", (Object)userId, (Object)imPacket);
                ICluster defaultImCluster = (ICluster)SpringContextUtils.getBean((String)"defaultImCluster", ICluster.class);
                imPacket.setFromCluster(true);
                defaultImCluster.clusterToUser(Lists.newArrayList((Object[])new String[]{userId}), imPacket);
                return;
            }
            try {
                WsResponse toWsResponse = WsResponse.fromText((String)JSON.toJSONString((Object)imPacket.getData()), (String)"utf-8");
                SetWithLock contextSetWithLock = Tio.getByUserid((TioConfig)tioConfig, (String)userId);
                if (((Set)contextSetWithLock.getObj()).isEmpty() || !(flag = Tio.sendToUser((TioConfig)tioConfig, (String)userId, (Packet)toWsResponse).booleanValue())) break block6;
                redisUtil.set("srm:im:user:message:send:" + userId + ":" + imPacket.getMessageId(), (Object)1, (long)((ImConfig)SpringContextUtils.getBean(ImConfig.class)).getMsgSendFlagTime().intValue());
            }
            catch (Exception e) {
                try {
                    log.error("IM\u53d1\u9001\u6d88\u606f\u7ed9\u7528\u6237\u5931\u8d25:{}", (Object)e.getMessage());
                }
                catch (Throwable throwable) {
                    if (!ImSender.isCluster() || flag || imPacket.isFromCluster()) throw throwable;
                    log.info("ImSender::\u53d1\u9001\u96c6\u7fa4\u5355\u804a\u6d88\u606f\u7ed9\u7528\u6237:{},\u6d88\u606f\u5185\u5bb9:{}", (Object)userId, (Object)imPacket);
                    ICluster defaultImCluster = (ICluster)SpringContextUtils.getBean((String)"defaultImCluster", ICluster.class);
                    imPacket.setFromCluster(true);
                    defaultImCluster.clusterToUser(Lists.newArrayList((Object[])new String[]{userId}), imPacket);
                    throw throwable;
                }
                if (!ImSender.isCluster() || flag || imPacket.isFromCluster()) return;
                log.info("ImSender::\u53d1\u9001\u96c6\u7fa4\u5355\u804a\u6d88\u606f\u7ed9\u7528\u6237:{},\u6d88\u606f\u5185\u5bb9:{}", (Object)userId, (Object)imPacket);
                ICluster defaultImCluster = (ICluster)SpringContextUtils.getBean((String)"defaultImCluster", ICluster.class);
                imPacket.setFromCluster(true);
                defaultImCluster.clusterToUser(Lists.newArrayList((Object[])new String[]{userId}), imPacket);
                return;
            }
        }
        if (!ImSender.isCluster() || flag || imPacket.isFromCluster()) return;
        log.info("ImSender::\u53d1\u9001\u96c6\u7fa4\u5355\u804a\u6d88\u606f\u7ed9\u7528\u6237:{},\u6d88\u606f\u5185\u5bb9:{}", (Object)userId, (Object)imPacket);
        ICluster defaultImCluster = (ICluster)SpringContextUtils.getBean((String)"defaultImCluster", ICluster.class);
        imPacket.setFromCluster(true);
        defaultImCluster.clusterToUser(Lists.newArrayList((Object[])new String[]{userId}), imPacket);
        return;
    }

    public static void bindUser(ChannelContext channelContext, String userId) {
        if (CharSequenceUtil.isEmpty((CharSequence)userId)) {
            log.warn("\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        Tio.bindUser((ChannelContext)channelContext, (String)userId);
    }

    public static void unbindUser(String userId, TioConfig tioConfig) {
        if (CharSequenceUtil.isEmpty((CharSequence)userId)) {
            return;
        }
        SetWithLock userChannels = Tio.getByUserid((TioConfig)tioConfig, (String)userId);
        Set channelContexts = (Set)userChannels.getObj();
        if (channelContexts.isEmpty()) {
            return;
        }
        Tio.unbindUser((TioConfig)tioConfig, (String)userId);
    }

    public static void removeThisOnline(String userId, String serverId) {
        RedisUtil redisUtil;
        Object value;
        if (CharSequenceUtil.isEmpty((CharSequence)serverId)) {
            serverId = TioConfigConstant.SERVER_ID;
        }
        if (CharSequenceUtil.equals((CharSequence)((String)(value = (redisUtil = (RedisUtil)SpringContextUtils.getBean(RedisUtil.class)).get("srm:im:user:online:" + userId))), (CharSequence)serverId)) {
            redisUtil.del(new String[]{"srm:im:user:online:" + userId});
        }
    }

    public static void bindGroup(ChannelContext channelContext, String groupId) {
        if (StringUtils.isEmpty((CharSequence)groupId)) {
            return;
        }
        Tio.bindGroup((ChannelContext)channelContext, (String)groupId);
    }

    public static void clusterToBindGroup(String userId, String groupId) {
        if (StringUtils.isBlank((CharSequence)userId) || StringUtils.isBlank((CharSequence)groupId)) {
            return;
        }
        Tio.bindGroup((TioConfig)TioConfigConstant.tioServerConfig, (String)userId, (String)groupId);
        if (ImSender.isCluster()) {
            ImPackets imPacket = new ImPackets();
            imPacket.setFromCluster(true);
            imPacket.setClusterBind(true);
            imPacket.setBindUserId(userId);
            imPacket.setBindGroupId(groupId);
            ICluster defaultImCluster = (ICluster)SpringContextUtils.getBean((String)"defaultImCluster", ICluster.class);
            defaultImCluster.clusterToBindOrUbBindGroup(imPacket);
        }
    }

    public static void clusterToUbBindGroup(List<String> userIds, String groupId) {
        if (CollectionUtil.isEmpty(userIds) || StringUtils.isBlank((CharSequence)groupId)) {
            return;
        }
        for (String uid : userIds) {
            Tio.unbindGroup((TioConfig)TioConfigConstant.tioServerConfig, (String)uid, (String)groupId);
        }
        if (ImSender.isCluster()) {
            ImPackets imPacket = new ImPackets();
            imPacket.setClusterUbBind(true);
            imPacket.setUbBindUserIds(userIds);
            imPacket.setUnBindGroupId(groupId);
            ICluster defaultImCluster = (ICluster)SpringContextUtils.getBean((String)"defaultImCluster", ICluster.class);
            defaultImCluster.clusterToBindOrUbBindGroup(imPacket);
        }
    }

    public static void bindGroup(TioServerConfig config, String userId, String groupId) {
        if (StringUtils.isEmpty((CharSequence)groupId)) {
            return;
        }
        Tio.bindGroup((TioConfig)config, (String)userId, (String)groupId);
    }

    public static void unbindGroup(String groupId, ChannelContext channelContext) {
        if (StringUtils.isEmpty((CharSequence)groupId)) {
            return;
        }
        Tio.unbindGroup((String)groupId, (ChannelContext)channelContext);
    }

    public static void unbindGroup(String groupId) {
        if (StringUtils.isEmpty((CharSequence)groupId)) {
            return;
        }
        List<ChannelContext> group = ImSender.getByGroup(groupId, (TioConfig)TioConfigConstant.tioServerConfig);
        for (ChannelContext context : group) {
            Tio.unbindGroup((String)groupId, (ChannelContext)context);
        }
    }

    public static void unbindGroup(ChannelContext channelContext) {
        Tio.unbindGroup((ChannelContext)channelContext);
    }

    public static void unbindGroup(String userId, String groupId, TioConfig tioConfig) {
        if (StringUtils.isEmpty((CharSequence)groupId) || StringUtils.isEmpty((CharSequence)userId)) {
            return;
        }
        Tio.unbindGroup((TioConfig)tioConfig, (String)userId, (String)groupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(String userId, TioConfig tioConfig, String remark) {
        SetWithLock userChannelContexts = Tio.getByUserid((TioConfig)tioConfig, (String)userId);
        Set channels = (Set)userChannelContexts.getObj();
        if (channels.isEmpty()) {
            return;
        }
        ReentrantReadWriteLock.ReadLock readLock = userChannelContexts.getLock().readLock();
        try {
            readLock.lock();
            for (ChannelContext channelContext : channels) {
                Tio.remove((ChannelContext)channelContext, (String)remark);
            }
        }
        finally {
            readLock.unlock();
        }
    }

    public static void close(ChannelContext channelContext, String remark) {
        Tio.close((ChannelContext)channelContext, (String)remark);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ChannelContext> convertChannelToImChannel(SetWithLock<ChannelContext> channelContextSetWithLock) {
        ArrayList imChannelContexts = Lists.newArrayList();
        if (Objects.isNull(channelContextSetWithLock)) {
            return imChannelContexts;
        }
        ReentrantReadWriteLock.ReadLock lock = channelContextSetWithLock.getLock().readLock();
        try {
            lock.lock();
            Set channelContexts = (Set)channelContextSetWithLock.getObj();
            if (CollUtil.isEmpty((Collection)channelContexts)) {
                ArrayList arrayList = imChannelContexts;
                return arrayList;
            }
            imChannelContexts.addAll(channelContexts);
            ArrayList arrayList = imChannelContexts;
            return arrayList;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        return imChannelContexts;
    }

    public static List<ChannelContext> getByGroup(String groupId, TioConfig tioConfig) {
        SetWithLock channelContextSetWithLock = Tio.getByGroup((TioConfig)tioConfig, (String)groupId);
        return ImSender.convertChannelToImChannel((SetWithLock<ChannelContext>)channelContextSetWithLock);
    }

    public static List<ChannelContext> getByUserId(String userId, TioConfig tioConfig) {
        SetWithLock channelContextSetWithLock = Tio.getByUserid((TioConfig)tioConfig, (String)userId);
        return ImSender.convertChannelToImChannel((SetWithLock<ChannelContext>)channelContextSetWithLock);
    }
}

