/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.core.cluster;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.im.core.cluster.ICluster;
import com.els.modules.im.core.config.ImClusterConfig;
import com.els.modules.im.core.config.ImConfig;
import com.els.modules.im.core.constant.TioConfigConstant;
import com.els.modules.im.core.packets.ClusterToGroupPackets;
import com.els.modules.im.core.packets.ImPackets;
import java.time.Duration;
import java.util.List;
import lombok.Generated;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="defaultImCluster")
public class RedisCluster
implements ICluster {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisCluster.class);
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private ImConfig srmImConfigProperties;

    @Override
    public void clusterToUser(List<String> userIds, ImPackets packet) {
        ImClusterConfig clusterDto = this.srmImConfigProperties.getCluster();
        if (!this.srmImConfigProperties.isCluster() || CharSequenceUtil.isEmpty((CharSequence)clusterDto.getClusterFriendTopic())) {
            log.warn("RedisCluster::\u96c6\u7fa4\u672a\u542f\u7528\u6216\u96c6\u7fa4\u5355\u804a\u4e3b\u9898\u672a\u914d\u7f6e");
            return;
        }
        if (this.isDuplicateMessage(packet, "clusterToUser")) {
            log.warn("RedisCluster::\u68c0\u6d4b\u5230\u91cd\u590d\u6d88\u606f\uff0c\u8df3\u8fc7\u53d1\u9001\uff0c\u6d88\u606fID:{}", (Object)packet.getMessageId());
            return;
        }
        packet.setUserIds(userIds);
        packet.setClusterToUser(true);
        RTopic topic = this.redissonClient.getTopic(this.srmImConfigProperties.getCluster().getClusterFriendTopic());
        packet.setServerId(TioConfigConstant.SERVER_ID);
        log.info("RedisCluster::\u53d1\u9001\u96c6\u7fa4\u5355\u804a\u6d88\u606f\u5230topic:{},\u6d88\u606f\u5185\u5bb9:{}", (Object)this.srmImConfigProperties.getCluster().getClusterFriendTopic(), (Object)packet);
        topic.publishAsync((Object)packet);
        this.recordSentMessage(packet, "clusterToUser");
    }

    @Override
    public void clusterToGroup(List<ClusterToGroupPackets> groupList, ImPackets packet) {
        ImClusterConfig clusterDto = this.srmImConfigProperties.getCluster();
        if (!this.srmImConfigProperties.isCluster() || CharSequenceUtil.isEmpty((CharSequence)clusterDto.getClusterGroupTopic())) {
            log.warn("RedisCluster::\u96c6\u7fa4\u672a\u542f\u7528\u6216\u96c6\u7fa4\u7fa4\u804a\u4e3b\u9898\u672a\u914d\u7f6e");
            return;
        }
        if (this.isDuplicateMessage(packet, "clusterToGroup")) {
            log.warn("RedisCluster::\u68c0\u6d4b\u5230\u91cd\u590d\u6d88\u606f\uff0c\u8df3\u8fc7\u53d1\u9001\uff0c\u6d88\u606fID:{}", (Object)packet.getMessageId());
            return;
        }
        packet.setGroupList(groupList);
        packet.setClusterToGroup(true);
        RTopic topic = this.redissonClient.getTopic(this.srmImConfigProperties.getCluster().getClusterGroupTopic());
        packet.setServerId(TioConfigConstant.SERVER_ID);
        log.info("RedisCluster::\u53d1\u9001\u96c6\u7fa4\u7fa4\u804a\u6d88\u606f\u5230topic:{},\u6d88\u606f\u5185\u5bb9:{}", (Object)this.srmImConfigProperties.getCluster().getClusterGroupTopic(), (Object)packet);
        topic.publishAsync((Object)packet);
        this.recordSentMessage(packet, "clusterToGroup");
    }

    @Override
    public void clusterToLogout(String userId, ImPackets packet) {
    }

    @Override
    public void clusterToBindOrUbBindGroup(ImPackets packet) {
        ImClusterConfig clusterDto = this.srmImConfigProperties.getCluster();
        if (!this.srmImConfigProperties.isCluster() || CharSequenceUtil.isEmpty((CharSequence)clusterDto.getClusterBindTopic())) {
            log.warn("RedisCluster::\u96c6\u7fa4\u672a\u542f\u7528\u6216\u96c6\u7fa4\u7ed1\u5b9a\u4e3b\u9898\u672a\u914d\u7f6e");
            return;
        }
        packet.setFromCluster(true);
        RTopic topic = this.redissonClient.getTopic(this.srmImConfigProperties.getCluster().getClusterBindTopic());
        packet.setServerId(TioConfigConstant.SERVER_ID);
        log.info("RedisCluster::\u53d1\u9001\u96c6\u7fa4\u7ed1\u5b9a/\u89e3\u7ed1\u6d88\u606f\u5230topic:{},\u6d88\u606f\u5185\u5bb9:{}", (Object)this.srmImConfigProperties.getCluster().getClusterBindTopic(), (Object)packet);
        topic.publishAsync((Object)packet);
    }

    private boolean isDuplicateMessage(ImPackets packet, String type) {
        if (CharSequenceUtil.isBlank((CharSequence)packet.getMessageId())) {
            return false;
        }
        String dedupKey = "srm:im:cluster:dedup:" + type + ":" + packet.getMessageId();
        return Boolean.TRUE.equals(this.redissonClient.getBucket(dedupKey).isExists());
    }

    private void recordSentMessage(ImPackets packet, String type) {
        if (CharSequenceUtil.isBlank((CharSequence)packet.getMessageId())) {
            return;
        }
        String dedupKey = "srm:im:cluster:dedup:" + type + ":" + packet.getMessageId();
        this.redissonClient.getBucket(dedupKey).set((Object)System.currentTimeMillis(), Duration.ofSeconds(((ImConfig)SpringContextUtils.getBean(ImConfig.class)).getMsgSendFlagTime().intValue()));
    }
}

