/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.im.entity.ImGroupChatConfig;
import com.els.modules.im.mapper.ImConfigChatMapper;
import com.els.modules.im.service.ImGroupChatConfigService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImGroupChatConfigServiceImpl
extends ServiceImpl<ImConfigChatMapper, ImGroupChatConfig>
implements ImGroupChatConfigService {
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public void add(ImGroupChatConfig chatConfig) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(ImGroupChatConfig::getBusinessType, (Object)chatConfig.getBusinessType());
        Long count = ((ImConfigChatMapper)this.baseMapper).selectCount((Wrapper)wrapper);
        if (count > 0L) {
            throw new ELSBootException(I18nUtil.translate((String)"\u6c9f\u901a\u7c7b\u578b\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0"));
        }
        ((ImConfigChatMapper)this.baseMapper).insert(chatConfig);
    }

    @Override
    public void edit(ImGroupChatConfig chatConfig) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(ImGroupChatConfig::getBusinessType, (Object)chatConfig.getBusinessType())).ne(ImGroupChatConfig::getId, (Object)chatConfig.getId());
        Long count = ((ImConfigChatMapper)this.baseMapper).selectCount((Wrapper)wrapper);
        if (count > 0L) {
            throw new ELSBootException(I18nUtil.translate((String)"\u6c9f\u901a\u7c7b\u578b\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0"));
        }
        ((ImConfigChatMapper)this.baseMapper).updateById(chatConfig);
    }

    @Override
    public ImGroupChatConfig loadChatConfigByType(String type) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(ImGroupChatConfig::getBusinessType, (Object)type);
        return (ImGroupChatConfig)((ImConfigChatMapper)this.baseMapper).selectOne((Wrapper)wrapper);
    }

    @Override
    public List<ImGroupChatConfig> loadConfig() {
        Object o = this.redisUtil.get("srm:im:ElsChatConfig:" + TenantContext.getTenant());
        if (null != o) {
            return (List)o;
        }
        List imChatGroupLinks = ((ImConfigChatMapper)this.baseMapper).selectList(null);
        this.redisUtil.set("srm:im:ElsChatConfig:" + TenantContext.getTenant(), (Object)imChatGroupLinks);
        return imChatGroupLinks;
    }
}

