/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSONObject;
import com.els.common.util.SpringContextUtils;
import com.els.modules.account.entity.ExternalAccount;
import com.els.modules.account.service.ExternalAccountService;
import com.els.modules.integration.api.dto.ExternalVoucherDto;
import com.els.modules.justauth.util.ThirdAuthUtil;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.enums.SendMsgTypeEnum;
import com.els.modules.message.handle.impl.AbstractSendMsgImpl;
import com.els.modules.message.vo.MsgVO;
import com.els.modules.system.entity.ElsSubAccount;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DingtalkSendMsgImpl
extends AbstractSendMsgImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DingtalkSendMsgImpl.class);

    @Override
    public void doSendMsg(MsgVO msg) {
        log.info("DingTalkSendMsgImpl\u51c6\u5907\u6267\u884c\u53d1\u9001\u9489\u9489\u6d88\u606f\u7684\u903b\u8f91.");
        ElsMsgConfigItem configItem = msg.getConfigItem();
        if (null == configItem) {
            log.warn("DingTalkSendMsgImpl\u7f3a\u5c11\u9489\u9489\u6d88\u606f\u914d\u7f6e");
            return;
        }
        ElsSubAccount receiveAccountInfo = msg.getReceiveAccountInfo();
        ExternalAccountService externalAccountService = (ExternalAccountService)SpringContextUtils.getBean(ExternalAccountService.class);
        ExternalAccount externalAccount = externalAccountService.getEnableAccount(receiveAccountInfo.getElsAccount(), receiveAccountInfo.getId());
        if (null == externalAccount) {
            log.warn("DingTalkSendMsgImpl receive not bind DINGTALK");
            return;
        }
        ExternalVoucherDto config = this.getJustConfig(receiveAccountInfo.getElsAccount(), "dingtalk");
        if (null == config || StrUtil.isEmpty((CharSequence)config.getVoucherKey())) {
            log.error(":::\u9489\u9489\u7b2c\u4e09\u65b9\u914d\u7f6e\u4e0d\u5b58\u5728,elsAccount:{}", (Object)receiveAccountInfo.getElsAccount());
            return;
        }
        try {
            String token = ThirdAuthUtil.getDingTalkToken(config.getElsAccount(), config);
            StringBuilder users = new StringBuilder();
            String unionId = externalAccount.getExternalAccountId();
            String userId = this.getUserIdByUnionId(unionId, token);
            if (StrUtil.isNotBlank((CharSequence)userId)) {
                if (users.length() == 0) {
                    users.append(userId);
                } else {
                    users.append(",").append(userId);
                }
            }
            String urlString = "https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2?access_token=" + token;
            JSONObject body = new JSONObject();
            body.put((Object)"agent_id", (Object)config.getVoucherAgentId());
            body.put((Object)"userid_list", (Object)users.toString());
            JSONObject msgObj = new JSONObject();
            msgObj.put((Object)"msgtype", (Object)"action_card");
            JSONObject actionCard = new JSONObject();
            String msgTitle = configItem.getMsgTitle();
            String linkUrl = this.buildLinkUrl(msg.getBusinessObj(), configItem.getLinkUrl(), "", msg.getBusAccount(), msg.getReceiveAccountInfo());
            actionCard.put((Object)"single_url", (Object)linkUrl);
            actionCard.put((Object)"single_title", (Object)"\u8be6\u60c5");
            Object msgContent = this.parseContentTemplateText("", configItem.getMsgContent(), (Map<String, Object>)msg.getBusinessObj());
            String time = DateUtil.format((Date)new Date(), (DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
            msgContent = (String)msgContent + "<!--" + time + "-->";
            actionCard.put((Object)"markdown", msgContent);
            msgTitle = this.parseContentTemplateText("", msgTitle, (Map<String, Object>)msg.getBusinessObj());
            actionCard.put((Object)"title", (Object)msgTitle);
            msgObj.put((Object)"action_card", (Object)actionCard);
            body.put((Object)"msg", (Object)msgObj);
            String result = HttpUtil.post((String)urlString, (String)body.toString());
            log.info(":::DingTalkSendMsgImpl send message result:{}", (Object)result);
        }
        catch (Exception e) {
            log.error(":::DingTalkSendMsgImpl \u9489\u9489\u53d1\u9001\u6d88\u606f\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    @Override
    protected String getOauthUrl() {
        return "/els/base/thirdLogin/loadQrCode/%s/mobile/dingtalk_account";
    }

    private String getUserIdByUnionId(String unionId, String token) {
        String result = HttpUtil.post((String)("https://oapi.dingtalk.com/topapi/user/getbyunionid?access_token=" + token), (String)("{\"unionid\":\"" + unionId + "\"}"));
        JSONObject resultObj = JSONObject.parseObject((String)result);
        if (resultObj.containsKey("result")) {
            JSONObject obj = resultObj.getJSONObject("result");
            return obj.getString("userid");
        }
        return null;
    }

    @Override
    public String supportType() {
        return SendMsgTypeEnum.DING_TALK.getType();
    }
}

