/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.core.server;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.BooleanUtil;
import com.alibaba.fastjson2.JSON;
import com.els.modules.im.core.ImSender;
import com.els.modules.im.core.config.ImConfig;
import com.els.modules.im.core.constant.TioConfigConstant;
import com.els.modules.im.core.packets.ClusterToGroupPackets;
import com.els.modules.im.core.packets.ImPackets;
import com.els.modules.im.core.server.ImGroupListener;
import com.els.modules.im.core.server.ImTioServerListener;
import com.els.modules.im.core.server.ShowcaseIpStatListener;
import com.els.modules.im.core.server.handler.WsMsgHandler;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RPatternTopic;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.PatternMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.intf.GroupListener;
import org.tio.core.intf.Packet;
import org.tio.core.stat.IpStatListener;
import org.tio.server.TioServerConfig;
import org.tio.server.intf.TioServerListener;
import org.tio.websocket.server.WsServerStarter;
import org.tio.websocket.server.handler.IWsMsgHandler;

@Component
public class StartTioRunner
implements CommandLineRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StartTioRunner.class);
    @Resource(name="wsMsgHandler")
    private WsMsgHandler wsMsgHandler;
    @Resource
    private ImConfig imConfig;
    @Resource
    private RedissonClient redissonClient;

    public void run(String ... args) throws Exception {
        WsServerStarter appStarter = new WsServerStarter(this.imConfig.getBindPort().intValue(), (IWsMsgHandler)this.wsMsgHandler);
        TioServerConfig tioServerConfig = appStarter.getTioServerConfig();
        tioServerConfig.setHeartbeatTimeout(30000L);
        tioServerConfig.setName("showcase");
        tioServerConfig.setTioServerListener((TioServerListener)new ImTioServerListener());
        tioServerConfig.setIpStatListener((IpStatListener)new ShowcaseIpStatListener());
        tioServerConfig.setGroupListener((GroupListener)new ImGroupListener());
        appStarter.start();
        TioConfigConstant.init(tioServerConfig);
        if (!this.imConfig.isCluster()) {
            return;
        }
        RTopic friendTopic = this.redissonClient.getTopic(this.imConfig.getCluster().getClusterFriendTopic());
        friendTopic.addListenerAsync(ImPackets.class, (charSequence, imPacket) -> {
            String serverId = imPacket.getServerId();
            log.info("StartTioRunner::\u6536\u5230\u96c6\u7fa4\u5355\u804a\u6d88\u606f\uff0c\u6765\u6e90\u670d\u52a1\u5668ID:{},\u5f53\u524d\u670d\u52a1\u5668ID:{}", (Object)serverId, (Object)TioConfigConstant.SERVER_ID);
            if (StringUtils.isBlank((CharSequence)serverId)) {
                log.warn("StartTioRunner::\u6d88\u606f\u6765\u6e90ID\u4e3a\u7a7a");
                return;
            }
            if (Objects.equals(TioConfigConstant.SERVER_ID, serverId)) {
                log.warn("StartTioRunner::\u63a5\u6536\u5230\u6765\u81ea\u5df1\u81ea\u5df1\u673a\u5668\u7684\u5e7f\u64ad\u6d88\u606f{}", (Object)serverId);
                return;
            }
            byte[] body = imPacket.getBody();
            if (null == body || body.length == 0) {
                log.warn("StartTioRunner::\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a");
                return;
            }
            log.info("StartTioRunner::\u96c6\u7fa4\u6536\u5230\u5355\u804a\u6d88\u606f:{}", (Object)JSON.toJSONString((Object)imPacket));
            try {
                imPacket.setFromCluster(true);
                Boolean clusterToAll = imPacket.getClusterToAll();
                if (BooleanUtil.isTrue((Boolean)clusterToAll)) {
                    Tio.sendToAll((TioConfig)tioServerConfig, (Packet)imPacket);
                    return;
                }
                Boolean clusterToUser = imPacket.getClusterToUser();
                if (BooleanUtil.isTrue((Boolean)clusterToUser)) {
                    for (String userId : imPacket.getUserIds()) {
                        List<ChannelContext> imChannelContexts = ImSender.getByUserId(userId, (TioConfig)tioServerConfig);
                        if (!CollectionUtils.isNotEmpty(imChannelContexts)) continue;
                        for (ChannelContext context : imChannelContexts) {
                            ImSender.sendToChannel(context, imPacket);
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error("StartTioRunner::IM\u96c6\u7fa4\u5355\u804a\u6d88\u606f\u53d1\u9001\u62a5\u9519:{}", (Object)e.getMessage());
            }
        });
        RTopic groupTopic = this.redissonClient.getTopic(this.imConfig.getCluster().getClusterGroupTopic());
        groupTopic.addListenerAsync(ImPackets.class, (charSequence, imPacket) -> {
            String serverId = imPacket.getServerId();
            log.info("StartTioRunner::\u6536\u5230\u96c6\u7fa4\u7fa4\u804a\u6d88\u606f\uff0c\u6765\u6e90\u670d\u52a1\u5668ID:{},\u5f53\u524d\u670d\u52a1\u5668ID:{}", (Object)serverId, (Object)TioConfigConstant.SERVER_ID);
            if (StringUtils.isBlank((CharSequence)serverId)) {
                log.warn("StartTioRunner::\u6d88\u606f\u6765\u6e90ID\u4e3a\u7a7a");
                return;
            }
            if (Objects.equals(TioConfigConstant.SERVER_ID, serverId)) {
                log.warn("StartTioRunner::\u63a5\u6536\u5230\u6765\u81ea\u5df1\u81ea\u5df1\u673a\u5668\u7684\u5e7f\u64ad\u6d88\u606f{}", (Object)serverId);
                return;
            }
            byte[] body = imPacket.getBody();
            if (null == body || body.length == 0) {
                log.warn("StartTioRunner::\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a");
                return;
            }
            log.info("StartTioRunner::\u96c6\u7fa4\u6536\u5230\u7fa4\u804a\u6d88\u606f:{}", (Object)JSON.toJSONString((Object)imPacket));
            imPacket.setFromCluster(true);
            try {
                Boolean clusterToGroup = imPacket.getClusterToGroup();
                if (BooleanUtil.isTrue((Boolean)clusterToGroup)) {
                    List<ClusterToGroupPackets> groupList = imPacket.getGroupList();
                    log.info("StartTioRunner::\u5904\u7406\u96c6\u7fa4\u7fa4\u804a\u6d88\u606f\uff0c\u7fa4\u7ec4\u5217\u8868:{}", groupList);
                    for (ClusterToGroupPackets groupDto : groupList) {
                        List<ChannelContext> imChannelContextList = ImSender.getByGroup(groupDto.getGroupId(), (TioConfig)tioServerConfig);
                        if (!CollectionUtils.isNotEmpty(imChannelContextList)) continue;
                        try {
                            for (ChannelContext context : imChannelContextList) {
                                if (CollectionUtil.isNotEmpty(groupDto.getIgnoreUserIds()) && groupDto.getIgnoreUserIds().contains(context.userid) || CollectionUtil.isNotEmpty(groupDto.getToUserIds()) && !groupDto.getToUserIds().contains(context.userid)) continue;
                                ImSender.sendToChannel(context, imPacket);
                            }
                        }
                        catch (Exception e) {
                            log.error("StartTioRunner::\u53d1\u9001\u7fa4\u804a\u6d88\u606f\u7ed9\u672c\u5730\u7528\u6237\u5931\u8d25:{}", (Object)e.getMessage());
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error("StartTioRunner::IM\u96c6\u7fa4\u7fa4\u804a\u6d88\u606f\u53d1\u9001\u62a5\u9519:{}", (Object)e.getMessage());
            }
        });
        RTopic bindTopic = this.redissonClient.getTopic(this.imConfig.getCluster().getClusterBindTopic());
        bindTopic.addListenerAsync(ImPackets.class, (charSequence, imPacket) -> {
            String serverId = imPacket.getServerId();
            log.info("StartTioRunner::\u6536\u5230\u96c6\u7fa4\u7ed1\u5b9a/\u89e3\u7ed1\u6d88\u606f\uff0c\u6765\u6e90\u670d\u52a1\u5668ID:{},\u5f53\u524d\u670d\u52a1\u5668ID:{}", (Object)serverId, (Object)TioConfigConstant.SERVER_ID);
            if (StringUtils.isBlank((CharSequence)serverId)) {
                return;
            }
            if (Objects.equals(TioConfigConstant.SERVER_ID, serverId)) {
                return;
            }
            log.info("StartTioRunner::\u96c6\u7fa4\u7ed1\u5b9a\u3001\u89e3\u7ed1\u6d88\u606f:{}", (Object)JSON.toJSONString((Object)imPacket));
            try {
                if (BooleanUtil.isTrue((Boolean)imPacket.getClusterBind())) {
                    String bindUserId = imPacket.getBindUserId();
                    String bindGroupId = imPacket.getBindGroupId();
                    if (CharSequenceUtil.isEmpty((CharSequence)bindUserId) || CharSequenceUtil.isEmpty((CharSequence)bindGroupId)) {
                        log.warn("StartTioRunner::\u96c6\u7fa4\u7ed1\u5b9a\u6d88\u606f\u53c2\u6570\u4e0d\u5b8c\u6574\uff0c\u7528\u6237ID:{}\uff0c\u7fa4\u7ec4ID:{}", (Object)bindUserId, (Object)bindGroupId);
                        return;
                    }
                    Tio.bindGroup((TioConfig)tioServerConfig, (String)bindUserId, (String)bindGroupId);
                    log.info("StartTioRunner::\u96c6\u7fa4\u7ed1\u5b9a\u6210\u529f\uff0c\u7528\u6237ID:{}\uff0c\u7fa4\u7ec4ID:{}", (Object)bindUserId, (Object)bindGroupId);
                    return;
                }
                if (BooleanUtil.isTrue((Boolean)imPacket.getClusterUbBind())) {
                    String unBindGroupId = imPacket.getUnBindGroupId();
                    List<String> ubBindUserIds = imPacket.getUbBindUserIds();
                    if (CharSequenceUtil.isEmpty((CharSequence)unBindGroupId)) {
                        log.warn("StartTioRunner::\u96c6\u7fa4\u89e3\u7ed1\u6d88\u606f\u53c2\u6570\u4e0d\u5b8c\u6574\uff0c\u7fa4\u7ec4ID\u4e3a\u7a7a");
                        return;
                    }
                    if (CollectionUtil.isEmpty(ubBindUserIds)) {
                        log.warn("StartTioRunner::\u7fa4\u804aID:{}\u89e3\u6563", (Object)unBindGroupId);
                        ImSender.unbindGroup(unBindGroupId);
                        return;
                    }
                    for (String uid : ubBindUserIds) {
                        Tio.unbindGroup((TioConfig)tioServerConfig, (String)uid, (String)unBindGroupId);
                    }
                    log.info("StartTioRunner::\u96c6\u7fa4\u89e3\u7ed1\u6210\u529f\uff0c\u7fa4\u7ec4ID:{}\uff0c\u7528\u6237\u5217\u8868:{}", (Object)unBindGroupId, ubBindUserIds);
                }
            }
            catch (Exception e) {
                log.error("StartTioRunner::\u96c6\u7fa4\u7528\u6237\u7ed1\u5b9a\u3001\u89e3\u7ed1\u62a5\u9519:{}", (Object)e.getMessage());
            }
        });
        RPatternTopic patternTopic = this.redissonClient.getPatternTopic("__keyevent@0__:expired:im:kefu:timeout:*");
        patternTopic.addListener(String.class, (PatternMessageListener)new PatternMessageListener<String>(){

            public void onMessage(CharSequence key1, CharSequence key2, String key3) {
                log.info("redis \u8fc7\u671f\u76d1\u542c,{},{},{}", new Object[]{key1, key2, key3});
            }
        });
        RTopic logoutTopic = this.redissonClient.getTopic(this.imConfig.getCluster().getClusterLogoutTopic());
        logoutTopic.addListenerAsync(ImPackets.class, (charSequence, imPacket) -> {
            String logoutUserId;
            String serverId = imPacket.getServerId();
            log.info("StartTioRunner::\u6536\u5230\u96c6\u7fa4\u767b\u51fa\u6d88\u606f\uff0c\u6765\u6e90\u670d\u52a1\u5668ID:{},\u5f53\u524d\u670d\u52a1\u5668ID:{}", (Object)serverId, (Object)TioConfigConstant.SERVER_ID);
            if (StringUtils.isBlank((CharSequence)serverId) || Objects.equals(TioConfigConstant.SERVER_ID, serverId)) {
                return;
            }
            if (BooleanUtil.isTrue((Boolean)imPacket.getClusterToLogout()) && CharSequenceUtil.isNotEmpty((CharSequence)(logoutUserId = imPacket.getLogoutUserId()))) {
                log.info("StartTioRunner::\u5904\u7406\u96c6\u7fa4\u767b\u51fa\u6d88\u606f\uff0c\u7528\u6237ID:{}", (Object)logoutUserId);
                ImSender.remove(logoutUserId, (TioConfig)tioServerConfig, "\u96c6\u7fa4\u7528\u6237\u4e0b\u7ebf");
                ImSender.unbindUser(logoutUserId, (TioConfig)tioServerConfig);
            }
        });
    }
}

