/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.modules.im.entity.ImGroupChatUser;
import com.els.modules.im.mapper.ImGroupChatMapper;
import com.els.modules.im.mapper.ImGroupChatUserMapper;
import com.els.modules.im.service.IImGroupChatUserService;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ImGroupChatUserServiceImpl
extends ServiceImpl<ImGroupChatUserMapper, ImGroupChatUser>
implements IImGroupChatUserService {
    @Autowired
    private ImGroupChatMapper imChatGroupMapper;

    @Override
    public ImGroupChatUser getByKey(String userId, String chatGroupId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ImGroupChatUser::getGroupChatId, (Object)chatGroupId);
        queryWrapper.eq(ImGroupChatUser::getUserId, (Object)userId);
        return (ImGroupChatUser)((ImGroupChatUserMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
    }

    @Override
    public List<ImGroupChatUser> getByKey(List<String> userIds, String chatGroupId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ImGroupChatUser::getGroupChatId, (Object)chatGroupId);
        queryWrapper.in(ImGroupChatUser::getUserId, userIds);
        return ((ImGroupChatUserMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public void initCreator(ImGroupChatUser chatGroupUser) {
        ((ImGroupChatUserMapper)this.baseMapper).insert(chatGroupUser);
    }

    @Override
    public List<ImGroupChatUser> getChatUserByChatId(String chatId) {
        return ((ImGroupChatUserMapper)this.baseMapper).getChatUserByChatId(chatId);
    }

    @Override
    public void removeChatGroupUser(String chatGroupId, String userId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)wrapper.eq(ImGroupChatUser::getGroupChatId, (Object)chatGroupId)).eq(ImGroupChatUser::getUserId, (Object)userId);
        ((ImGroupChatUserMapper)this.baseMapper).delete((Wrapper)wrapper);
    }

    @Override
    public void removeChatGroupUser(String chatGroupId, List<String> userIds) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)wrapper.eq(ImGroupChatUser::getGroupChatId, (Object)chatGroupId)).in(ImGroupChatUser::getUserId, userIds);
        ((ImGroupChatUserMapper)this.baseMapper).delete((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public List<String> deleteChatGroup(String chatGroupId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(ImGroupChatUser::getGroupChatId, (Object)chatGroupId);
        List imChatGroupUserList = ((ImGroupChatUserMapper)this.baseMapper).selectList((Wrapper)wrapper);
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.eq(ImGroupChatUser::getGroupChatId, (Object)chatGroupId);
        ((ImGroupChatUserMapper)this.baseMapper).delete((Wrapper)updateWrapper);
        this.imChatGroupMapper.deleteById((Serializable)((Object)chatGroupId));
        return imChatGroupUserList.stream().map(ImGroupChatUser::getUserId).distinct().collect(Collectors.toList());
    }

    @Override
    public List<ImGroupChatUser> getChatGroupUserByGroupId(String chatGroupId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(ImGroupChatUser::getGroupChatId, (Object)chatGroupId);
        return ((ImGroupChatUserMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }
}

