/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.excel;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.excel.service.BaseExportService;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.SrmRpcUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.ExportDataLoaderService;
import com.els.modules.org.api.service.OrgRpcService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.UserRoleService;
import com.els.modules.system.vo.ElsSubAccountVO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="elsSubAccountExcelDataBatchQueryLoader")
public class AccountExportServiceImpl
extends BaseExportService<ElsSubAccount, ElsSubAccountVO, ElsSubAccount>
implements ExportDataLoaderService {
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private UserRoleService userRoleService;

    public List<ElsSubAccountVO> queryExportData(QueryWrapper<ElsSubAccount> queryWrapper, ElsSubAccount param, Map<String, String[]> paramMap) {
        queryWrapper.lambda().eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant());
        List pageList = this.elsSubAccountService.list((Wrapper)queryWrapper);
        List result = Convert.toList(ElsSubAccountVO.class, (Object)pageList);
        List codes = result.stream().filter(x -> StrUtil.isNotEmpty((CharSequence)x.getDeptId())).flatMap(x -> Arrays.stream(x.getDeptId().split(","))).distinct().collect(Collectors.toList());
        Map orgMap = ((OrgRpcService)SrmRpcUtil.getExecuteServiceImpl(OrgRpcService.class)).listDeptOrganization(codes);
        Map<String, String> roleMap = this.userRoleService.loadUserRole(pageList.stream().map(ParentEntity::getId).collect(Collectors.toList()));
        for (ElsSubAccountVO elsSubAccount : result) {
            String orgCode = elsSubAccount.getDeptId();
            if (StrUtil.isNotEmpty((CharSequence)orgCode)) {
                ArrayList ids = Lists.newArrayList((Object[])orgCode.split(","));
                String org = ids.stream().filter(orgMap::containsKey).map(orgMap::get).collect(Collectors.joining(","));
                elsSubAccount.setOrgCode_dictText(org);
            }
            elsSubAccount.setSelectedroles_dictText(roleMap.get(elsSubAccount.getId()));
            elsSubAccount.setSelectedroles(roleMap.get(elsSubAccount.getId()));
        }
        return result;
    }

    public long queryExportDataCount(QueryWrapper<ElsSubAccount> queryWrapper, ElsSubAccount map, Map<String, String[]> paramMap) {
        queryWrapper.lambda().eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant());
        return this.elsSubAccountService.count((Wrapper)queryWrapper);
    }

    public String getBusinessType() {
        return "ElsSubAccount";
    }

    public String getBeanName() {
        return "elsSubAccountExcelDataBatchQueryLoader";
    }

    public String loadData(Integer pageNumber, Integer pageSize, Map<String, Object> entityMap, Map<String, String[]> requestParamMap) {
        Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = this.builderWrapper(entityMap, requestParamMap);
        List pageList = ((Page)this.elsSubAccountService.page((IPage)page, (Wrapper)queryWrapper)).getRecords();
        List result = Convert.toList(ElsSubAccountVO.class, (Object)pageList);
        List codes = result.stream().filter(x -> StrUtil.isNotEmpty((CharSequence)x.getDeptId())).flatMap(x -> Arrays.stream(x.getDeptId().split(","))).distinct().collect(Collectors.toList());
        Map orgMap = ((OrgRpcService)SrmRpcUtil.getExecuteServiceImpl(OrgRpcService.class)).listDeptOrganization(codes);
        Map<String, String> roleMap = this.userRoleService.loadUserRole(pageList.stream().map(ParentEntity::getId).collect(Collectors.toList()));
        for (ElsSubAccountVO elsSubAccount : result) {
            String orgCode = elsSubAccount.getDeptId();
            if (StrUtil.isNotEmpty((CharSequence)orgCode)) {
                ArrayList ids = Lists.newArrayList((Object[])orgCode.split(","));
                String org = ids.stream().filter(orgMap::containsKey).map(orgMap::get).collect(Collectors.joining(","));
                elsSubAccount.setOrgCode_dictText(org);
            }
            elsSubAccount.setSelectedroles_dictText(roleMap.get(elsSubAccount.getId()));
            elsSubAccount.setSelectedroles(roleMap.get(elsSubAccount.getId()));
        }
        return JSON.toJSONString((Object)result);
    }
}

