/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.utils;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.els.modules.im.core.packets.WsMessageDataPackets;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TuLingRobotUtil
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TuLingRobotUtil.class);
    private static final long serialVersionUID = 1L;

    public static JSONObject buildJSONObject(WsMessageDataPackets message, String elsAccount, String serverPath) {
        JSONObject param = new JSONObject();
        JSONObject userId = new JSONObject();
        userId.put((Object)"userId", (Object)message.getId());
        param.put((Object)"userInfo", (Object)userId);
        Integer type = 0;
        JSONObject typeObj = new JSONObject();
        JSONObject text = new JSONObject();
        String path = serverPath.endsWith("/") ? serverPath + "els" : serverPath + "/els";
        switch (message.getMessageType()) {
            case "text": {
                text.put((Object)"text", (Object)message.getMessageContent());
                typeObj.put((Object)"inputText", (Object)text);
                break;
            }
            case "img": {
                type = 1;
                String substring = message.getMessageContent().substring(4);
                text.put((Object)"url", (Object)(path + substring.substring(0, substring.length() - 1)));
                typeObj.put((Object)"inputImage", (Object)text);
                break;
            }
            case "audio": {
                type = 2;
                String substring = message.getMessageContent().substring(6);
                text.put((Object)"url", (Object)(path + substring.substring(0, substring.length() - 1)));
                typeObj.put((Object)"inputMedia", (Object)text);
                break;
            }
            case "file": {
                break;
            }
            default: {
                text.put((Object)"text", (Object)message.getMessageContent());
                typeObj.put((Object)"inputText", (Object)text);
            }
        }
        param.put((Object)"reqType", (Object)type);
        param.put((Object)"perception", (Object)typeObj);
        param.put((Object)"currentAccount", (Object)elsAccount);
        return param;
    }

    public static JSONObject buildChatGptJSONObject(WsMessageDataPackets message, String elsAccount, String model) {
        JSONObject param = new JSONObject();
        param.put((Object)"model", (Object)model);
        JSONObject messageObj = new JSONObject();
        messageObj.put((Object)"role", (Object)"user");
        messageObj.put((Object)"content", (Object)message.getMessageContent());
        JSONArray messages = new JSONArray();
        messages.add((Object)messageObj);
        param.put((Object)"messages", (Object)messages);
        param.put((Object)"currentAccount", (Object)elsAccount);
        return param;
    }

    public static JSONObject buildChatGlmJSONObject(WsMessageDataPackets message, String elsAccount, String knowledgeBaseId) {
        JSONObject param = new JSONObject();
        param.put((Object)"knowledge_base_id", (Object)(CharSequenceUtil.blankToDefault((CharSequence)knowledgeBaseId, (String)"v5srm") + "_"));
        param.put((Object)"question", (Object)message.getMessageContent());
        param.put((Object)"currentAccount", (Object)elsAccount);
        return param;
    }

    public static enum Error {
        C_5000(5000, "\u65e0\u89e3\u6790\u7ed3\u679c"),
        C_6000(6000, "\u6682\u4e0d\u652f\u6301\u8be5\u529f\u80fd"),
        C_4000(4000, "\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u9519\u8bef"),
        C_4001(4001, "\u52a0\u5bc6\u65b9\u5f0f\u9519\u8bef"),
        C_4002(4002, "\u65e0\u529f\u80fd\u6743\u9650"),
        C_4003(4003, "\u8be5apikey\u6ca1\u6709\u53ef\u7528\u8bf7\u6c42\u6b21\u6570"),
        C_4005(4005, "\u65e0\u529f\u80fd\u6743\u9650"),
        C_4007(4007, "apikey\u4e0d\u5408\u6cd5"),
        C_4100(4100, "userid\u83b7\u53d6\u5931\u8d25"),
        C_4200(4200, "\u4e0a\u4f20\u683c\u5f0f\u9519\u8bef"),
        C_4300(4300, "\u6279\u91cf\u64cd\u4f5c\u8d85\u8fc7\u9650\u5236"),
        C_4400(4400, "\u6ca1\u6709\u4e0a\u4f20\u5408\u6cd5userid"),
        C_4500(4500, "userid\u7533\u8bf7\u4e2a\u6570\u8d85\u8fc7\u9650\u5236"),
        C_4600(4600, "\u8f93\u5165\u5185\u5bb9\u4e3a\u7a7a"),
        C_4602(4602, "\u8f93\u5165\u6587\u672c\u5185\u5bb9\u8d85\u957f(\u4e0a\u9650150)"),
        C_7002(7002, "\u4e0a\u4f20\u4fe1\u606f\u5931\u8d25"),
        C_8008(8008, "\u670d\u52a1\u5668\u9519\u8bef"),
        C_0(0, "\u4e0a\u4f20\u6210\u529f");

        private Integer code;
        private String msg;

        public static Error buildErrorCode(Integer code) {
            Optional<Error> any = Arrays.stream(Error.values()).filter(x -> x.getCode().equals(code)).findAny();
            return any.orElse(null);
        }

        @Generated
        private Error(Integer code, String msg) {
            this.code = code;
            this.msg = msg;
        }

        @Generated
        public Integer getCode() {
            return this.code;
        }

        @Generated
        public String getMsg() {
            return this.msg;
        }
    }

    public static enum ResultType {
        TEXT("text", "", "", "text", false),
        URL("url", "", "", "text", false),
        VOICE("voice", "audio[", "]", "audio", true),
        VIDEO("video", "", "", "video", true),
        IMAGE("image", "img[", "]", "img", true),
        NEWS("news", "", "", "text", false);

        private String code;
        private String start;
        private String end;
        private String type;
        private boolean needPath;

        public static String buildText(String type, String context) {
            Optional<ResultType> any = Arrays.stream(ResultType.values()).filter(x -> x.code.equalsIgnoreCase(type)).findAny();
            if (!any.isPresent()) {
                return context;
            }
            ResultType resultType = any.get();
            if (context.startsWith(resultType.getStart())) {
                return context;
            }
            return resultType.getStart() + context + resultType.getEnd();
        }

        public static String buildText(String type, String context, String path) {
            Optional<ResultType> any = Arrays.stream(ResultType.values()).filter(x -> x.code.equalsIgnoreCase(type)).findAny();
            if (!any.isPresent()) {
                return context;
            }
            ResultType resultType = any.get();
            if (resultType.needPath) {
                String serverPath = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
                return resultType.getStart() + serverPath + context + resultType.getEnd();
            }
            return resultType.getStart() + context + resultType.getEnd();
        }

        public static String buildType(String type) {
            Optional<ResultType> any = Arrays.stream(ResultType.values()).filter(x -> x.code.equalsIgnoreCase(type)).findAny();
            if (!any.isPresent()) {
                return TEXT.getType();
            }
            return any.get().getType();
        }

        public static ResultType buildResultType(String type) {
            Optional<ResultType> any = Arrays.stream(ResultType.values()).filter(x -> x.type.equalsIgnoreCase(type)).findAny();
            return any.orElse(TEXT);
        }

        @Generated
        private ResultType(String code, String start, String end, String type, boolean needPath) {
            this.code = code;
            this.start = start;
            this.end = end;
            this.type = type;
            this.needPath = needPath;
        }

        @Generated
        public String getCode() {
            return this.code;
        }

        @Generated
        public String getStart() {
            return this.start;
        }

        @Generated
        public String getEnd() {
            return this.end;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public boolean isNeedPath() {
            return this.needPath;
        }
    }
}

