/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONReader;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.api.service.MsgBusinessDataRpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.ConfigUtil;
import com.els.common.util.SrmRpcUtil;
import com.els.modules.message.entity.ElsMsgConfigHead;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.ISendMsgService;
import com.els.modules.message.service.ElsMsgConfigHeadService;
import com.els.modules.message.service.ElsMsgConfigItemService;
import com.els.modules.message.service.MsgObjScriptService;
import com.els.modules.message.service.MsgService;
import com.els.modules.message.util.MessageHandleFactory;
import com.els.modules.message.util.MsgGroovyFactory;
import com.els.modules.message.vo.MsgVO;
import com.els.modules.supplier.api.service.SupplierRpcService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.PersonalSetting;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.PersonalSettingService;
import com.els.modules.system.service.UserRoleService;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MsgServiceImpl
implements MsgService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MsgServiceImpl.class);
    @Resource
    private ElsMsgConfigHeadService messageConfigService;
    @Resource
    private ElsMsgConfigItemService messageConfigItemService;
    @Resource
    private ElsSubAccountService accountInfoService;
    @Resource
    private UserRoleService roleAccountService;
    @Resource
    private PersonalSettingService accountReceiveSetService;

    @Override
    public void sendMsg(com.alibaba.fastjson2.JSONObject body) {
        this.buildMsg(body);
        String messageConfigId = body.getString("messageConfigId");
        List<ElsMsgConfigItem> configItemList = this.messageConfigItemService.selectByMainId(messageConfigId);
        com.alibaba.fastjson2.JSONObject businessObj = body.getJSONObject("businessObj");
        String sendAccountId = body.getString("sendAccountId");
        ElsSubAccount sendAccountInfo = this.accountInfoService.getSubAccountById(sendAccountId);
        List receiveSubAccountList = body.getList("receiveSubAccountList", ElsSubAccount.class, new JSONReader.Feature[0]);
        for (ElsSubAccount receiveAccountInfo : receiveSubAccountList) {
            List accountReceiveSetList = this.accountReceiveSetService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PersonalSetting::getElsAccount, (Object)receiveAccountInfo.getElsAccount())).eq(PersonalSetting::getSubAccount, (Object)receiveAccountInfo.getSubAccount()));
            List<String> receiveMsgTypeList = accountReceiveSetList.stream().filter(item -> item.getIsReceive() == 1).map(PersonalSetting::getReceiveType).toList();
            for (ElsMsgConfigItem configItem : configItemList) {
                if (!Objects.equals(configItem.getEnabled(), "1") || !receiveMsgTypeList.contains(configItem.getMsgType())) continue;
                try {
                    MsgVO msg = new MsgVO();
                    msg.setBusAccount(body.getString("busAccount"));
                    msg.setBusinessObj(businessObj);
                    msg.setConfigItem(configItem);
                    msg.setMsgType(configItem.getMsgType());
                    msg.setReceiveAccountInfo(receiveAccountInfo);
                    msg.setSendAccountInfo(sendAccountInfo);
                    msg.setBusinessId(body.getString("businessId"));
                    msg.setMsgConfigCode(body.getString("msgConfigCode"));
                    msg.setBusinessType(body.getString("businessType"));
                    msg.setMsgConfigName(body.getString("msgConfigName"));
                    ISendMsgService sendMsgService = MessageHandleFactory.getMsgHandle(configItem.getMsgType());
                    sendMsgService.sendMsg(msg);
                }
                catch (Exception e) {
                    log.error("MsgServiceImpl-sendMsg,type:{},data:{},error:{}", new Object[]{configItem.getMsgType(), body.toString(), e.getMessage()});
                }
            }
        }
    }

    private void buildMsg(com.alibaba.fastjson2.JSONObject body) {
        try {
            JSONArray receiveElsAccountArray;
            List<ElsSubAccount> receiveSubAccountList;
            String businessId = body.getString("businessId");
            String businessBean = body.getString("businessBean");
            String msgConfigCode = body.getString("msgConfigCode");
            com.alibaba.fastjson2.JSONObject businessObj = body.getJSONObject("businessObj");
            if (CharSequenceUtil.isEmpty((CharSequence)businessBean) && null != businessObj) {
                body.put((Object)"businessObj", (Object)businessObj);
            } else {
                JSONObject businessObj2 = ((MsgBusinessDataRpcService)SrmRpcUtil.getExecuteServiceImpl((String)businessBean, MsgBusinessDataRpcService.class)).getBusinessDataById(businessId);
                if (businessObj2 != null) {
                    body.put((Object)"businessObj", (Object)com.alibaba.fastjson2.JSONObject.parseObject((String)businessObj2.toJSONString()));
                }
            }
            String msgType = body.getString("msgType");
            if ("alert".equals(msgType)) {
                return;
            }
            String busAccount = body.getString("busAccount");
            ElsMsgConfigHead configHead = this.getMessageConfig(busAccount, msgConfigCode);
            body.put((Object)"messageConfigId", (Object)configHead.getId());
            body.put((Object)"businessType", (Object)configHead.getBusinessType());
            body.put((Object)"msgConfigName", (Object)configHead.getMsgConfigName());
            JSONArray receiveSubAccountIdArray = body.getJSONArray("receiveSubAccountIdList");
            if (receiveSubAccountIdArray != null) {
                List receiveUserIdList = receiveSubAccountIdArray.toList(String.class, new JSONReader.Feature[0]);
                receiveSubAccountList = this.accountInfoService.listByIds(receiveUserIdList);
                body.put((Object)"receiveSubAccountList", receiveSubAccountList);
            }
            if ((receiveElsAccountArray = body.getJSONArray("receiveElsAccountList")) == null) {
                return;
            }
            receiveSubAccountList = new ArrayList();
            for (Object obj : receiveElsAccountArray) {
                ElsSubAccount subAccount;
                List<String> idList;
                MsgObjScriptService scriptService;
                List roleAccountList;
                String roleId;
                String principal;
                String createById;
                String principalCode;
                String script;
                String noticeObj;
                String receiveElsAccount = (String)obj;
                ArrayList<String> userIdList = new ArrayList<String>();
                ArrayList userList = new ArrayList();
                if (busAccount.equals(receiveElsAccount)) {
                    noticeObj = configHead.getPurchaseNoticeObj();
                    script = configHead.getPurchaseScript();
                    principalCode = "purchasePrincipalId";
                } else {
                    noticeObj = configHead.getSaleNoticeObj();
                    script = configHead.getSaleScript();
                    principalCode = "supplierPrincipalId";
                }
                if (noticeObj == null) {
                    noticeObj = "";
                }
                if (noticeObj.contains("create") && StrUtil.isNotBlank((CharSequence)(createById = businessObj.getString("createById")))) {
                    userIdList.add(createById);
                }
                if (noticeObj.contains("principal") && StrUtil.isNotBlank((CharSequence)(principal = businessObj.getString(principalCode)))) {
                    userIdList.add(principal);
                }
                if (noticeObj.contains("role") && StrUtil.isNotBlank((CharSequence)(roleId = configHead.getPurchaseRoleId())) && CollectionUtil.isNotEmpty((Collection)(roleAccountList = this.roleAccountService.list((Wrapper)new LambdaQueryWrapper().in(UserRole::getRoleId, (Object[])roleId.split(",")))))) {
                    userIdList.addAll(roleAccountList.stream().map(UserRole::getUserId).distinct().toList());
                }
                if (noticeObj.contains("user") && StrUtil.isNotBlank((CharSequence)configHead.getPurchaseAssigneeId())) {
                    userIdList.addAll(Arrays.asList(configHead.getPurchaseAssigneeId().split(",")));
                }
                if (noticeObj.contains("script") && StrUtil.isNotBlank((CharSequence)script) && (scriptService = MsgGroovyFactory.getInstance().getMsgObjScriptServiceFromCode(script)) != null && CollUtil.isNotEmpty(idList = scriptService.getUserIdByScript(businessObj))) {
                    userIdList.addAll(idList);
                }
                if (noticeObj.contains("function") && StrUtil.isNotBlank((CharSequence)configHead.getJobFunction())) {
                    userIdList.addAll(((SupplierRpcService)SrmRpcUtil.getExecuteServiceImpl(SupplierRpcService.class)).getUserIdByJobFunction(configHead.getJobFunction(), busAccount, receiveElsAccount));
                }
                log.info("MsgServiceImpl sendElsAccount:{},userIdList:{},businessBean:{}", new Object[]{obj, userIdList, businessBean});
                if (!userIdList.isEmpty()) {
                    userList.addAll(this.accountInfoService.listByIds(userIdList));
                    receiveSubAccountList.addAll(userList);
                }
                if (!userList.isEmpty() || (subAccount = this.accountInfoService.getByAccount(receiveElsAccount, "1001")) == null) continue;
                receiveSubAccountList.add(subAccount);
            }
            body.put((Object)"receiveSubAccountList", receiveSubAccountList);
        }
        catch (Exception e) {
            log.error("buildMsg_failed:" + body.toString(), (Throwable)e);
            throw e;
        }
    }

    private ElsMsgConfigHead getMessageConfig(String busAccount, String msgConfigCode) {
        ElsMsgConfigHead config = (ElsMsgConfigHead)((Object)this.messageConfigService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ParentEntity::getElsAccount, (Object)busAccount)).eq(ElsMsgConfigHead::getMsgConfigCode, (Object)msgConfigCode), false));
        if (config == null) {
            config = (ElsMsgConfigHead)((Object)this.messageConfigService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ParentEntity::getElsAccount, (Object)ConfigUtil.getPurchaseAccount())).eq(ElsMsgConfigHead::getMsgConfigCode, (Object)msgConfigCode), false));
        }
        if (config == null) {
            config = (ElsMsgConfigHead)((Object)this.messageConfigService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ParentEntity::getElsAccount, (Object)"100000")).eq(ElsMsgConfigHead::getMsgConfigCode, (Object)msgConfigCode), false));
        }
        if (config == null) {
            throw new ELSBootException("\u6d88\u606f\u7f16\u7801\uff1a" + msgConfigCode + " \u4e0d\u5b58\u5728\u6d88\u606f\u914d\u7f6e\uff01");
        }
        return config;
    }
}

