/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.SensitiveField;
import com.els.modules.system.service.SensitiveFieldService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u654f\u611f\u5b57\u6bb5\u914d\u7f6e")
@RestController
@RequestMapping(value={"/base/sensitiveField"})
public class SensitiveFieldController
extends BaseController<SensitiveField, SensitiveFieldService> {
    @Autowired
    private SensitiveFieldService sensitiveFieldService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2-\u4f01\u4e1a\u7ea7", description="\u5206\u9875\u5217\u8868\u67e5\u8be2-\u4f01\u4e1a\u7ea7")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"system#sensitiveField:list"})
    public Result<?> queryPageList(SensitiveField sensitiveField, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)sensitiveField), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sensitiveFieldService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2-\u5e73\u53f0\u7ea7", description="\u5206\u9875\u5217\u8868\u67e5\u8be2-\u5e73\u53f0\u7ea7")
    @GetMapping(value={"/sysList"})
    @RequiresPermissions(value={"system#sensitiveField:sysList"})
    public Result<?> querySysPageList(SensitiveField sensitiveField, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)sensitiveField), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sensitiveFieldService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u654f\u611f\u5b57\u6bb5\u914d\u7f6e-\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"system#sensitiveField:add"})
    public Result<?> add(@RequestBody SensitiveField sensitiveField) {
        this.sensitiveFieldService.saveSensitiveField(sensitiveField);
        return Result.ok((Object)((Object)sensitiveField));
    }

    @AutoLog(value="\u654f\u611f\u5b57\u6bb5\u914d\u7f6e-\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"system#sensitiveField:edit"})
    public Result<?> edit(@RequestBody SensitiveField sensitiveField) {
        this.sensitiveFieldService.updateSensitiveField(sensitiveField);
        String id = sensitiveField.getId();
        return this.queryById(id);
    }

    @AutoLog(value="\u654f\u611f\u5b57\u6bb5\u914d\u7f6e-\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"system#sensitiveField:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.sensitiveFieldService.delSensitiveField(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u654f\u611f\u5b57\u6bb5\u914d\u7f6e-\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"system#sensitiveField:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.sensitiveFieldService.delBatchSensitiveField(idList);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"system#sensitiveField:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SensitiveField sensitiveField = (SensitiveField)((Object)this.sensitiveFieldService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)sensitiveField));
    }

    @Operation(summary="\u83b7\u53d6\u5b57\u6bb5\u5206\u7ec4\u5217\u8868", description="\u83b7\u53d6\u5b57\u6bb5\u5206\u7ec4\u5217\u8868")
    @GetMapping(value={"/findAllGroup"})
    @RequiresPermissions(value={"system#sensitiveField:queryById"})
    public Result<?> findAllGroup() {
        List<SensitiveField> sensitiveFieldList = this.sensitiveFieldService.findAllGroup(this.getTenantId());
        return Result.ok(sensitiveFieldList);
    }
}

