/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bi.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.PasswordUtil;
import com.els.common.util.RedisKeyUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.bi.service.BiInvokeService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.vo.pojo.BiUser;
import org.springframework.stereotype.Service;

@Service(value="biInvokeService_getCurrentUserByPassword")
public class BiInvokeGetCurrentUserByPasswordServiceImpl
implements BiInvokeService {
    @Override
    public Object invoke(JSONObject object) {
        String elsAccount = object.getString("elsAccount");
        String subAccount = object.getString("subAccount");
        String password = object.getString("password");
        this.checkParam(elsAccount, subAccount, password);
        ElsSubAccountService elsSubAccountService = (ElsSubAccountService)SpringContextUtils.getBean(ElsSubAccountService.class);
        RedisUtil redisUtil = (RedisUtil)SpringContextUtils.getBean(RedisUtil.class);
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ParentEntity::getElsAccount, (Object)elsAccount)).eq(ElsSubAccount::getSubAccount, (Object)subAccount)).eq(ElsSubAccount::getStatus, (Object)"1");
        ElsSubAccount account = (ElsSubAccount)((Object)elsSubAccountService.getOne((Wrapper)wrapper));
        if (account == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_jDRSwoNSW_d7a449f8", (String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef"));
        }
        String encryptPassword = PasswordUtil.encrypt((String)(elsAccount + "_" + subAccount), (String)password, (String)account.getSalt());
        if (!encryptPassword.equals(account.getPassword())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_jDRSwoNSW_d7a449f8", (String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef"));
        }
        String token = JwtUtil.sign((String)account.getElsAccount(), (String)account.getSubAccount(), (String)account.getPassword());
        String tokenRedisKey = JwtUtil.getTokenRedisKey((String)elsAccount, (String)subAccount, (String)token);
        redisUtil.set(tokenRedisKey, (Object)token, (long)JwtUtil.expireTime());
        this.clearRedisCache(elsAccount, subAccount, redisUtil);
        BiUser biUser = new BiUser();
        biUser.setId(account.getId());
        biUser.setElsAccount(account.getElsAccount());
        biUser.setSubAccount(account.getSubAccount());
        biUser.setName(account.getRealname());
        biUser.setDisplayName(elsAccount + "_" + subAccount + "_" + account.getRealname());
        biUser.setIsAdmin("1");
        biUser.setSrmToken(token);
        return biUser;
    }

    private void checkParam(String elsAccount, String subAccount, String password) {
        if (CharSequenceUtil.isEmpty((CharSequence)elsAccount)) {
            throw new ELSBootException("elsAccount\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CharSequenceUtil.isEmpty((CharSequence)subAccount)) {
            throw new ELSBootException("subAccount\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CharSequenceUtil.isEmpty((CharSequence)password)) {
            throw new ELSBootException("password\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void clearRedisCache(String elsAccount, String subAccount, RedisUtil redisUtil) {
        String shiroKey = RedisKeyUtil.getShiroRedisKey((String)elsAccount, (String)subAccount);
        redisUtil.del(new String[]{shiroKey});
        String menuKey = RedisKeyUtil.getPermissionMenuRedisKey((String)elsAccount, (String)subAccount);
        redisUtil.del(new String[]{menuKey});
        String adminKey = RedisKeyUtil.getAdminFlagRedisKey((String)elsAccount, (String)subAccount);
        redisUtil.del(new String[]{adminKey});
        RedisKeyUtil.clearLoginUserCache((String)elsAccount, (String)subAccount);
    }
}

