/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import com.els.modules.system.util.ExcelStyleUtil;
import com.els.modules.system.util.ExcelTreeUtil;
import com.els.modules.system.vo.ColEntityVO;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelPoiUtil<T> {
    private XSSFWorkbook workbook;
    private String title;
    private CellStyle styleHead;
    private CellStyle styleBody;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Set<String> mergedRegions;

    public XSSFWorkbook getWorkbook() {
        return this.workbook;
    }

    public void setWorkbook(XSSFWorkbook workbook) {
        this.workbook = workbook;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public CellStyle getStyleHead() {
        return this.styleHead;
    }

    public void setStyleHead(CellStyle styleHead) {
        this.styleHead = styleHead;
    }

    public CellStyle getStyleBody() {
        return this.styleBody;
    }

    public void setStyleBody(CellStyle styleBody) {
        this.styleBody = styleBody;
    }

    public SimpleDateFormat getSdf() {
        return this.sdf;
    }

    public void setSdf(SimpleDateFormat sdf) {
        this.sdf = sdf;
    }

    public ExcelPoiUtil() {
        this.title = "sheet1";
        this.workbook = new XSSFWorkbook();
        this.mergedRegions = new HashSet<String>();
        this.init();
    }

    public ExcelPoiUtil(String title) {
        this.title = title;
        this.workbook = new XSSFWorkbook();
        this.mergedRegions = new HashSet<String>();
        this.init();
    }

    private void init() {
        this.styleHead = ExcelStyleUtil.initTitleStyle((Workbook)this.workbook, true, (short)11);
        this.styleBody = ExcelStyleUtil.initStyles((Workbook)this.workbook);
    }

    public XSSFWorkbook exportWorkbook(List<ColEntityVO> listTpamsColEntity, List<T> datas) throws Exception {
        this.splitDataToSheets(this.title, datas, listTpamsColEntity, null, false);
        ExcelStyleUtil.setStyleByType((Workbook)this.workbook, null, 0, null);
        return this.workbook;
    }

    public XSSFWorkbook exportWorkbook(List<ColEntityVO> listTpamsColEntity, List<T> datas, List<Integer> mergeIndex) throws Exception {
        this.splitDataToSheets(this.title, datas, listTpamsColEntity, mergeIndex, false);
        ExcelStyleUtil.setStyleByType((Workbook)this.workbook, null, 0, null);
        return this.workbook;
    }

    public XSSFWorkbook exportWorkbook(List<ColEntityVO> listTpamsColEntity, List<T> datas, int type, List<Integer> autoRowHeight) throws Exception {
        this.splitDataToSheets(this.title, datas, listTpamsColEntity, null, false);
        ExcelStyleUtil.setStyleByType((Workbook)this.workbook, null, type, autoRowHeight);
        return this.workbook;
    }

    public XSSFWorkbook exportWorkbook(List<ColEntityVO> listTpamsColEntity, List<T> datas, int type, List<Integer> autoRowHeight, List<Integer> mergeIndex) throws Exception {
        this.splitDataToSheets(this.title, datas, listTpamsColEntity, mergeIndex, false);
        ExcelStyleUtil.setStyleByType((Workbook)this.workbook, null, type, autoRowHeight);
        return this.workbook;
    }

    public XSSFWorkbook exportWorkbook(Map<String, List<ColEntityVO>> titles, Map<String, List<T>> datas, int type, List<Integer> autoRowHeight, List<Integer> mergeIndex) throws Exception {
        for (String sheetName : titles.keySet()) {
            List<ColEntityVO> colEntityList = titles.get(sheetName);
            List<T> tList = datas.get(sheetName);
            this.splitDataToSheets(sheetName, tList, colEntityList, mergeIndex, false);
        }
        ExcelStyleUtil.setStyleByType((Workbook)this.workbook, null, type, autoRowHeight);
        return this.workbook;
    }

    public XSSFWorkbook exportWorkbook(Map<String, List<ColEntityVO>> titles, Map<String, List<T>> datas, Map<String, Integer> types, Map<String, List<Integer>> autoRowHeights, Map<String, List<Integer>> mergeIndexs) throws Exception {
        for (String sheetName : titles.keySet()) {
            List<ColEntityVO> colEntityList = titles.get(sheetName);
            List<T> tList = datas.get(sheetName);
            int type = types == null ? 0 : (types.get(sheetName) == null ? 0 : types.get(sheetName));
            List<Integer> autoRowHeight = autoRowHeights == null ? null : autoRowHeights.get(sheetName);
            List<Integer> mergeIndex = mergeIndexs == null ? null : mergeIndexs.get(sheetName);
            this.splitDataToSheets(sheetName, tList, colEntityList, mergeIndex, false);
            ExcelStyleUtil.setStyleByType((Workbook)this.workbook, sheetName, type, autoRowHeight);
        }
        return this.workbook;
    }

    public void save(XSSFWorkbook workbook, String filePath) {
        File file = new File(filePath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fOut = null;
        try {
            fOut = new FileOutputStream(file);
            workbook.write((OutputStream)fOut);
            fOut.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (null != fOut) {
                fOut.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeSheet(XSSFSheet sheet, List<T> data, List<ColEntityVO> headerCellList, List<Integer> mergeIndex, boolean rowFlag) throws Exception {
        sheet = this.createHead(sheet, headerCellList.get(0).getTotalRow(), headerCellList.get(0).getTotalCol());
        this.createHead(headerCellList, sheet, 0);
        this.writeSheetContent(headerCellList, data, sheet, headerCellList.get(0).getTotalRow(), mergeIndex, rowFlag);
    }

    private void splitDataToSheets(String sheetName, List<T> data, List<ColEntityVO> headerCellList, List<Integer> mergeIndex, boolean rowFlag) throws Exception {
        int dataCount = data.size();
        int maxColEntity = 65535;
        int pieces = dataCount / maxColEntity;
        for (int i = 1; i <= pieces; ++i) {
            XSSFSheet sheet = this.workbook.createSheet(sheetName + i);
            List<T> subList = data.subList((i - 1) * maxColEntity, i * maxColEntity);
            this.writeSheet(sheet, subList, headerCellList, mergeIndex, rowFlag);
        }
        XSSFSheet sheet = this.workbook.createSheet(sheetName);
        this.writeSheet(sheet, data.subList(pieces * maxColEntity, dataCount), headerCellList, mergeIndex, rowFlag);
    }

    private void writeSheetContent(List<ColEntityVO> headerCellList, List<T> datas, XSSFSheet sheet, int rowIndex, List<Integer> mergeIndex, boolean rowFlag) throws Exception {
        boolean isMerge = false;
        if (mergeIndex != null && !mergeIndex.isEmpty()) {
            isMerge = true;
        }
        XSSFRow row = null;
        ArrayList<ColEntityVO> listCol = new ArrayList<ColEntityVO>();
        rowFlag = false;
        if (rowFlag) {
            int i = 0;
            int index = rowIndex;
            while (i < datas.size()) {
                row = sheet.createRow(index);
                for (int j = 0; j < headerCellList.size(); ++j) {
                    this.createColl(row, j, headerCellList.get(j).getFieldName(), datas.get(i));
                }
                ++i;
                ++index;
            }
        } else {
            this.getColEntityList(headerCellList, listCol);
            HashMap<Integer, Map<Integer, String>> mergeMaps = new HashMap<Integer, Map<Integer, String>>();
            Map<Integer, String> mergeMap = null;
            int i = 0;
            int index = rowIndex;
            while (i < datas.size()) {
                row = sheet.createRow(index);
                for (int j = 0; j < listCol.size(); ++j) {
                    ColEntityVO c = (ColEntityVO)listCol.get(j);
                    XSSFCell col = this.createCol(row, c, datas.get(i));
                    if (col.toString().length() <= 0 || !isMerge || !mergeIndex.contains(c.getCol())) continue;
                    mergeMap = mergeMaps.get(c.getCol()) != null ? (Map)mergeMaps.get(c.getCol()) : new HashMap<Integer, String>();
                    mergeMap.put(index, col.toString());
                    mergeMaps.put(c.getCol(), mergeMap);
                }
                ++i;
                ++index;
            }
            if (isMerge) {
                this.mergedCells(mergeMaps, sheet);
            }
        }
    }

    private void mergedCells(Map<Integer, Map<Integer, String>> mergeMaps, XSSFSheet sheet) {
        for (Integer colNum : mergeMaps.keySet()) {
            Map<Integer, String> mergeMap = mergeMaps.get(colNum);
            Map<String, List<Map.Entry>> result = mergeMap.entrySet().stream().collect(Collectors.groupingBy(c -> (String)c.getValue()));
            for (String key : result.keySet()) {
                int end;
                List<Map.Entry> list = result.get(key);
                int start = (Integer)list.get(0).getKey();
                if (start >= (end = ((Integer)list.get(list.size() - 1).getKey()).intValue())) continue;
                sheet.addMergedRegion(new CellRangeAddress(start, end, colNum.intValue(), colNum.intValue()));
            }
        }
    }

    private void createColl(XSSFRow row, int j, String finame, T t) {
        XSSFCell cell = row.createCell(j);
        cell.setCellStyle(this.styleBody);
        String text = "";
        if (t instanceof List) {
            List temp = (List)t;
            if (j >= temp.size()) {
                return;
            }
            text = String.valueOf(((Map)temp.get(j)).get(finame) == null ? "" : ((Map)temp.get(j)).get(finame));
        }
        XSSFRichTextString richString = new XSSFRichTextString(text);
        cell.setCellValue((RichTextString)richString);
    }

    private void getColEntityList(List<ColEntityVO> list, List<ColEntityVO> listCol) {
        for (ColEntityVO ColEntity : list) {
            List<ColEntityVO> listChildren;
            if (ColEntity.getFieldName() != null) {
                listCol.add(ColEntity);
            }
            if ((listChildren = ColEntity.getCellList()).size() <= 0) continue;
            this.getColEntityList(listChildren, listCol);
        }
    }

    public int createRowVal(XSSFRow row, ColEntityVO tpamsColEntity, T v, int j) throws Exception {
        if (tpamsColEntity.getCellList() != null && tpamsColEntity.getCellList().size() > 0) {
            for (int i = 0; i < tpamsColEntity.getCellList().size(); ++i) {
                this.createRowVal(row, tpamsColEntity.getCellList().get(i), v, j);
            }
        } else {
            this.createCol(row, tpamsColEntity, v);
        }
        return j;
    }

    public XSSFCell createCol(XSSFRow row, ColEntityVO colEntity, T v) throws Exception {
        XSSFCell cell = row.createCell(colEntity.getCol());
        cell.setCellStyle(this.styleBody);
        Object[] value = new Object[]{null};
        if (v instanceof Map) {
            Map m = (Map)v;
            m.forEach((k, val) -> {
                if (k.equals(colEntity.getFieldName()) && !colEntity.isHasChildren()) {
                    value[0] = val;
                }
            });
        } else {
            Class<?> cls = v.getClass();
            Field[] fields = cls.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                f.setAccessible(true);
                if (colEntity.getFieldName().equals(f.getName()) && !colEntity.isHasChildren()) {
                    value[0] = f.get(v);
                }
                if (!(value[0] instanceof Date)) continue;
                value[0] = this.parseDate((Date)value[0]);
            }
        }
        if (value[0] != null) {
            XSSFRichTextString richString = new XSSFRichTextString(value[0].toString());
            cell.setCellValue((RichTextString)richString);
        }
        return cell;
    }

    private String parseDate(Date date) {
        String dateStr = "";
        try {
            dateStr = this.sdf.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dateStr;
    }

    public XSSFSheet createHead(XSSFSheet sheetCo, int r, int c) {
        for (int i = 0; i < r; ++i) {
            XSSFRow row = sheetCo.createRow(i);
            for (int j = 0; j < c; ++j) {
                row.createCell(j);
            }
        }
        return sheetCo;
    }

    public void createHead(List<ColEntityVO> cellList, XSSFSheet sheetCo, int rowIndex) {
        XSSFRow row = sheetCo.getRow(rowIndex);
        int len = cellList.size();
        for (int i = 0; i < len; ++i) {
            int endC;
            ColEntityVO colEntity = cellList.get(i);
            int r = colEntity.getRow();
            int rLen = colEntity.getRLen();
            int c = colEntity.getCol();
            int cLen = colEntity.getCLen();
            int endR = r + rLen;
            if (endR > r) {
                --endR;
            }
            if ((endC = c + cLen) > c) {
                --endC;
            }
            XSSFCell cell = row.getCell(c);
            XSSFRichTextString text = new XSSFRichTextString(colEntity.getContent());
            cell.setCellStyle(this.styleHead);
            cell.setCellValue((RichTextString)text);
            CellRangeAddress cra = new CellRangeAddress(r, endR, c, endC);
            String craKey = r + "," + endR + "," + c + "," + endC;
            if (cra.getNumberOfCells() > 1 && !this.mergedRegions.contains(craKey)) {
                sheetCo.addMergedRegion(cra);
                this.mergedRegions.add(craKey);
            }
            sheetCo.setColumnWidth(c, colEntity.getWidth() * 256);
            RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheetCo);
            RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheetCo);
            RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheetCo);
            if (!colEntity.isHasChildren()) continue;
            rowIndex = r + 1;
            this.createHead(colEntity.getCellList(), sheetCo, rowIndex);
        }
    }

    public List<ColEntityVO> colEntityTransformer(List<T> list) {
        ArrayList<ColEntityVO> lc = new ArrayList<ColEntityVO>();
        if (list.get(0) instanceof Map) {
            int[] i = new int[]{1};
            for (Map m : list) {
                m.forEach((k, val) -> {
                    ColEntityVO tpamsColEntity = new ColEntityVO();
                    tpamsColEntity.setId(String.valueOf(i[0]));
                    tpamsColEntity.setPid("0");
                    tpamsColEntity.setContent((String)k);
                    tpamsColEntity.setFieldName((String)val);
                    tpamsColEntity.setWidth(20);
                    lc.add(tpamsColEntity);
                    i[0] = i[0] + 1;
                });
            }
        } else {
            int i = 1;
            for (String s : list) {
                ColEntityVO tpamsColEntity = new ColEntityVO();
                tpamsColEntity.setId(String.valueOf(i));
                tpamsColEntity.setPid("0");
                tpamsColEntity.setContent(s);
                tpamsColEntity.setFieldName(null);
                tpamsColEntity.setWidth(20);
                lc.add(tpamsColEntity);
                ++i;
            }
        }
        ExcelPoiUtil.setParm(lc, "0");
        List<ColEntityVO> s = ExcelTreeUtil.buildByRecursive(lc, "0");
        ExcelPoiUtil.setColNum(lc, s);
        return s;
    }

    public List<ColEntityVO> colEntityTransformer(List<T> list, Map<String, String> parm, String rootid) throws Exception {
        ArrayList<ColEntityVO> lc = new ArrayList<ColEntityVO>();
        if (list.get(0) instanceof Map) {
            for (Map m : list) {
                ColEntityVO colEntity = new ColEntityVO();
                m.forEach((k, val) -> {
                    if (((String)parm.get("id")).equals(k)) {
                        colEntity.setId(String.valueOf(val));
                    }
                    if (((String)parm.get("pid")).equals(k)) {
                        colEntity.setPid((String)val);
                    }
                    if (((String)parm.get("content")).equals(k)) {
                        colEntity.setContent((String)val);
                    }
                    if (parm.get("fieldName") != null && ((String)parm.get("fieldName")).equals(k)) {
                        colEntity.setFieldName((String)val);
                    }
                    if (parm.get("width") != null && ((String)parm.get("width")).equals(k)) {
                        colEntity.setWidth(Integer.parseInt(val.toString()));
                    }
                });
                lc.add(colEntity);
            }
        } else {
            for (T t : list) {
                ColEntityVO colEntity = new ColEntityVO();
                Class<?> cls = t.getClass();
                Field[] fs = cls.getDeclaredFields();
                for (int i = 0; i < fs.length; ++i) {
                    Field f = fs[i];
                    f.setAccessible(true);
                    if (parm.get("id").equals(f.getName()) && f.get(t) != null) {
                        colEntity.setId(f.get(t).toString());
                    }
                    if (parm.get("pid").equals(f.getName()) && f.get(t) != null) {
                        colEntity.setPid(f.get(t).toString());
                    }
                    if (parm.get("content").equals(f.getName()) && f.get(t) != null) {
                        colEntity.setContent(f.get(t).toString());
                    }
                    if (f.get(t) != null && parm.get("fieldName") != null && parm.get("fieldName").equals(f.getName())) {
                        colEntity.setFieldName(f.get(t).toString());
                    }
                    if (!parm.get("width").equals(f.getName()) || f.get(t) == null) continue;
                    colEntity.setWidth(Integer.parseInt(f.get(t).toString()));
                }
                lc.add(colEntity);
            }
        }
        ExcelPoiUtil.setParm(lc, rootid);
        List<ColEntityVO> b = ExcelTreeUtil.getTree(lc, rootid);
        ExcelPoiUtil.setColNum(lc, b);
        return b;
    }

    public static void setParm(List<ColEntityVO> list, String rootid) {
        boolean row = false;
        int rLen = 0;
        List<ColEntityVO> tree = ExcelTreeUtil.getTree(list, rootid);
        ArrayList<Integer> nums = new ArrayList<Integer>();
        for (ColEntityVO colEntity : tree) {
            int depth = ExcelTreeUtil.getDepth(colEntity);
            nums.add(depth);
        }
        int totalRow = (Integer)Collections.max(nums);
        int totalCol = ExcelTreeUtil.getDownChildren(list, rootid);
        for (int i = 0; i < list.size(); ++i) {
            ColEntityVO poit = list.get(i);
            int tree_step = ExcelTreeUtil.getTreeStep(list, poit.getPid(), 0);
            poit.setTreeStep(tree_step);
            poit.setRow(tree_step);
            boolean hasCh = ExcelTreeUtil.hasChild(list, poit);
            poit.setHasChildren(hasCh);
            if (hasCh) {
                poit.setRLen(0);
            } else {
                if (tree_step < totalRow) {
                    rLen = totalRow - tree_step;
                }
                poit.setRLen(rLen);
            }
            poit.setTotalRow(totalRow);
            poit.setTotalCol(totalCol);
        }
    }

    public static void setColNum(List<ColEntityVO> list, List<ColEntityVO> treeList) {
        ArrayList<ColEntityVO> new_list = new ArrayList<ColEntityVO>();
        for (int i = 0; i < treeList.size(); ++i) {
            ColEntityVO poit = treeList.get(i);
            int col = ExcelTreeUtil.getParentCol(list, poit.getPid()).getCol();
            int brotherCol = ExcelTreeUtil.getBrotherChilNum(list, poit);
            poit.setCol(col + brotherCol);
            int cLen = ExcelTreeUtil.getDownChildren(list, poit.getId());
            if (cLen <= 1) {
                cLen = 0;
            }
            poit.setCLen(cLen);
            if (poit.getCellList().size() <= 0) continue;
            new_list.addAll(poit.getCellList());
        }
        if (new_list.size() > 0) {
            ExcelPoiUtil.setColNum(list, new_list);
        }
    }
}

