/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.email.core.listener;

import cn.hutool.json.JSONUtil;
import com.els.modules.email.api.dto.EmailConfigDTO;
import com.els.modules.email.api.dto.EmailSendLogDTO;
import com.els.modules.email.core.listener.EmailQueueListenerRunnable;
import com.els.modules.email.service.EmailConfigService;
import com.els.modules.email.service.EmailSendLogService;
import io.netty.util.concurrent.FastThreadLocalThread;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class EmailTaskRunListener
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmailTaskRunListener.class);
    @Autowired
    @Lazy
    private RedissonClient redissonClient;
    @Lazy
    @Resource(name="srmPoolTaskExecutor")
    public ThreadPoolTaskExecutor srmPoolTaskExecutor;
    @Resource
    @Lazy
    private EmailConfigService emailConfigService;
    @Resource
    @Lazy
    private EmailSendLogService emailSendLogService;

    public void afterPropertiesSet() {
        RBlockingQueue queue = this.redissonClient.getBlockingQueue("srm:base:email:send:queue");
        EmailQueueListenerRunnable runnable = new EmailQueueListenerRunnable(this.srmPoolTaskExecutor, (RBlockingQueue<EmailConfigDTO>)queue);
        ThreadPoolExecutor single = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> {
            FastThreadLocalThread t = new FastThreadLocalThread(r, "\u90ae\u4ef6\u53d1\u9001\u961f\u5217\u76d1\u542c\u7ebf\u7a0b-");
            t.setDaemon(false);
            t.setPriority(5);
            return t;
        });
        single.execute(runnable);
    }

    @Scheduled(cron="0 0 */1 * * ?")
    public void scanEmailTaskToQueue() {
        this.emailConfigService.updateEmailConfigWeight();
        List<EmailSendLogDTO> noSendEmailSendLog = this.emailSendLogService.getNoSendEmailSendLog();
        if (noSendEmailSendLog.isEmpty()) {
            return;
        }
        for (EmailSendLogDTO logDTO : noSendEmailSendLog) {
            String msgConfigContent = logDTO.getMsgConfigContent();
            EmailConfigDTO configDTO = (EmailConfigDTO)JSONUtil.toBean((String)msgConfigContent, EmailConfigDTO.class);
            if (null == configDTO) continue;
            configDTO.setSendLogId(logDTO.getId());
            RBlockingQueue blockingQueue = this.redissonClient.getBlockingQueue("srm:base:email:send:queue");
            blockingQueue.add((Object)configDTO);
        }
    }
}

