/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.controller;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SrmUtil;
import com.els.modules.im.entity.ImGroupChat;
import com.els.modules.im.entity.ImGroupChatLink;
import com.els.modules.im.service.IImGroupChatLinkService;
import com.els.modules.im.service.IImGroupChatService;
import com.els.modules.im.service.ImAccountLocalService;
import com.els.modules.im.vo.ImGroupChatLinkVO;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.annotation.Resource;
import java.io.Serializable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/im/chatGroupLink"})
public class ImGroupChatLinkController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImGroupChatLinkController.class);
    @Resource
    private IImGroupChatLinkService imChatGroupLinkServiceImpl;
    @Resource
    private IImGroupChatService imChatGroupServiceImpl;
    @Resource
    private ImAccountLocalService imAccountLocalServiceImpl;

    @Operation(summary="\u6839\u636e\u7fa4\u804aID\u83b7\u53d6\u5355\u636e\u8df3\u8f6c\u94fe\u63a5", description="\u6839\u636e\u7fa4\u804aID\u83b7\u53d6\u5355\u636e\u8df3\u8f6c\u94fe\u63a5")
    @GetMapping(value={"/configLink/{groupId}"})
    public Result<?> loadRouteLink(@PathVariable(value="groupId") String groupId) {
        String actionPath;
        ImGroupChat chatGroup = (ImGroupChat)((Object)this.imChatGroupServiceImpl.getById((Serializable)((Object)groupId)));
        if (null == chatGroup) {
            throw new ELSBootException(I18nUtil.translate((String)"\u4e0d\u5b58\u5728\u8be5\u7fa4"));
        }
        if (CharSequenceUtil.isBlank((CharSequence)chatGroup.getBusinessType()) || CharSequenceUtil.isBlank((CharSequence)chatGroup.getBusinessNumber())) {
            return Result.ok(null);
        }
        ImGroupChatLink configLink = this.imChatGroupLinkServiceImpl.loadLink(chatGroup.getBusinessType());
        if (null == configLink) {
            return Result.ok(null);
        }
        ImGroupChatLinkVO result = new ImGroupChatLinkVO();
        result.setBusinessNumber(chatGroup.getBusinessNumber());
        result.setLinkConfig(configLink.getLinkConfig());
        boolean flag = this.imAccountLocalServiceImpl.checkIfSameElsAccountByUserId(SrmUtil.getLoginUser().getElsAccount(), chatGroup.getGroupChatMasterId());
        String string = actionPath = flag ? configLink.getPurchaseRoutePath() : configLink.getSaleRoutePath();
        if (CharSequenceUtil.isBlank((CharSequence)actionPath)) {
            return Result.ok(null);
        }
        result.setActionPath(actionPath);
        return Result.ok((Object)result);
    }
}

