/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.InterfaceApp;
import com.els.modules.system.entity.InterfaceAppPermission;
import com.els.modules.system.service.InterfaceAppPermissionService;
import com.els.modules.system.service.InterfaceAppService;
import com.els.modules.system.vo.InterfaceAppVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u5e94\u7528\u7ba1\u7406")
@RestController
@RequestMapping(value={"/account/interfaceApp"})
public class InterfaceAppController
extends BaseController<InterfaceApp, InterfaceAppService> {
    @Autowired
    private InterfaceAppService interfaceAppService;
    @Autowired
    private InterfaceAppPermissionService interfaceAppPermissionService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"app#interfaceApp:list"})
    public Result<?> queryPageList(InterfaceApp interfaceApp, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)interfaceApp), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String elsAccount = this.getTenantId();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        IPage pageList = this.interfaceAppService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/listOwn"})
    @RequiresPermissions(value={"app#interfaceApp:list"})
    public Result<?> listOwn(InterfaceApp interfaceApp, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)interfaceApp), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)this.getTenantId());
        IPage pageList = this.interfaceAppService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u5e94\u7528\u7ba1\u7406-\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"app#interfaceApp:add"})
    public Result<?> add(@RequestBody InterfaceAppVO interfaceAppVO) {
        InterfaceApp interfaceApp = new InterfaceApp();
        BeanUtils.copyProperties((Object)((Object)interfaceAppVO), (Object)((Object)interfaceApp));
        this.interfaceAppService.saveMain(interfaceApp, interfaceAppVO.getInterfacePermissionList());
        return Result.ok((Object)((Object)interfaceApp));
    }

    @AutoLog(value="\u5e94\u7528\u7ba1\u7406-\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"app#interfaceApp:edit"})
    public Result<?> edit(@RequestBody InterfaceAppVO interfaceAppVO) {
        InterfaceApp interfaceApp = new InterfaceApp();
        BeanUtils.copyProperties((Object)((Object)interfaceAppVO), (Object)((Object)interfaceApp));
        this.interfaceAppService.updateMain(interfaceApp, interfaceAppVO.getInterfacePermissionList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u5e94\u7528\u7ba1\u7406-\u91cd\u7f6e\u5bc6\u94a5")
    @Operation(summary="\u91cd\u7f6e\u5bc6\u94a5", description="\u91cd\u7f6e\u5bc6\u94a5")
    @GetMapping(value={"/resetSecret"})
    @RequiresPermissions(value={"app#interfaceApp:resetSecret"})
    public Result<?> resetSecret(@RequestParam(name="id") String id) {
        String secret = this.interfaceAppService.resetSecret(id);
        JSONObject object = new JSONObject();
        object.put("secret", (Object)secret);
        return Result.ok((Object)object);
    }

    @AutoLog(value="\u5e94\u7528\u7ba1\u7406-\u542f\u7528/\u505c\u7528")
    @Operation(summary="\u542f\u7528/\u505c\u7528", description="\u542f\u7528/\u505c\u7528")
    @GetMapping(value={"/startOrStop"})
    @RequiresPermissions(value={"app#interfaceApp:startOrStop"})
    public Result<?> startOrStop(@RequestParam(name="id") String id) {
        this.interfaceAppService.startOrStop(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u5e94\u7528\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"app#interfaceApp:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.interfaceAppService.delInterfaceApp(id);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"app#interfaceApp:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        InterfaceApp interfaceApp = (InterfaceApp)((Object)this.interfaceAppService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        if (interfaceApp == null) {
            throw new ELSBootException("id \u4e0d\u5b58\u5728\uff01");
        }
        InterfaceAppVO appVO = new InterfaceAppVO();
        BeanUtils.copyProperties((Object)((Object)interfaceApp), (Object)((Object)appVO));
        List<InterfaceAppPermission> interfaceAppPermissionList = this.interfaceAppPermissionService.selectByMainId(id);
        appVO.setInterfacePermissionList(interfaceAppPermissionList);
        return Result.ok((Object)((Object)appVO));
    }

    @PostMapping(value={"/testJsonArray"})
    public Result<?> testJsonArray(@RequestBody JSONArray array) {
        return Result.ok((Object)array);
    }
}

