/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.SupplierGroup;
import com.els.modules.system.entity.SupplierGroupItem;
import com.els.modules.system.entity.SupplierGroupPermission;
import com.els.modules.system.service.SupplierGroupItemService;
import com.els.modules.system.service.SupplierGroupPermissionService;
import com.els.modules.system.service.SupplierGroupService;
import com.els.modules.system.vo.SupplierGroupVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/account/supplierGroup"})
@Tag(name="\u4f9b\u5e94\u5546\u6743\u9650\u7ec4\u884c\u8868")
public class SupplierGroupController
extends BaseController<SupplierGroup, SupplierGroupService> {
    @Autowired
    private SupplierGroupService supplierGroupService;
    @Autowired
    private SupplierGroupItemService supplierGroupItemService;
    @Autowired
    private SupplierGroupPermissionService supplierGroupPermissionService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"account#supplierGroup:list"})
    public Result<?> queryPageList(SupplierGroup supplierGroup, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierGroup), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.supplierGroupService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(busModule="\u4f9b\u5e94\u5546\u6743\u9650\u7ec4", value="\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"account#supplierGroup:add"})
    public Result<?> add(@RequestBody SupplierGroupVO supplierGroupPage) {
        SupplierGroup supplierGroup = new SupplierGroup();
        BeanUtils.copyProperties((Object)((Object)supplierGroupPage), (Object)((Object)supplierGroup));
        this.supplierGroupService.saveMain(supplierGroup, supplierGroupPage.getSupplierGroupItemList());
        return Result.ok((Object)((Object)supplierGroup));
    }

    @SrmValidated
    @AutoLog(busModule="\u4f9b\u5e94\u5546\u6743\u9650\u7ec4", value="\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"account#supplierGroup:edit"})
    public Result<?> edit(@RequestBody SupplierGroupVO supplierGroupPage) {
        SupplierGroup supplierGroup = new SupplierGroup();
        BeanUtils.copyProperties((Object)((Object)supplierGroupPage), (Object)((Object)supplierGroup));
        this.supplierGroupService.updateMain(supplierGroup, supplierGroupPage.getSupplierGroupItemList());
        String id = supplierGroup.getId();
        return this.queryById(id);
    }

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u6743\u9650\u7ec4", value="\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"account#supplierGroup:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.supplierGroupService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"account#supplierGroup:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SupplierGroup supplierGroup = (SupplierGroup)((Object)this.supplierGroupService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        SupplierGroupVO supplierGroupVO = new SupplierGroupVO();
        BeanUtils.copyProperties((Object)((Object)supplierGroup), (Object)((Object)supplierGroupVO));
        List<SupplierGroupItem> supplierGroupItemList = this.supplierGroupItemService.selectByMainId(id);
        supplierGroupVO.setSupplierGroupItemList(supplierGroupItemList);
        return Result.ok((Object)((Object)supplierGroupVO));
    }

    @RequestMapping(value={"/queryTreeList"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"account#supplierGroup:auth"})
    @Operation(summary="\u67e5\u8be2\u83dc\u5355\u6743\u9650\u6811", description="\u67e5\u8be2\u83dc\u5355\u6743\u9650\u6811")
    public Result<?> queryTreeList() {
        Map<String, Object> resMap = this.supplierGroupService.queryTreeList();
        return Result.ok(resMap);
    }

    @RequestMapping(value={"/queryGroupPermission"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"account#supplierGroup:auth"})
    @Operation(summary="\u67e5\u8be2\u5df2\u6388\u6743\u7684\u6743\u9650", description="\u67e5\u8be2\u5df2\u6388\u6743\u7684\u6743\u9650")
    public Result<?> queryGroupPermission(@RequestParam(name="groupId") String groupId) {
        List resultList = this.supplierGroupPermissionService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).eq((Object)"group_id", (Object)groupId)).stream().map(SupplierGroupPermission::getPermissionId).collect(Collectors.toList());
        return Result.ok(resultList);
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u6743\u9650\u7ec4-\u4fdd\u5b58\u6388\u6743", operateType=3)
    @RequestMapping(value={"/saveGroupPermission"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"account#supplierGroup:auth"})
    @Operation(summary="\u4fdd\u5b58\u6388\u6743", description="\u4fdd\u5b58\u6388\u6743")
    public Result<?> saveGroupPermission(@RequestBody JSONObject json) {
        String groupId = json.getString("groupId");
        String permissionIds = json.getString("permissionIds");
        String lastPermissionIds = json.getString("lastpermissionIds");
        this.supplierGroupPermissionService.saveGroupPermission(groupId, permissionIds, lastPermissionIds);
        return Result.ok();
    }
}

