/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.integration.service.SrmToIPaasService;
import com.els.modules.system.entity.ElsCompanySet;
import com.els.modules.system.mapper.ElsCompanySetMapper;
import com.els.modules.system.service.ElsCompanySetService;
import com.els.modules.system.vo.ElsCompanySetVO;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElsCompanySetServiceImpl
extends ServiceImpl<ElsCompanySetMapper, ElsCompanySet>
implements ElsCompanySetService {
    private static final String SEARCH_AUTHORIZATION = "searchAuthorization";
    private static final String AUTHORIZATION_TO_PLATFORM = "authorizationToPlatform";
    private static final String REDIS_KEY = "srm:base:tenant:param:";
    @Resource
    private RedisUtil redisUtil;
    @Autowired
    private SrmToIPaasService iPaasService;

    private String authorizationToPlatform(String itemCode, String value) {
        if (!AUTHORIZATION_TO_PLATFORM.equals(itemCode)) {
            return null;
        }
        JSONObject data = new JSONObject();
        data.put("account", (Object)TenantContext.getTenant());
        data.put("auth", (Object)value);
        JSONObject result = this.iPaasService.callIPaasInterface(data, "enterpriseAuthUpdate");
        return result.containsKey((Object)"success") && result.getBoolean("success") == false && result.containsKey((Object)"message") ? "iPaaS\u5e73\u53f0\u3010\u4f01\u4e1a\u6388\u6743\u66f4\u65b0\u3011\u8c03\u7528\u51fa\u9519\uff1a" + result.getString("message") : null;
    }

    @Override
    public List<ElsCompanySetVO> findList(String elsAccount) {
        return ((ElsCompanySetMapper)this.baseMapper).findList(elsAccount, SysUtil.getPurchaseAccount());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public String save(List<ElsCompanySetVO> list) {
        String message = null;
        String elsAccount = TenantContext.getTenant();
        ((ElsCompanySetMapper)this.baseMapper).deleteByAccount(elsAccount);
        ArrayList<ElsCompanySet> companySetList = new ArrayList<ElsCompanySet>();
        for (ElsCompanySetVO vo : list) {
            ElsCompanySet companySet = new ElsCompanySet();
            BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)companySet));
            companySet.setId(null);
            companySet.setSystemId(vo.getId());
            companySet.setElsAccount(elsAccount);
            companySetList.add(companySet);
            if (SEARCH_AUTHORIZATION.equals(vo.getItemCode())) {
                // empty if block
            }
            message = this.authorizationToPlatform(vo.getItemCode(), vo.getDefaultValue());
        }
        if (!companySetList.isEmpty()) {
            this.saveBatch(companySetList);
        }
        String redisKey = this.getRedisKey(TenantContext.getTenant());
        this.redisUtil.del(new String[]{redisKey});
        return message;
    }

    private String getRedisKey(String elsAccount) {
        StringBuilder builder = new StringBuilder(REDIS_KEY);
        builder.append(elsAccount);
        return builder.toString();
    }

    @Override
    public JSONObject getParamObj(String elsAccount) {
        String redisKey = this.getRedisKey(elsAccount);
        JSONObject result = (JSONObject)this.redisUtil.get(redisKey);
        if (result != null) {
            return result;
        }
        result = new JSONObject();
        List<ElsCompanySetVO> paramList = this.findList(elsAccount);
        for (ElsCompanySet elsCompanySet : paramList) {
            result.put(elsCompanySet.getItemCode(), (Object)elsCompanySet.getDefaultValue());
        }
        this.redisUtil.set(redisKey, (Object)result);
        return result;
    }
}

