/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.RandomUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.system.entity.InterfaceApp;
import com.els.modules.system.entity.InterfaceAppPermission;
import com.els.modules.system.mapper.InterfaceAppMapper;
import com.els.modules.system.service.InterfaceAppPermissionService;
import com.els.modules.system.service.InterfaceAppService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class InterfaceAppServiceImpl
extends BaseServiceImpl<InterfaceAppMapper, InterfaceApp>
implements InterfaceAppService {
    public static final String REDIS_KEY = "interface:app:";
    @Resource
    private InterfaceAppPermissionService interfaceAppPermissionService;
    @Resource
    private RedisUtil redisUtil;

    @Override
    @Transactional
    public void delInterfaceApp(String id) {
        ((InterfaceAppMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.interfaceAppPermissionService.deleteByMainId(id);
    }

    @Override
    public String resetSecret(String id) {
        InterfaceApp app = (InterfaceApp)((Object)((InterfaceAppMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (app == null) {
            throw new ELSBootException("\u5e94\u7528\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01");
        }
        InterfaceApp updateApp = new InterfaceApp();
        updateApp.setId(id);
        updateApp.setAppSecret(IdUtil.simpleUUID());
        ((InterfaceAppMapper)this.baseMapper).updateById((Object)updateApp);
        String redisKey = REDIS_KEY + app.getAppKey() + app.getAppSecret();
        this.redisUtil.del(new String[]{redisKey});
        this.redisUtil.del(new String[]{REDIS_KEY + app.getId()});
        return updateApp.getAppSecret();
    }

    @Override
    public void startOrStop(String id) {
        InterfaceApp app = (InterfaceApp)((Object)((InterfaceAppMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (app == null) {
            throw new ELSBootException("\u5e94\u7528\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01");
        }
        String appStatus = app.getAppStatus();
        appStatus = "0".equals(appStatus) ? "1" : "0";
        InterfaceApp updateApp = new InterfaceApp();
        updateApp.setId(id);
        updateApp.setAppStatus(appStatus);
        ((InterfaceAppMapper)this.baseMapper).updateById((Object)updateApp);
        String redisKey = REDIS_KEY + app.getAppKey() + app.getAppSecret();
        this.redisUtil.del(new String[]{REDIS_KEY + app.getId()});
        this.redisUtil.del(new String[]{redisKey});
    }

    @Override
    public InterfaceApp getApp(String appKey, String appSecret) {
        String redisKey = REDIS_KEY + appKey + appSecret;
        InterfaceApp app = (InterfaceApp)((Object)this.redisUtil.get(redisKey));
        if (app == null) {
            app = (InterfaceApp)((Object)((InterfaceAppMapper)this.baseMapper).selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"app_key", (Object)appKey)).eq((Object)"app_secret", (Object)appSecret)));
            this.redisUtil.set(redisKey, (Object)app);
        }
        return app;
    }

    @Override
    public InterfaceApp getApp(String appId) {
        String redisKey = REDIS_KEY + appId;
        InterfaceApp app = (InterfaceApp)((Object)this.redisUtil.get(redisKey));
        if (app == null) {
            app = (InterfaceApp)((Object)((InterfaceAppMapper)this.baseMapper).selectById((Serializable)((Object)appId)));
            this.redisUtil.set(redisKey, (Object)app, 2L);
        }
        return app;
    }

    @Override
    public void saveMain(InterfaceApp interfaceApp, List<InterfaceAppPermission> openAppPermissionList) {
        interfaceApp.setAppKey(RandomUtil.randomString((int)8));
        interfaceApp.setAppSecret(IdUtil.simpleUUID());
        ((InterfaceAppMapper)this.baseMapper).insert((Object)interfaceApp);
        this.insertData(interfaceApp, openAppPermissionList);
    }

    private String getRedisKey(String key, String secret) {
        StringBuilder redisKey = new StringBuilder(REDIS_KEY);
        redisKey.append(key).append(":").append(secret);
        return redisKey.toString();
    }

    private void clearRedisCahce(String appKey, String appSecret) {
        String redisKey = this.getRedisKey(appKey, appSecret);
        this.redisUtil.del(new String[]{redisKey});
    }

    @Override
    public void updateMain(InterfaceApp interfaceApp, List<InterfaceAppPermission> openAppPermissionList) {
        int count = ((InterfaceAppMapper)this.baseMapper).update((Object)interfaceApp, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(ParentEntity::getId, (Object)interfaceApp.getId())).eq(ParentEntity::getElsAccount, (Object)this.getElsAccount()));
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"), (Object[])new Object[0]);
        this.interfaceAppPermissionService.deleteByMainId(interfaceApp.getId());
        this.clearRedisCahce(interfaceApp.getAppKey(), interfaceApp.getAppSecret());
        this.interfaceAppPermissionService.clearRedisCache(interfaceApp.getId());
        this.insertData(interfaceApp, openAppPermissionList);
    }

    private void insertData(InterfaceApp openApp, List<InterfaceAppPermission> openAppPermissionList) {
        if (!CollectionUtils.isEmpty(openAppPermissionList)) {
            for (InterfaceAppPermission entity : openAppPermissionList) {
                entity.setAppId(openApp.getId());
            }
            this.interfaceAppPermissionService.saveBatch(openAppPermissionList, 2000);
        }
    }
}

