/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.RoleDTO;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.RolePermission;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.mapper.RoleMapper;
import com.els.modules.system.mapper.UserRoleMapper;
import com.els.modules.system.service.PermissionService;
import com.els.modules.system.service.RolePermissionService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.util.ExcelPoiUtil;
import com.els.modules.system.vo.ColEntityVO;
import com.els.modules.system.vo.PermissionVO;
import com.google.common.collect.ImmutableMap;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class RoleServiceImpl
extends ServiceImpl<RoleMapper, Role>
implements RoleService {
    @Autowired
    private RolePermissionService rolePermissionService;
    @Autowired
    private UserRoleMapper userRoleMapper;

    @Override
    public void copy(Role role) {
        String suorceId = role.getId();
        List rolePermissionList = this.rolePermissionService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).eq((Object)"role_id", (Object)suorceId));
        Role newRole = new Role();
        BeanUtil.copyProperties((Object)((Object)role), (Object)((Object)newRole), (String[])new String[0]);
        newRole.setId(null);
        this.save((Object)newRole);
        ArrayList<RolePermission> permissionList = new ArrayList<RolePermission>();
        for (RolePermission permission : rolePermissionList) {
            RolePermission rolePermissionNew = new RolePermission();
            rolePermissionNew.setElsAccount(TenantContext.getTenant());
            rolePermissionNew.setRoleId(newRole.getId());
            rolePermissionNew.setPermissionId(permission.getPermissionId());
            rolePermissionNew.setId(IdWorker.getIdStr());
            permissionList.add(rolePermissionNew);
        }
        if (!permissionList.isEmpty()) {
            this.rolePermissionService.insertBatch(permissionList);
        }
    }

    @Override
    public List<RoleDTO> selectWithoutElsAccountOfAllRole(List<String> accountList) {
        List<Role> roleList = ((RoleMapper)this.baseMapper).selectWithoutElsAccountOfAllRole(accountList);
        if (!roleList.isEmpty() && roleList.size() > 0) {
            return SysUtil.copyProperties(roleList, RoleDTO.class);
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, String> loadAdminRole(List<String> toElsAccountList) {
        List<Role> roleList = ((RoleMapper)this.baseMapper).selectWithoutElsAccountOfAllAdminRole(toElsAccountList);
        return roleList.stream().collect(Collectors.toMap(ParentEntity::getElsAccount, ParentEntity::getId));
    }

    @Override
    public List<String> loadUserIdByElsAccountAndRoleCode(String elsAccount, List<String> roleCodes) {
        return ((RoleMapper)this.baseMapper).loadUserIdByElsAccountAndRoleCode(elsAccount, roleCodes);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteRole(String id) {
        LambdaUpdateWrapper wrapperRolePermission = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)wrapperRolePermission.eq(RolePermission::getElsAccount, (Object)TenantContext.getTenant())).eq(RolePermission::getRoleId, (Object)id);
        this.rolePermissionService.remove((Wrapper)wrapperRolePermission);
        ((RoleMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    private void checkRole(String roleId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(ParentEntity::getId, (Object)roleId);
        long count = ((RoleMapper)this.baseMapper).selectCount((Wrapper)wrapper);
        if (count == 0L) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_KyxMK_d29fc6bd", (String)"\u89d2\u8272\u4e0d\u5b58\u5728"));
        }
    }

    @Override
    public void addRoleUser(String userId, String roleId) {
        this.checkRole(roleId);
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(UserRole::getRoleId, (Object)roleId)).eq(UserRole::getUserId, (Object)userId);
        long count = this.userRoleMapper.selectCount((Wrapper)wrapper);
        if (count > 0L) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rjDIjjrKy_6088fd43", (String)"\u8be5\u7528\u6237\u5df2\u62e5\u6709\u8be5\u89d2\u8272"));
        }
        UserRole userRole = new UserRole();
        userRole.setRoleId(roleId);
        userRole.setUserId(userId);
        this.userRoleMapper.insert(userRole);
    }

    @Override
    public void removeRoleUser(String userId, String roleId) {
        this.checkRole(roleId);
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)wrapper.eq(UserRole::getRoleId, (Object)roleId)).eq(UserRole::getUserId, (Object)userId);
        this.userRoleMapper.delete((Wrapper)wrapper);
    }

    @Override
    public Role getRoleByElsAccountAndSysCode(String elsAccount, String code) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(ParentEntity::getElsAccount, (Object)elsAccount)).eq(Role::getRoleCode, (Object)code);
        Role role = (Role)((Object)((RoleMapper)this.baseMapper).selectOne((Wrapper)wrapper));
        return role;
    }

    @Override
    public void roleExport(HttpServletRequest request, HttpServletResponse res) {
        List<Role> roleList;
        String pageSize = request.getParameter("pageSize");
        String pageNo = request.getParameter("pageNo");
        String ids = request.getParameter("ids");
        List<String> idList = new ArrayList<String>();
        if (StrUtil.isNotBlank((CharSequence)ids)) {
            idList = Arrays.asList(ids.split(","));
        }
        if (!CollectionUtils.isEmpty(roleList = this.queryList(idList))) {
            HashMap<String, List<ColEntityVO>> heads = new HashMap<String, List<ColEntityVO>>();
            HashMap datas = new HashMap();
            HashMap<String, Integer> types = new HashMap<String, Integer>();
            HashMap autoRowHeights = new HashMap();
            HashMap<String, List<Integer>> mergeIndexs = new HashMap<String, List<Integer>>();
            ArrayList titleList = new ArrayList();
            HashMap<String, String> titleMap1 = new HashMap<String, String>();
            titleMap1.put("id", "8");
            titleMap1.put("pid", "0");
            titleMap1.put("content", "\u89d2\u8272\u540d\u79f0");
            titleMap1.put("fieldName", "u_role_name");
            titleMap1.put("width", "20");
            HashMap<String, String> titleMap2 = new HashMap<String, String>();
            titleMap2.put("id", "9");
            titleMap2.put("pid", "0");
            titleMap2.put("content", "\u89d2\u8272\u7f16\u7801");
            titleMap2.put("fieldName", "u_role_code");
            titleMap2.put("width", "20");
            titleList.add(titleMap1);
            titleList.add(titleMap2);
            List<PermissionVO> filterList = ((PermissionService)SpringContextUtils.getBean(PermissionService.class)).getCompanyMenuList(TenantContext.getTenant());
            ArrayList<String> companyAdminListIds = new ArrayList<String>();
            for (int i = 0; i < filterList.size(); ++i) {
                HashMap<String, Object> titleMap = new HashMap<String, Object>();
                titleMap.put("id", filterList.get(i).getId());
                titleMap.put("pid", StrUtil.isBlank((CharSequence)filterList.get(i).getParentId()) ? "0" : filterList.get(i).getParentId());
                titleMap.put("content", filterList.get(i).getName());
                titleMap.put("fieldName", "permissionId" + filterList.get(i).getId());
                titleMap.put("width", "20");
                titleList.add(titleMap);
                companyAdminListIds.add(filterList.get(i).getId());
            }
            ArrayList rowList = new ArrayList();
            List roleIds = roleList.stream().map(ParentEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.in(RolePermission::getRoleId, roleIds);
            List rolePermissionList = this.rolePermissionService.list((Wrapper)wrapper);
            Map<String, List<RolePermission>> rolePermissionListMap = rolePermissionList.stream().collect(Collectors.groupingBy(RolePermission::getRoleId));
            for (int i = 0; i < roleList.size(); ++i) {
                HashMap<Object, String> m = new HashMap<Object, String>();
                m.put("u_role_name", roleList.get(i).getRoleName());
                m.put("u_role_code", roleList.get(i).getRoleCode());
                if (roleList.get(i).getRoleCode().equals("companyAdmin")) {
                    for (String id : companyAdminListIds) {
                        m.put("permissionId" + id, "Y");
                    }
                    rowList.add(m);
                    continue;
                }
                List<RolePermission> temList = rolePermissionListMap.get(roleList.get(i).getId());
                if (CollUtil.isEmpty(temList)) continue;
                List collect = temList.stream().map(RolePermission::getPermissionId).collect(Collectors.toList());
                for (String str : collect) {
                    m.put("permissionId" + str, "Y");
                }
                rowList.add(m);
            }
            try {
                ExcelPoiUtil excelTool = new ExcelPoiUtil("\u89d2\u8272\u83dc\u5355\u5bf9\u5e94\u5173\u7cfb\u5bfc\u51fa");
                ImmutableMap param = ImmutableMap.builder().put((Object)"id", (Object)"id").put((Object)"pid", (Object)"pid").put((Object)"content", (Object)"content").put((Object)"fieldName", (Object)"fieldName").put((Object)"width", (Object)"width").build();
                List<ColEntityVO> titleData = excelTool.colEntityTransformer(titleList, (Map<String, String>)param, "0");
                heads.put("\u89d2\u8272\u83dc\u5355\u5bf9\u5e94\u5173\u7cfb\u5bfc\u51fa", titleData);
                datas.put("\u89d2\u8272\u83dc\u5355\u5bf9\u5e94\u5173\u7cfb\u5bfc\u51fa", rowList);
                types.put("\u89d2\u8272\u83dc\u5355\u5bf9\u5e94\u5173\u7cfb\u5bfc\u51fa", 0);
                mergeIndexs.put("\u89d2\u8272\u83dc\u5355\u5bf9\u5e94\u5173\u7cfb\u5bfc\u51fa", new ArrayList());
                XSSFWorkbook workbook = excelTool.exportWorkbook(heads, datas, types, null, mergeIndexs);
                res.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
                res.setHeader("Content-Disposition", "attachment;fileName=" + new String("\u89d2\u8272\u83dc\u5355\u5bf9\u5e94\u5173\u7cfb\u5bfc\u51fa.xlsx".getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
                workbook.write((OutputStream)res.getOutputStream());
                workbook.close();
            }
            catch (Exception e) {
                throw new ELSBootException(e.getMessage());
            }
        }
    }

    public List<Role> queryList(List<String> ids) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!CollectionUtils.isEmpty(ids)) {
            queryWrapper.lambda().in(ParentEntity::getId, ids);
        }
        queryWrapper.orderByDesc((Object)"id");
        queryWrapper.lambda().eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant());
        List pageList = this.list((Wrapper)queryWrapper);
        return pageList;
    }
}

